/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.mavenplugins.car.Maven2RepositoryAdapter;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.pluginsupport.MojoSupport;
import org.codehaus.mojo.pluginsupport.dependency.DependencyHelper;
import org.codehaus.mojo.pluginsupport.dependency.DependencyTree;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCarMojo
extends MojoSupport {
    protected MavenProject project;
    protected File basedir;
    protected MavenProjectHelper projectHelper;
    protected DependencyHelper dependencyHelper = null;
    protected ArtifactRepository artifactRepository = null;

    protected MavenProject getProject() {
        return this.project;
    }

    protected ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    protected void init() throws MojoExecutionException, MojoFailureException {
        super.init();
        this.dependencyHelper.setArtifactRepository(this.artifactRepository);
    }

    protected void generateExplicitVersionProperties(File outputFile, DependencyTree dependencies) throws MojoExecutionException, IOException {
        this.log.debug((CharSequence)("Generating explicit version properties: " + outputFile));
        Properties props = new Properties();
        try {
            DependencyTree.Node root = dependencies.getRootNode();
            for (DependencyTree.Node child : root.getChildren()) {
                this.appendExplicitVersionProperties(child, props);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to determine project dependencies", e);
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));
        props.store(output, null);
        output.flush();
        output.close();
    }

    private void appendExplicitVersionProperties(DependencyTree.Node node, Properties props) {
        assert (node != null);
        assert (props != null);
        org.apache.maven.artifact.Artifact artifact = node.getArtifact();
        if ("test".equals(artifact.getScope())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Skipping artifact with scope test: " + artifact));
            }
            return;
        }
        String name = artifact.getGroupId() + "/" + artifact.getArtifactId() + "//" + artifact.getType();
        String value = artifact.getGroupId() + "/" + artifact.getArtifactId() + "/" + artifact.getVersion() + "/" + artifact.getType();
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Setting " + name + "=" + value));
        }
        props.setProperty(name, value);
        if (!node.getChildren().isEmpty()) {
            for (DependencyTree.Node child : node.getChildren()) {
                this.appendExplicitVersionProperties(child, props);
            }
        }
    }

    protected static File getArchiveFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".car");
    }

    protected Artifact mavenToGeronimoArtifact(org.apache.maven.artifact.Artifact artifact) {
        assert (artifact != null);
        return new Artifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
    }

    protected Artifact mavenToGeronimoArtifact(Dependency artifact) {
        assert (artifact != null);
        return new Artifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
    }

    protected org.apache.maven.artifact.Artifact geronimoToMavenArtifact(Artifact artifact) throws MojoExecutionException {
        assert (artifact != null);
        ArtifactItem item = new ArtifactItem();
        item.setGroupId(artifact.getGroupId());
        item.setArtifactId(artifact.getArtifactId());
        item.setVersion(artifact.getVersion().toString());
        item.setType(artifact.getType());
        return this.createArtifact(item);
    }

    protected boolean isModuleArtifact(Artifact artifact) {
        assert (artifact != null);
        return "car".equals(artifact.getType());
    }

    protected boolean includeDependency(Dependency dependency) {
        if (dependency.getGroupId().startsWith("org.apache.geronimo.genesis")) {
            return false;
        }
        String scope = dependency.getScope();
        return scope == null || "runtime".equalsIgnoreCase(scope) || "compile".equalsIgnoreCase(scope);
    }

    protected Dependency resolveDependency(Dependency dependency, List<Dependency> artifacts) {
        for (Dependency match : artifacts) {
            if (!this.matches(dependency, match)) continue;
            return match;
        }
        throw new IllegalStateException("Dependency " + dependency + " is not resolved in project");
    }

    private boolean matches(Dependency dependency, Dependency match) {
        if (dependency.getGroupId() != null && !dependency.getGroupId().equals(match.getGroupId())) {
            return false;
        }
        if (dependency.getArtifactId() != null && !dependency.getArtifactId().equals(match.getArtifactId())) {
            return false;
        }
        return dependency.getType() == null || dependency.getType().equals(match.getType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ArtifactLookupImpl
    implements Maven2RepositoryAdapter.ArtifactLookup {
        private final Map<Artifact, org.apache.maven.artifact.Artifact> resolvedArtifacts;

        public ArtifactLookupImpl(Map<Artifact, org.apache.maven.artifact.Artifact> resolvedArtifacts) {
            this.resolvedArtifacts = resolvedArtifacts;
        }

        @Override
        public File getBasedir() {
            String path = AbstractCarMojo.this.getArtifactRepository().getBasedir();
            return new File(path);
        }

        private boolean isProjectArtifact(Artifact artifact) {
            MavenProject project = AbstractCarMojo.this.getProject();
            return artifact.getGroupId().equals(project.getGroupId()) && artifact.getArtifactId().equals(project.getArtifactId());
        }

        @Override
        public File getLocation(Artifact artifact) {
            File file;
            assert (artifact != null);
            boolean debug = AbstractCarMojo.this.log.isDebugEnabled();
            org.apache.maven.artifact.Artifact mavenArtifact = this.resolvedArtifacts.get(artifact);
            if (mavenArtifact == null) {
                mavenArtifact = AbstractCarMojo.this.getArtifactFactory().createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion().toString(), null, artifact.getType());
            }
            if (this.isProjectArtifact(artifact)) {
                if (debug) {
                    AbstractCarMojo.this.log.debug((CharSequence)("Skipping resolution of project artifact: " + artifact));
                }
                return new File(this.getBasedir(), AbstractCarMojo.this.getArtifactRepository().pathOf(mavenArtifact));
            }
            try {
                if (!mavenArtifact.isResolved()) {
                    if (debug) {
                        AbstractCarMojo.this.log.debug((CharSequence)("Resolving artifact: " + mavenArtifact));
                    }
                    mavenArtifact = AbstractCarMojo.this.resolveArtifact(mavenArtifact);
                    this.resolvedArtifacts.put(artifact, mavenArtifact);
                }
                String path = AbstractCarMojo.this.getArtifactRepository().pathOf(mavenArtifact);
                file = new File(this.getBasedir(), path);
                file = new File(mavenArtifact.getFile().getParentFile(), file.getName());
            }
            catch (MojoExecutionException e) {
                throw new RuntimeException("Failed to resolve: " + mavenArtifact, e);
            }
            return file;
        }
    }
}

