/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.WritableListableRepository;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.mavenplugins.car.Dependency;
import org.apache.geronimo.mavenplugins.car.UseMavenDependencies;
import org.apache.geronimo.system.configuration.RepositoryConfigurationStore;
import org.apache.geronimo.system.plugin.PluginInstallerGBean;
import org.apache.geronimo.system.plugin.PluginXmlUtil;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.geronimo.system.plugin.model.DependencyType;
import org.apache.geronimo.system.plugin.model.LicenseType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.apache.geronimo.system.repository.Maven2Repository;
import org.apache.maven.model.License;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class PluginMetadataGeneratorMojo
extends AbstractCarMojo {
    private File targetRepository = null;
    protected File targetDir = null;
    protected String pluginMetadataFileName = null;
    private boolean osiApproved;
    private String category;
    private List<Dependency> dependencies = Collections.emptyList();
    private UseMavenDependencies useMavenDependencies;
    private PlexusConfiguration commonInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() throws Exception {
        PluginArtifactType instance;
        Xpp3Dom dom;
        Plugin plugin;
        PluginType metadata = new PluginType();
        metadata.setName(this.project.getName());
        metadata.setAuthor(this.project.getOrganization() == null ? "unknown" : this.project.getOrganization().getName());
        metadata.setUrl(this.project.getOrganization() == null ? "unknown" : this.project.getOrganization().getUrl());
        metadata.setDescription(this.project.getDescription());
        metadata.setCategory(this.category);
        if (this.project.getLicenses() != null) {
            for (Object licenseObj : this.project.getLicenses()) {
                License license = (License)licenseObj;
                LicenseType licenseType = new LicenseType();
                licenseType.setValue(license.getName());
                licenseType.setOsiApproved(this.osiApproved);
                metadata.getLicense().add(licenseType);
            }
        }
        if ((plugin = (Plugin)this.project.getModel().getBuild().getPluginsAsMap().get("org.apache.geronimo.buildsupport:car-maven-plugin")) == null) {
            throw new Error("Unable to resolve car plugin");
        }
        if (plugin.getExecutions().isEmpty()) {
            dom = (Xpp3Dom)plugin.getConfiguration();
        } else {
            if (plugin.getExecutions().size() > 1) {
                throw new IllegalStateException("Cannot determine correct configuration for PluginMetadataGeneratorMojo: " + plugin.getExecutionsAsMap().keySet());
            }
            dom = (Xpp3Dom)((PluginExecution)plugin.getExecutions().get(0)).getConfiguration();
        }
        Xpp3Dom instanceDom = dom.getChild("instance");
        if (instanceDom == null || instanceDom.getChild("plugin-artifact") == null) {
            instance = new PluginArtifactType();
        } else {
            String instanceString = instanceDom.getChild("plugin-artifact").toString();
            instance = PluginXmlUtil.loadPluginArtifactMetadata((Reader)new StringReader(instanceString.replace("#{", "${")));
        }
        if (this.commonInstance != null && this.commonInstance.getChild("plugin-artifact") != null) {
            PluginArtifactType commonInstance = PluginXmlUtil.loadPluginArtifactMetadata((Reader)new StringReader(this.commonInstance.getChild("plugin-artifact").toString().replace("#{", "${")));
            if (instance.getArtifactAlias().isEmpty()) {
                instance.getArtifactAlias().addAll(commonInstance.getArtifactAlias());
            }
            if (instance.getConfigSubstitution().isEmpty()) {
                instance.getConfigSubstitution().addAll(commonInstance.getConfigSubstitution());
            }
            if (instance.getCopyFile().isEmpty()) {
                instance.getCopyFile().addAll(commonInstance.getCopyFile());
            }
            if (instance.getDependency().isEmpty()) {
                instance.getDependency().addAll(commonInstance.getDependency());
            }
            if (instance.getGeronimoVersion().isEmpty()) {
                instance.getGeronimoVersion().addAll(commonInstance.getGeronimoVersion());
            }
            if (instance.getJvmVersion().isEmpty()) {
                instance.getJvmVersion().addAll(commonInstance.getJvmVersion());
            }
            if (instance.getObsoletes().isEmpty()) {
                instance.getObsoletes().addAll(commonInstance.getObsoletes());
            }
            if (instance.getPrerequisite().isEmpty()) {
                instance.getPrerequisite().addAll(commonInstance.getPrerequisite());
            }
            if (instance.getSourceRepository().isEmpty()) {
                instance.getSourceRepository().addAll(commonInstance.getSourceRepository());
            }
        }
        metadata.getPluginArtifact().add(instance);
        ArtifactType artifactType = new ArtifactType();
        artifactType.setGroupId(this.project.getGroupId());
        artifactType.setArtifactId(this.project.getArtifactId());
        artifactType.setVersion(this.project.getVersion());
        ArtifactType existingArtifact = instance.getModuleId();
        if (existingArtifact != null && existingArtifact.getType() != null) {
            artifactType.setType(existingArtifact.getType());
        } else {
            artifactType.setType(this.project.getArtifact().getType());
        }
        instance.setModuleId(artifactType);
        this.addDependencies(instance);
        this.targetDir.mkdirs();
        File targetFile = new File(this.targetDir.toURI().resolve(this.pluginMetadataFileName));
        targetFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(targetFile);
        try {
            PluginXmlUtil.writePluginMetadata((PluginType)metadata, (OutputStream)out);
        }
        finally {
            out.close();
        }
        Resource resource = new Resource();
        resource.setDirectory(this.targetDir.getPath());
        resource.addInclude(this.pluginMetadataFileName);
        this.getProject().getResources().add(resource);
    }

    private void addDependencies(PluginArtifactType instance) throws InvalidConfigException, IOException, NoSuchConfigException {
        if (this.useMavenDependencies == null || !this.useMavenDependencies.isValue()) {
            for (Dependency dependency : this.dependencies) {
                instance.getDependency().add(dependency.toDependencyType());
            }
        } else if (this.targetRepository.exists() && this.targetRepository.isDirectory()) {
            Maven2Repository targetRepo = new Maven2Repository(this.targetRepository);
            RepositoryConfigurationStore configStore = new RepositoryConfigurationStore((WritableListableRepository)targetRepo);
            Artifact pluginArtifact = PluginInstallerGBean.toArtifact((ArtifactType)instance.getModuleId());
            ConfigurationData data = configStore.loadConfiguration(pluginArtifact);
            PluginInstallerGBean.addGeronimoDependencies((ConfigurationData)data, (List)instance.getDependency(), (boolean)this.useMavenDependencies.isIncludeVersion());
        } else {
            List includedDependencies = this.project.getOriginalModel().getDependencies();
            List artifacts = this.project.getDependencies();
            for (org.apache.maven.model.Dependency dependency : includedDependencies) {
                if (!this.includeDependency(dependency = this.resolveDependency(dependency, artifacts))) continue;
                DependencyType gdep = PluginMetadataGeneratorMojo.toGeronimoDependency(dependency, this.useMavenDependencies.isIncludeVersion());
                instance.getDependency().add(gdep);
            }
        }
    }

    private static DependencyType toGeronimoDependency(org.apache.maven.model.Dependency dependency, boolean includeVersion) {
        DependencyType dependencyType = new DependencyType();
        dependencyType.setGroupId(dependency.getGroupId());
        dependencyType.setArtifactId(dependency.getArtifactId());
        if (includeVersion) {
            dependencyType.setVersion(dependency.getVersion());
        }
        dependencyType.setType(dependency.getType());
        dependencyType.setStart(Boolean.valueOf(true));
        return dependencyType;
    }
}

