/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xbeans.ArtifactType;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.mavenplugins.car.Dependency;
import org.apache.geronimo.mavenplugins.car.UseMavenDependencies;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanProcessorMojo
extends AbstractCarMojo {
    private static final String ENVIRONMENT_LOCAL_NAME = "environment";
    private static final QName ENVIRONMENT_QNAME = new QName("http://geronimo.apache.org/xml/ns/deployment-1.2", "environment");
    protected File sourceDir = null;
    protected File targetDir = null;
    protected String planFileName = null;
    protected File targetFile = null;
    private List<Dependency> dependencies = Collections.emptyList();
    private UseMavenDependencies useMavenDependencies;

    private VelocityContext createContext() {
        VelocityContext context = new VelocityContext();
        Properties props = this.project.getProperties();
        for (Object o : props.keySet()) {
            String key = (String)o;
            String value = props.getProperty(key);
            this.log.debug((CharSequence)("Setting " + key + "=" + value));
            context.put(key, (Object)value);
        }
        context.put("pom", (Object)this.project);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() throws Exception {
        VelocityContext context = this.createContext();
        VelocityEngine velocity = new VelocityEngine();
        velocity.setProperty("file.resource.loader.path", (Object)this.sourceDir.getAbsolutePath());
        velocity.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        velocity.init();
        Template template = velocity.getTemplate(this.planFileName);
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        String plan = writer.toString();
        XmlObject doc = XmlObject.Factory.parse((String)plan);
        XmlCursor xmlCursor = doc.newCursor();
        LinkedHashSet<org.apache.geronimo.kernel.repository.Dependency> dependencies = this.toDependencies();
        Artifact configId = new Artifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "car");
        try {
            this.mergeEnvironment(xmlCursor, configId, dependencies);
            if (this.targetDir.exists()) {
                if (!this.targetDir.isDirectory()) {
                    throw new RuntimeException("TargetDir: " + this.targetDir + " exists and is not a directory");
                }
            } else {
                this.targetDir.mkdirs();
            }
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setSavePrettyPrint();
            doc.save(this.targetFile, xmlOptions);
            this.log.info((CharSequence)("Generated: " + this.targetFile));
        }
        finally {
            xmlCursor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeEnvironment(XmlCursor xmlCursor, Artifact configId, LinkedHashSet<org.apache.geronimo.kernel.repository.Dependency> dependencies) {
        Environment oldEnvironment;
        EnvironmentType environmentType;
        QName childName;
        this.moveToFirstStartElement(xmlCursor);
        boolean atLeastOneChild = xmlCursor.toFirstChild();
        if (!atLeastOneChild) {
            xmlCursor.toEndToken();
        }
        if ((childName = xmlCursor.getName()) != null && childName.getLocalPart().equals(ENVIRONMENT_LOCAL_NAME)) {
            this.convertElement(xmlCursor, ENVIRONMENT_QNAME.getNamespaceURI());
            XmlObject xmlObject = xmlCursor.getObject();
            environmentType = (EnvironmentType)xmlObject.copy().changeType(EnvironmentType.type);
            oldEnvironment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType);
            xmlCursor.removeXml();
        } else {
            oldEnvironment = new Environment();
        }
        Environment newEnvironment = new Environment();
        newEnvironment.setConfigId(configId);
        newEnvironment.setDependencies(dependencies);
        EnvironmentBuilder.mergeEnvironments((Environment)oldEnvironment, (Environment)newEnvironment);
        environmentType = EnvironmentBuilder.buildEnvironmentType((Environment)oldEnvironment);
        xmlCursor.beginElement(ENVIRONMENT_QNAME);
        XmlCursor element = environmentType.newCursor();
        try {
            element.copyXmlContents(xmlCursor);
        }
        finally {
            element.dispose();
        }
    }

    private void moveToFirstStartElement(XmlCursor xmlCursor) throws AssertionError {
        xmlCursor.toStartDoc();
        xmlCursor.toFirstChild();
        while (!xmlCursor.currentTokenType().isStart() && xmlCursor.toNextSibling()) {
        }
        if (!xmlCursor.currentTokenType().isStart()) {
            throw new AssertionError((Object)"Cannot find first start element");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertElement(XmlCursor cursor, String namespace) {
        cursor.push();
        XmlCursor end = cursor.newCursor();
        try {
            end.toCursor(cursor);
            end.toEndToken();
            while (cursor.hasNextToken() && cursor.isLeftOf(end)) {
                if (cursor.isStart() && !namespace.equals(cursor.getName().getNamespaceURI())) {
                    cursor.setName(new QName(namespace, cursor.getName().getLocalPart()));
                }
                cursor.toNextToken();
            }
            cursor.pop();
        }
        finally {
            end.dispose();
        }
    }

    private LinkedHashSet<org.apache.geronimo.kernel.repository.Dependency> toDependencies() {
        LinkedHashSet<org.apache.geronimo.kernel.repository.Dependency> dependencies = new LinkedHashSet<org.apache.geronimo.kernel.repository.Dependency>();
        if (this.useMavenDependencies == null || !this.useMavenDependencies.isValue()) {
            for (Dependency dependency : this.dependencies) {
                org.apache.geronimo.kernel.repository.Dependency gdep = dependency.toDependency();
                dependencies.add(gdep);
            }
        } else {
            List includedDependencies = this.project.getOriginalModel().getDependencies();
            List artifacts = this.project.getDependencies();
            for (org.apache.maven.model.Dependency dependency : includedDependencies) {
                if (!this.includeDependency(dependency = this.resolveDependency(dependency, artifacts))) continue;
                org.apache.geronimo.kernel.repository.Dependency gdep = PlanProcessorMojo.toGeronimoDependency(dependency, this.useMavenDependencies.isIncludeVersion());
                dependencies.add(gdep);
            }
        }
        return dependencies;
    }

    private static org.apache.geronimo.kernel.repository.Dependency toGeronimoDependency(org.apache.maven.model.Dependency dependency, boolean includeVersion) {
        Artifact artifact = PlanProcessorMojo.toGeronimoArtifact(dependency, includeVersion);
        return new org.apache.geronimo.kernel.repository.Dependency(artifact, ImportType.ALL);
    }

    private static Artifact toGeronimoArtifact(org.apache.maven.model.Dependency dependency, boolean includeVersion) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        String version = includeVersion ? dependency.getVersion() : null;
        String type = dependency.getType();
        return new Artifact(groupId, artifactId, version, type);
    }

    static interface Inserter {
        public ArtifactType insert(EnvironmentType var1);
    }
}

