/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.kernel.repository.Maven2Repository;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.system.plugin.PluginInstallerGBean;
import org.apache.geronimo.system.plugin.PluginXmlUtil;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.xml.sax.SAXException;

public class CreatePluginListMojo
extends AbstractCarMojo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() throws Exception {
        String path = this.getArtifactRepository().getBasedir();
        File baseDir = new File(path);
        Maven2Repository repository = new Maven2Repository(baseDir);
        PluginListType pluginList = this.createPluginListForRepositories((ListableRepository)repository, path);
        File outFile = new File(baseDir, "geronimo-plugins.xml");
        FileWriter out = new FileWriter(outFile, false);
        try {
            PluginXmlUtil.writePluginList((PluginListType)pluginList, (Writer)out);
        }
        finally {
            ((Writer)out).close();
        }
    }

    public PluginListType createPluginListForRepositories(ListableRepository repository, String repoName) throws NoSuchStoreException {
        HashMap<PluginType, PluginType> pluginMap = new HashMap<PluginType, PluginType>();
        SortedSet configs = repository.list();
        for (Artifact configId : configs) {
            PluginType data = this.getPluginMetadata(repository, configId);
            if (data == null) continue;
            PluginType key = PluginInstallerGBean.toKey((PluginType)data);
            PluginType existing = (PluginType)pluginMap.get(key);
            if (existing == null) {
                pluginMap.put(key, data);
                continue;
            }
            existing.getPluginArtifact().addAll(data.getPluginArtifact());
        }
        PluginListType pluginList = new PluginListType();
        pluginList.getPlugin().addAll(pluginMap.values());
        pluginList.getDefaultRepository().add(repoName);
        return pluginList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private PluginType getPluginMetadata(ListableRepository repository, Artifact configId) {
        File dir = repository.getLocation(configId);
        if (!dir.isFile() || !dir.canRead()) {
            this.log.error((CharSequence)("Cannot read artifact dir " + dir.getAbsolutePath()));
            throw new IllegalStateException("Cannot read artifact dir " + dir.getAbsolutePath());
        }
        if (dir.toString().endsWith(".pom")) {
            return null;
        }
        try {
            JarFile jar = new JarFile(dir);
            try {
                PluginType pluginType;
                InputStream in;
                block18: {
                    PluginType pluginType2;
                    ZipEntry entry = jar.getEntry("META-INF/geronimo-plugin.xml");
                    if (entry == null) {
                        PluginType pluginType3 = null;
                        return pluginType3;
                    }
                    in = jar.getInputStream(entry);
                    try {
                        pluginType = PluginXmlUtil.loadPluginMetadata((InputStream)in);
                        if (!pluginType.getPluginArtifact().isEmpty()) break block18;
                        pluginType2 = null;
                    }
                    catch (Throwable throwable) {
                        in.close();
                        throw throwable;
                    }
                    in.close();
                    return pluginType2;
                }
                PluginType pluginType4 = pluginType;
                in.close();
                return pluginType4;
            }
            finally {
                jar.close();
            }
        }
        catch (ZipException e) {
        }
        catch (SAXException e) {
            this.log.error((CharSequence)("Unable to read JAR file " + dir.getAbsolutePath()), (Throwable)e);
        }
        catch (XMLStreamException e) {
            this.log.error((CharSequence)("Unable to read JAR file " + dir.getAbsolutePath()), (Throwable)e);
        }
        catch (JAXBException e) {
            this.log.error((CharSequence)("Unable to read JAR file " + dir.getAbsolutePath()), (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Unable to read JAR file " + dir.getAbsolutePath()), (Throwable)e);
        }
        return null;
    }
}

