/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.BasicKernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.mavenplugins.car.Maven2RepositoryAdapter;
import org.apache.geronimo.mavenplugins.car.Override;
import org.apache.geronimo.mavenplugins.car.ServerInstance;
import org.apache.geronimo.system.configuration.RepositoryConfigurationStore;
import org.apache.geronimo.system.plugin.DownloadPoller;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.PluginInstallerGBean;
import org.apache.geronimo.system.plugin.SourceRepository;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.geronimo.system.plugin.model.AttributesType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.apache.geronimo.system.resolver.AliasedArtifactResolver;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;

public class InstallModulesMojo
extends AbstractCarMojo {
    private File targetServerDirectory = null;
    private String targetRepositoryPath = null;
    private String targetConfigPath = null;
    private List<ServerInstance> servers;
    private String artifact = null;
    private ArtifactRepository sourceRepository = null;
    private File explicitResolutionProperties = null;
    private AliasedArtifactResolver geronimoArtifactResolver;
    private RepositoryConfigurationStore sourceStore;
    private File overridesDir;
    private List<Override> overrides;
    private Set installedArtifacts = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() throws Exception {
        this.getDependencies(this.project);
        AbstractCarMojo.ArtifactLookupImpl lookup = new AbstractCarMojo.ArtifactLookupImpl(new HashMap<Artifact, org.apache.maven.artifact.Artifact>());
        Maven2RepositoryAdapter sourceRepo = new Maven2RepositoryAdapter(this.dependencies, lookup);
        PluginListType pluginList = new PluginListType();
        String localRepo = this.sourceRepository.getUrl();
        if ("file".equals(this.sourceRepository.getProtocol())) {
            File localRepoDir = new File(this.sourceRepository.getBasedir());
            localRepo = localRepoDir.toURI().toString();
        }
        pluginList.getDefaultRepository().add(localRepo);
        for (Repository repository : this.project.getRepositories()) {
            pluginList.getDefaultRepository().add(repository.getUrl());
        }
        if (this.artifact != null) {
            pluginList.getPlugin().add(this.toPluginType(Artifact.create((String)this.artifact)));
        } else {
            this.addDependencies(pluginList);
        }
        DownloadResults downloadPoller = new DownloadResults();
        String targetServerPath = this.targetServerDirectory.getAbsolutePath();
        BasicKernel kernel = new BasicKernel("Assembly");
        try {
            PluginInstallerGBean installer = new PluginInstallerGBean(this.targetRepositoryPath, targetServerPath, this.servers, (Kernel)kernel, ((Object)((Object)this)).getClass().getClassLoader());
            installer.install(pluginList, (SourceRepository)sourceRepo, true, null, null, (DownloadPoller)downloadPoller);
            if (this.overrides != null) {
                for (Override override : this.overrides) {
                    AttributesType attributes = override.getOverrides(this.overridesDir);
                    installer.mergeOverrides(override.getServer(), attributes);
                }
            }
        }
        finally {
            kernel.shutdown();
        }
        this.log.info((CharSequence)"Installed plugins: ");
        for (Artifact artifact : downloadPoller.getInstalledConfigIDs()) {
            this.log.info((CharSequence)("    " + artifact));
        }
        this.log.info((CharSequence)"Installed dependencies: ");
        for (Artifact artifact : downloadPoller.getDependenciesInstalled()) {
            this.log.info((CharSequence)("    " + artifact));
        }
        if (downloadPoller.isFailed()) {
            throw downloadPoller.getFailure();
        }
    }

    private PluginType toPluginType(Artifact artifact) {
        PluginType plugin = new PluginType();
        PluginArtifactType instance = new PluginArtifactType();
        ArtifactType artifactType = PluginInstallerGBean.toArtifactType((Artifact)artifact);
        instance.setModuleId(artifactType);
        plugin.getPluginArtifact().add(instance);
        return plugin;
    }

    protected void addDependencies(PluginListType pluginList) {
        List projectArtifacts;
        org.apache.maven.artifact.Artifact artifact = this.project.getArtifact();
        if (artifact != null && ("car".equals(artifact.getType()) || "jar".equals(artifact.getType())) && artifact.getFile() != null) {
            pluginList.getPlugin().add(this.toPluginType(this.mavenToGeronimoArtifact(artifact)));
        }
        if ((projectArtifacts = this.project.getModel().getDependencies()) != null) {
            for (Dependency dependency : projectArtifacts) {
                if (dependency.getScope() != null && !"compile".equals(dependency.getScope())) continue;
                pluginList.getPlugin().add(this.toPluginType(this.mavenToGeronimoArtifact(dependency)));
            }
        }
    }
}

