/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound.connectiontracking;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.resource.ResourceException;
import javax.resource.spi.DissociatableManagedConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ConnectionTrackingInterceptor;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;

public class ConnectionTrackingCoordinator
implements TrackedConnectionAssociator,
ConnectionTracker {
    private static final Log log = LogFactory.getLog((String)ConnectionTrackingCoordinator.class.getName());
    private final boolean lazyConnect;
    private final ThreadLocal currentInstanceContexts = new ThreadLocal();
    private final ConcurrentMap proxiesByConnectionInfo = new ConcurrentHashMap();

    public ConnectionTrackingCoordinator() {
        this(false);
    }

    public ConnectionTrackingCoordinator(boolean lazyConnect) {
        this.lazyConnect = lazyConnect;
    }

    public boolean isLazyConnect() {
        return this.lazyConnect;
    }

    public ConnectorInstanceContext enter(ConnectorInstanceContext newContext) throws ResourceException {
        ConnectorInstanceContext oldContext = (ConnectorInstanceContext)this.currentInstanceContexts.get();
        this.currentInstanceContexts.set(newContext);
        this.associateConnections(newContext);
        return oldContext;
    }

    private void associateConnections(ConnectorInstanceContext context) throws ResourceException {
        Map connectionManagerToManagedConnectionInfoMap = context.getConnectionManagerMap();
        for (Map.Entry entry : connectionManagerToManagedConnectionInfoMap.entrySet()) {
            ConnectionTrackingInterceptor mcci = (ConnectionTrackingInterceptor)entry.getKey();
            Set connections = (Set)entry.getValue();
            mcci.enter(connections);
        }
    }

    public void newTransaction() throws ResourceException {
        ConnectorInstanceContext currentContext = (ConnectorInstanceContext)this.currentInstanceContexts.get();
        if (currentContext == null) {
            return;
        }
        this.associateConnections(currentContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(ConnectorInstanceContext oldContext) throws ResourceException {
        ConnectorInstanceContext currentContext = (ConnectorInstanceContext)this.currentInstanceContexts.get();
        try {
            Map resources = currentContext.getConnectionManagerMap();
            Iterator i = resources.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ConnectionTrackingInterceptor mcci = (ConnectionTrackingInterceptor)entry.getKey();
                Set connections = (Set)entry.getValue();
                if (this.lazyConnect) {
                    for (ConnectionInfo connectionInfo : connections) {
                        this.releaseProxyConnection(connectionInfo);
                    }
                }
                mcci.exit(connections);
                if (!connections.isEmpty()) continue;
                i.remove();
            }
        }
        finally {
            if (this.lazyConnect) {
                currentContext.getConnectionManagerMap().clear();
            }
            this.currentInstanceContexts.set(oldContext);
        }
    }

    public void handleObtained(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo, boolean reassociate) throws ResourceException {
        ConnectorInstanceContext currentContext = (ConnectorInstanceContext)this.currentInstanceContexts.get();
        if (currentContext == null) {
            return;
        }
        Map resources = currentContext.getConnectionManagerMap();
        HashSet<ConnectionInfo> infos = (HashSet<ConnectionInfo>)resources.get(connectionTrackingInterceptor);
        if (infos == null) {
            infos = new HashSet<ConnectionInfo>();
            resources.put(connectionTrackingInterceptor, infos);
        }
        infos.add(connectionInfo);
        if (!reassociate && this.lazyConnect) {
            this.proxyConnection(connectionTrackingInterceptor, connectionInfo);
        }
    }

    public void handleReleased(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        ConnectorInstanceContext currentContext = (ConnectorInstanceContext)this.currentInstanceContexts.get();
        if (currentContext == null) {
            return;
        }
        Map resources = currentContext.getConnectionManagerMap();
        Set infos = (Set)resources.get(connectionTrackingInterceptor);
        if (infos != null) {
            if (connectionInfo.getConnectionHandle() == null) {
                ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
                Collection toRemove = mci.getConnectionInfos();
                infos.removeAll(toRemove);
            } else {
                infos.remove(connectionInfo);
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("No infos found for handle " + connectionInfo.getConnectionHandle() + " for MCI: " + connectionInfo.getManagedConnectionInfo() + " for MC: " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " for CTI: " + connectionTrackingInterceptor), (Throwable)new Exception("Stack Trace"));
        }
        this.closeProxyConnection(connectionInfo);
    }

    public void setEnvironment(ConnectionInfo connectionInfo, String key) {
        ConnectorInstanceContext currentContext = (ConnectorInstanceContext)this.currentInstanceContexts.get();
        if (currentContext != null) {
            Set unshareableResources = currentContext.getUnshareableResources();
            boolean unshareable = unshareableResources.contains(key);
            connectionInfo.setUnshareable(unshareable);
            Set applicationManagedSecurityResources = currentContext.getApplicationManagedSecurityResources();
            boolean applicationManagedSecurity = applicationManagedSecurityResources.contains(key);
            connectionInfo.setApplicationManagedSecurity(applicationManagedSecurity);
        }
    }

    private void proxyConnection(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo) throws ResourceException {
        if (connectionInfo.getConnectionProxy() != null) {
            return;
        }
        if (connectionInfo.getManagedConnectionInfo().getManagedConnection() instanceof DissociatableManagedConnection) {
            return;
        }
        try {
            Object handle = connectionInfo.getConnectionHandle();
            ConnectionInvocationHandler invocationHandler = new ConnectionInvocationHandler(connectionTrackingInterceptor, connectionInfo, handle);
            Object proxy = Proxy.newProxyInstance(this.getClassLoader(handle), handle.getClass().getInterfaces(), (InvocationHandler)invocationHandler);
            Object existingProxy = this.proxiesByConnectionInfo.putIfAbsent(connectionInfo, proxy);
            if (existingProxy != null) {
                proxy = existingProxy;
            }
            connectionInfo.setConnectionProxy(proxy);
        }
        catch (Throwable e) {
            throw new ResourceException("Unable to construct connection proxy", e);
        }
    }

    private void releaseProxyConnection(ConnectionInfo connectionInfo) {
        ConnectionInvocationHandler invocationHandler = this.getConnectionInvocationHandler(connectionInfo);
        if (invocationHandler != null) {
            invocationHandler.releaseHandle();
        }
    }

    private void closeProxyConnection(ConnectionInfo connectionInfo) {
        ConnectionInvocationHandler invocationHandler = this.getConnectionInvocationHandler(connectionInfo);
        if (invocationHandler != null) {
            invocationHandler.close();
            this.proxiesByConnectionInfo.remove(connectionInfo);
            connectionInfo.setConnectionProxy(null);
        }
    }

    private ClassLoader getClassLoader(Object handle) {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        if (threadClassLoader != null) {
            return threadClassLoader;
        }
        return handle.getClass().getClassLoader();
    }

    private ConnectionInvocationHandler getConnectionInvocationHandler(ConnectionInfo connectionInfo) {
        InvocationHandler invocationHandler;
        Object proxy = connectionInfo.getConnectionProxy();
        if (proxy == null) {
            proxy = this.proxiesByConnectionInfo.get(connectionInfo);
        }
        if (proxy == null) {
            return null;
        }
        if (Proxy.isProxyClass(proxy.getClass()) && (invocationHandler = Proxy.getInvocationHandler(proxy)) instanceof ConnectionInvocationHandler) {
            return (ConnectionInvocationHandler)invocationHandler;
        }
        return null;
    }

    public static class ConnectionInvocationHandler
    implements InvocationHandler {
        private ConnectionTrackingInterceptor connectionTrackingInterceptor;
        private ConnectionInfo connectionInfo;
        private final Object handle;
        private boolean released = false;

        public ConnectionInvocationHandler(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo, Object handle) {
            this.connectionTrackingInterceptor = connectionTrackingInterceptor;
            this.connectionInfo = connectionInfo;
            this.handle = handle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object object, Method method, Object[] args) throws Throwable {
            Object handle;
            if (method.getDeclaringClass() == Object.class) {
                if (method.getName().equals("finalize")) {
                    return null;
                }
                if (method.getName().equals("clone")) {
                    throw new CloneNotSupportedException();
                }
                ConnectionInvocationHandler connectionInvocationHandler = this;
                synchronized (connectionInvocationHandler) {
                    handle = this.handle;
                }
            } else {
                handle = this.getHandle();
            }
            try {
                Object value = method.invoke(handle, args);
                return value;
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                if (t != null) {
                    throw t;
                }
                throw ite;
            }
        }

        public synchronized boolean isReleased() {
            return this.released;
        }

        public synchronized void releaseHandle() {
            this.released = true;
        }

        public synchronized void close() {
            this.connectionTrackingInterceptor = null;
            this.connectionInfo = null;
            this.released = true;
        }

        public synchronized Object getHandle() {
            if (this.connectionTrackingInterceptor == null) {
                return this.handle;
            }
            if (this.released) {
                try {
                    this.connectionTrackingInterceptor.reassociateConnection(this.connectionInfo);
                }
                catch (ResourceException e) {
                    throw (IllegalStateException)new IllegalStateException("Could not obtain a physical connection").initCause(e);
                }
                this.released = false;
            }
            return this.handle;
        }
    }
}

