/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.validator;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static Hashtable bundles = new Hashtable();
    private static Hashtable rbFormats = new Hashtable();
    private static Locale globalLocale;
    private ResourceBundle messages;
    private Hashtable formats;
    private Locale locale;
    private String resourceName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Messages(String resourceName) {
        Class<Messages> clazz = Messages.class;
        synchronized (Messages.class) {
            this.locale = globalLocale;
            this.resourceName = resourceName + ".Messages";
            ResourceBundle rb = (ResourceBundle)bundles.get(this.resourceName);
            if (rb == null) {
                this.init();
            } else {
                this.messages = rb;
                this.formats = (Hashtable)rbFormats.get(this.resourceName);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void init() {
        try {
            this.messages = this.locale == null ? ResourceBundle.getBundle(this.resourceName) : ResourceBundle.getBundle(this.resourceName, this.locale);
        }
        catch (Exception except) {
            this.messages = new EmptyResourceBundle();
        }
        this.formats = new Hashtable();
        bundles.put(this.resourceName, this.messages);
        rbFormats.put(this.resourceName, this.formats);
    }

    public String format(String message, Object arg1) {
        return this.format(message, new Object[]{arg1});
    }

    public String format(String message, Object arg1, Object arg2) {
        return this.format(message, new Object[]{arg1, arg2});
    }

    public String format(String message, Object arg1, Object arg2, Object arg3) {
        return this.format(message, new Object[]{arg1, arg2, arg3});
    }

    public String format(String message, Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.format(message, new Object[]{arg1, arg2, arg3, arg4});
    }

    public String format(String message, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return this.format(message, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public String format(String message) {
        return this.message(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String format(String message, Object[] args) {
        if (this.locale != globalLocale) {
            Class<Messages> clazz = Messages.class;
            // MONITORENTER : org.apache.geronimo.validator.Messages.class
            this.init();
            // MONITOREXIT : clazz
        }
        try {
            String msg;
            MessageFormat mf = (MessageFormat)this.formats.get(message);
            if (mf != null) return mf.format(args);
            try {
                msg = this.messages.getString(message);
            }
            catch (MissingResourceException except) {
                return message;
            }
            mf = new MessageFormat(msg);
            this.formats.put(message, mf);
            return mf.format(args);
        }
        catch (Exception except) {
            return "An internal error occured while processing message " + message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String message(String message) {
        if (this.locale != globalLocale) {
            Class<Messages> clazz = Messages.class;
            // MONITORENTER : org.apache.geronimo.validator.Messages.class
            this.init();
            // MONITOREXIT : clazz
        }
        try {
            return this.messages.getString(message);
        }
        catch (MissingResourceException except) {
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale locale) {
        Class<Messages> clazz = Messages.class;
        synchronized (Messages.class) {
            globalLocale = locale;
            bundles = new Hashtable();
            rbFormats = new Hashtable();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        Messages.setLocale(Locale.getDefault());
    }

    private static final class EmptyResourceBundle
    extends ResourceBundle
    implements Enumeration {
        private EmptyResourceBundle() {
        }

        public Enumeration getKeys() {
            return this;
        }

        protected Object handleGetObject(String name) {
            return "[Missing message " + name + "]";
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

