/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transaction;
import org.apache.geronimo.persistence.InternalCMPEntityManagerExtended;

public class EntityManagerExtendedRegistry {
    private static final ThreadLocal<Map<String, InternalCMPEntityManagerExtended>> entityManagerMaps = new ThreadLocal<Map<String, InternalCMPEntityManagerExtended>>(){

        @Override
        protected Map<String, InternalCMPEntityManagerExtended> initialValue() {
            return new HashMap<String, InternalCMPEntityManagerExtended>();
        }
    };

    public static InternalCMPEntityManagerExtended getEntityManager(String persistenceUnit) {
        Map<String, InternalCMPEntityManagerExtended> entityManagerMap = entityManagerMaps.get();
        return entityManagerMap.get(persistenceUnit);
    }

    public static void putEntityManager(String persistenceUnit, InternalCMPEntityManagerExtended entityManager) {
        Map<String, InternalCMPEntityManagerExtended> entityManagerMap = entityManagerMaps.get();
        InternalCMPEntityManagerExtended oldEntityManager = entityManagerMap.put(persistenceUnit, entityManager);
        if (oldEntityManager != null) {
            throw new IllegalStateException("There was already an EntityManager registered for persistenceUnit " + persistenceUnit);
        }
    }

    public static void clearEntityManager(String persistenceUnit) {
        Map<String, InternalCMPEntityManagerExtended> entityManagerMap = entityManagerMaps.get();
        entityManagerMap.remove(persistenceUnit);
    }

    public static void threadAssociated(Transaction transaction) {
        Map<String, InternalCMPEntityManagerExtended> entityManagerMap = entityManagerMaps.get();
        for (InternalCMPEntityManagerExtended entityManager : entityManagerMap.values()) {
            entityManager.joinTransaction();
        }
    }

    public static void threadUnassociated(Transaction transaction) {
    }
}

