/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.coyote.ajp.Constants;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.res.StringManager;

public class AjpProcessor
implements ActionHook {
    protected static Log log = LogFactory.getLog(AjpProcessor.class);
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.ajp");
    protected Adapter adapter = null;
    protected Request request = null;
    protected Response response = null;
    protected AjpMessage requestHeaderMessage = null;
    protected AjpMessage responseHeaderMessage = null;
    protected AjpMessage bodyMessage = null;
    protected MessageBytes bodyBytes = MessageBytes.newInstance();
    protected boolean started = false;
    protected boolean error = false;
    protected Socket socket;
    protected InputStream input;
    protected OutputStream output;
    protected char[] hostNameC = new char[0];
    protected JIoEndpoint endpoint;
    protected long readTimeout;
    protected MessageBytes tmpMB = MessageBytes.newInstance();
    protected MessageBytes certificates = MessageBytes.newInstance();
    protected boolean endOfStream = false;
    protected boolean empty = true;
    protected boolean first = true;
    protected boolean replay = false;
    protected boolean finished = false;
    protected static final byte[] getBodyMessageArray;
    protected static final byte[] pongMessageArray;
    protected static final byte[] endMessageArray;
    protected static final byte[] flushMessageArray;
    protected boolean tomcatAuthentication = true;
    protected String requiredSecret = null;
    protected int keepAliveTimeout = -1;

    public AjpProcessor(int packetSize, JIoEndpoint endpoint) {
        this.endpoint = endpoint;
        this.request = new Request();
        this.request.setInputBuffer(new SocketInputBuffer());
        this.response = new Response();
        this.response.setHook(this);
        this.response.setOutputBuffer(new SocketOutputBuffer());
        this.request.setResponse(this.response);
        this.requestHeaderMessage = new AjpMessage(packetSize);
        this.responseHeaderMessage = new AjpMessage(packetSize);
        this.bodyMessage = new AjpMessage(packetSize);
        int foo = HexUtils.DEC[0];
        HttpMessages.getMessage(200);
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public void setRequiredSecret(String requiredSecret) {
        this.requiredSecret = requiredSecret;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int timeout) {
        this.keepAliveTimeout = timeout;
    }

    public Request getRequest() {
        return this.request;
    }

    public boolean process(Socket socket) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.socket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        int soTimeout = -1;
        if (this.keepAliveTimeout > 0) {
            soTimeout = socket.getSoTimeout();
        }
        this.error = false;
        while (this.started && !this.error) {
            try {
                byte type;
                if (this.keepAliveTimeout > 0) {
                    socket.setSoTimeout(this.keepAliveTimeout);
                }
                if (!this.readMessage(this.requestHeaderMessage)) {
                    rp.setStage(7);
                    break;
                }
                if (this.keepAliveTimeout > 0) {
                    socket.setSoTimeout(soTimeout);
                }
                if ((type = this.requestHeaderMessage.getByte()) == 10) {
                    try {
                        this.output.write(pongMessageArray);
                    }
                    catch (IOException e) {
                        this.error = true;
                    }
                    continue;
                }
                if (type != 2) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Unexpected message: " + type));
                    continue;
                }
                this.request.setStartTime(System.currentTimeMillis());
            }
            catch (IOException e) {
                this.error = true;
                break;
            }
            catch (Throwable t) {
                log.debug((Object)sm.getString("ajpprocessor.header.error"), t);
                this.response.setStatus(400);
                this.error = true;
            }
            rp.setStage(2);
            try {
                this.prepareRequest();
            }
            catch (Throwable t) {
                log.debug((Object)sm.getString("ajpprocessor.request.prepare"), t);
                this.response.setStatus(400);
                this.error = true;
            }
            if (!this.error) {
                try {
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("ajpprocessor.request.process"), t);
                    this.response.setStatus(500);
                    this.error = true;
                }
            }
            if (!this.finished) {
                try {
                    this.finish();
                }
                catch (Throwable t) {
                    this.error = true;
                }
            }
            if (this.error) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            rp.setStage(6);
            this.recycle();
        }
        rp.setStage(7);
        this.recycle();
        this.input = null;
        this.output = null;
        return true;
    }

    public void action(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.ACTION_COMMIT) {
            if (this.response.isCommitted()) {
                return;
            }
            try {
                this.prepareResponse();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.ACTION_CLIENT_FLUSH) {
            if (!this.response.isCommitted()) {
                try {
                    this.prepareResponse();
                }
                catch (IOException e) {
                    this.error = true;
                    return;
                }
            }
            try {
                this.flush();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.ACTION_CLOSE) {
            try {
                this.finish();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.ACTION_START) {
            this.started = true;
        } else if (actionCode == ActionCode.ACTION_STOP) {
            this.started = false;
        } else if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
            if (!this.certificates.isNull()) {
                ByteChunk certData = this.certificates.getByteChunk();
                X509Certificate[] jsseCerts = null;
                ByteArrayInputStream bais = new ByteArrayInputStream(certData.getBytes(), certData.getStart(), certData.getLength());
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                    jsseCerts = new X509Certificate[]{cert};
                    this.request.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
                }
                catch (CertificateException e) {
                    log.error((Object)sm.getString("ajpprocessor.certs.fail"), (Throwable)e);
                    return;
                }
            }
        } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
            if (this.request.remoteHost().isNull()) {
                try {
                    this.request.remoteHost().setString(InetAddress.getByName(this.request.remoteAddr().toString()).getHostName());
                }
                catch (IOException iex) {}
            }
        } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE) {
            this.request.localAddr().setString(this.request.localName().toString());
        } else if (actionCode == ActionCode.ACTION_REQ_SET_BODY_REPLAY) {
            ByteChunk bc = (ByteChunk)param;
            int length = bc.getLength();
            this.bodyBytes.setBytes(bc.getBytes(), bc.getStart(), length);
            this.request.setContentLength(length);
            this.first = false;
            this.empty = false;
            this.replay = true;
        }
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected void prepareRequest() {
        ByteChunk uriBC;
        byte attributeCode;
        boolean isSSL;
        byte methodCode = this.requestHeaderMessage.getByte();
        if (methodCode != -1) {
            String methodName = Constants.methodTransArray[methodCode - 1];
            this.request.method().setString(methodName);
        }
        this.requestHeaderMessage.getBytes(this.request.protocol());
        this.requestHeaderMessage.getBytes(this.request.requestURI());
        this.requestHeaderMessage.getBytes(this.request.remoteAddr());
        this.requestHeaderMessage.getBytes(this.request.remoteHost());
        this.requestHeaderMessage.getBytes(this.request.localName());
        this.request.setLocalPort(this.requestHeaderMessage.getInt());
        boolean bl = isSSL = this.requestHeaderMessage.getByte() != 0;
        if (isSSL) {
            this.request.scheme().setString("https");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        int hCount = this.requestHeaderMessage.getInt();
        for (int i = 0; i < hCount; ++i) {
            String hName = null;
            int isc = this.requestHeaderMessage.peekInt();
            int hId = isc & 0xFF;
            MessageBytes vMB = null;
            if (40960 == (isc &= 0xFF00)) {
                this.requestHeaderMessage.getInt();
                hName = Constants.headerTransArray[hId - 1];
                vMB = headers.addValue(hName);
            } else {
                hId = -1;
                this.requestHeaderMessage.getBytes(this.tmpMB);
                ByteChunk bc = this.tmpMB.getByteChunk();
                vMB = headers.addValue(bc.getBuffer(), bc.getStart(), bc.getLength());
            }
            this.requestHeaderMessage.getBytes(vMB);
            if (hId == 8 || hId == -1 && this.tmpMB.equalsIgnoreCase("Content-Length")) {
                this.request.setContentLength(vMB.getInt());
                continue;
            }
            if (hId != 7 && (hId != -1 || !this.tmpMB.equalsIgnoreCase("Content-Type"))) continue;
            ByteChunk bchunk = vMB.getByteChunk();
            this.request.contentType().setBytes(bchunk.getBytes(), bchunk.getOffset(), bchunk.getLength());
        }
        boolean secret = false;
        while ((attributeCode = this.requestHeaderMessage.getByte()) != -1) {
            switch (attributeCode) {
                case 10: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String n = this.tmpMB.toString();
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String v = this.tmpMB.toString();
                    this.request.setAttribute(n, v);
                    break;
                }
                case 1: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    break;
                }
                case 2: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    break;
                }
                case 3: {
                    if (this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.tmpMB);
                        break;
                    }
                    this.requestHeaderMessage.getBytes(this.request.getRemoteUser());
                    break;
                }
                case 4: {
                    if (this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.tmpMB);
                        break;
                    }
                    this.requestHeaderMessage.getBytes(this.request.getAuthType());
                    break;
                }
                case 5: {
                    this.requestHeaderMessage.getBytes(this.request.queryString());
                    break;
                }
                case 6: {
                    this.requestHeaderMessage.getBytes(this.request.instanceId());
                    break;
                }
                case 7: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.certificates);
                    break;
                }
                case 8: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.cipher_suite", this.tmpMB.toString());
                    break;
                }
                case 9: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.ssl_session", this.tmpMB.toString());
                    break;
                }
                case 11: {
                    this.request.setAttribute("javax.servlet.request.key_size", new Integer(this.requestHeaderMessage.getInt()));
                    break;
                }
                case 13: {
                    this.requestHeaderMessage.getBytes(this.request.method());
                    break;
                }
                case 12: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    if (this.requiredSecret == null) break;
                    secret = true;
                    if (this.tmpMB.equals(this.requiredSecret)) break;
                    this.response.setStatus(403);
                    this.error = true;
                    break;
                }
            }
        }
        if (this.requiredSecret != null && !secret) {
            this.response.setStatus(403);
            this.error = true;
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        MessageBytes valueMB = this.request.getMimeHeaders().getValue("host");
        this.parseHost(valueMB);
    }

    public void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB != null && valueMB.isNull()) {
            this.request.setServerPort(this.endpoint.getPort());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (this.request.scheme().equalsIgnoreCase("https")) {
                this.request.setServerPort(443);
            } else {
                this.request.setServerPort(80);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB[i + valueS]];
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    protected void prepareResponse() throws IOException {
        int contentLength;
        String contentLanguage;
        this.response.setCommitted(true);
        this.responseHeaderMessage.reset();
        this.responseHeaderMessage.appendByte(4);
        this.responseHeaderMessage.appendInt(this.response.getStatus());
        String message = this.response.getMessage();
        message = message == null ? HttpMessages.getMessage(this.response.getStatus()) : message.replace('\n', ' ').replace('\r', ' ');
        this.tmpMB.setString(message);
        this.responseHeaderMessage.appendBytes(this.tmpMB);
        MimeHeaders headers = this.response.getMimeHeaders();
        String contentType = this.response.getContentType();
        if (contentType != null) {
            headers.setValue("Content-Type").setString(contentType);
        }
        if ((contentLanguage = this.response.getContentLanguage()) != null) {
            headers.setValue("Content-Language").setString(contentLanguage);
        }
        if ((contentLength = this.response.getContentLength()) >= 0) {
            headers.setValue("Content-Length").setInt(contentLength);
        }
        int numHeaders = headers.size();
        this.responseHeaderMessage.appendInt(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            MessageBytes hN = headers.getName(i);
            int hC = Constants.getResponseAjpIndex(hN.toString());
            if (hC > 0) {
                this.responseHeaderMessage.appendInt(hC);
            } else {
                this.responseHeaderMessage.appendBytes(hN);
            }
            MessageBytes hV = headers.getValue(i);
            this.responseHeaderMessage.appendBytes(hV);
        }
        this.responseHeaderMessage.end();
        this.output.write(this.responseHeaderMessage.getBuffer(), 0, this.responseHeaderMessage.getLen());
    }

    protected void finish() throws IOException {
        if (!this.response.isCommitted()) {
            try {
                this.prepareResponse();
            }
            catch (IOException e) {
                this.error = true;
            }
        }
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.output.write(endMessageArray);
    }

    protected boolean read(byte[] buf, int pos, int n) throws IOException {
        int res = 0;
        for (int read = 0; read < n; read += res) {
            res = this.input.read(buf, read + pos, n - read);
            if (res > 0) {
                continue;
            }
            throw new IOException(sm.getString("ajpprotocol.failedread"));
        }
        return true;
    }

    public boolean receive() throws IOException {
        this.first = false;
        this.bodyMessage.reset();
        this.readMessage(this.bodyMessage);
        if (this.bodyMessage.getLen() == 0) {
            return false;
        }
        int blen = this.bodyMessage.peekInt();
        if (blen == 0) {
            return false;
        }
        this.bodyMessage.getBytes(this.bodyBytes);
        this.empty = false;
        return true;
    }

    private boolean refillReadBuffer() throws IOException {
        if (this.replay) {
            this.endOfStream = true;
        }
        if (this.endOfStream) {
            return false;
        }
        this.output.write(getBodyMessageArray);
        boolean moreData = this.receive();
        if (!moreData) {
            this.endOfStream = true;
        }
        return moreData;
    }

    protected boolean readMessage(AjpMessage message) throws IOException {
        byte[] buf = message.getBuffer();
        this.read(buf, 0, message.getHeaderLength());
        message.processHeader();
        this.read(buf, message.getHeaderLength(), message.getLen());
        return true;
    }

    public void recycle() {
        this.first = true;
        this.endOfStream = false;
        this.empty = true;
        this.replay = false;
        this.finished = false;
        this.request.recycle();
        this.response.recycle();
        this.certificates.recycle();
    }

    protected void flush() throws IOException {
        this.output.write(flushMessageArray);
    }

    static {
        AjpMessage getBodyMessage = new AjpMessage(16);
        getBodyMessage.reset();
        getBodyMessage.appendByte(6);
        getBodyMessage.appendInt(8186);
        getBodyMessage.end();
        getBodyMessageArray = new byte[getBodyMessage.getLen()];
        System.arraycopy(getBodyMessage.getBuffer(), 0, getBodyMessageArray, 0, getBodyMessage.getLen());
        AjpMessage pongMessage = new AjpMessage(16);
        pongMessage.reset();
        pongMessage.appendByte(9);
        pongMessage.end();
        pongMessageArray = new byte[pongMessage.getLen()];
        System.arraycopy(pongMessage.getBuffer(), 0, pongMessageArray, 0, pongMessage.getLen());
        AjpMessage endMessage = new AjpMessage(16);
        endMessage.reset();
        endMessage.appendByte(5);
        endMessage.appendByte(1);
        endMessage.end();
        endMessageArray = new byte[endMessage.getLen()];
        System.arraycopy(endMessage.getBuffer(), 0, endMessageArray, 0, endMessage.getLen());
        AjpMessage flushMessage = new AjpMessage(16);
        flushMessage.reset();
        flushMessage.appendByte(3);
        flushMessage.appendInt(0);
        flushMessage.appendByte(0);
        flushMessage.end();
        flushMessageArray = new byte[flushMessage.getLen()];
        System.arraycopy(flushMessage.getBuffer(), 0, flushMessageArray, 0, flushMessage.getLen());
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            if (!AjpProcessor.this.response.isCommitted()) {
                try {
                    AjpProcessor.this.prepareResponse();
                }
                catch (IOException e) {
                    AjpProcessor.this.error = true;
                }
            }
            int len = chunk.getLength();
            int chunkSize = 8184;
            int off = 0;
            while (len > 0) {
                int thisTime = len;
                if (thisTime > chunkSize) {
                    thisTime = chunkSize;
                }
                len -= thisTime;
                AjpProcessor.this.responseHeaderMessage.reset();
                AjpProcessor.this.responseHeaderMessage.appendByte(3);
                AjpProcessor.this.responseHeaderMessage.appendBytes(chunk.getBytes(), chunk.getOffset() + off, thisTime);
                AjpProcessor.this.responseHeaderMessage.end();
                AjpProcessor.this.output.write(AjpProcessor.this.responseHeaderMessage.getBuffer(), 0, AjpProcessor.this.responseHeaderMessage.getLen());
                off += thisTime;
            }
            return chunk.getLength();
        }
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (AjpProcessor.this.endOfStream) {
                return -1;
            }
            if (AjpProcessor.this.first && req.getContentLength() > 0) {
                if (!AjpProcessor.this.receive()) {
                    return 0;
                }
            } else if (AjpProcessor.this.empty && !AjpProcessor.this.refillReadBuffer()) {
                return -1;
            }
            ByteChunk bc = AjpProcessor.this.bodyBytes.getByteChunk();
            chunk.setBytes(bc.getBuffer(), bc.getStart(), bc.getLength());
            AjpProcessor.this.empty = true;
            return chunk.getLength();
        }
    }
}

