/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmispec.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RMISecurityManager;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.rmispec.util.GetSystemPropertyAction;

public class UtilLoader {
    static final Logger logger = Logger.getLogger(UtilLoader.class.getName());
    private static final SecMan _secman = UtilLoader.getSecMan();

    public static Class loadClass(String name, String codebase, ClassLoader loader) throws ClassNotFoundException {
        Class<?> result = null;
        if (loader != null) {
            try {
                logger.finer("trying provided class loader");
                result = loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            if (result != null) {
                return result;
            }
        }
        ClassLoader stackLoader = null;
        ClassLoader thisLoader = UtilLoader.class.getClassLoader();
        Class[] stack = _secman.getClassContext();
        for (int i = 1; i < stack.length; ++i) {
            ClassLoader testLoader = stack[i].getClassLoader();
            if (testLoader == null || testLoader == thisLoader) continue;
            stackLoader = thisLoader;
            break;
        }
        if (stackLoader != null) {
            try {
                logger.finer("trying stack loader");
                result = stackLoader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            if (result != null) {
                return result;
            }
        }
        if (thisLoader != null) {
            try {
                logger.finer("trying UtilLoader loader");
                result = thisLoader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            if (result != null) {
                return result;
            }
        }
        if (codebase != null && !"".equals(codebase) && !Boolean.getBoolean("java.rmi.server.useCodeBaseOnly")) {
            try {
                logger.finer("trying RMIClassLoader");
                URLClassLoader url_loader = new URLClassLoader(new URL[]{new URL(codebase)}, loader);
                result = url_loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.FINER, "RMIClassLoader says " + ex.getMessage(), ex);
            }
            catch (MalformedURLException ex) {
                logger.log(Level.FINER, "RMIClassLoader says " + ex.getMessage(), ex);
                logger.finer("FAILED class download " + name + " from " + codebase + " " + ex.getMessage());
            }
            catch (RuntimeException ex) {
                logger.log(Level.FINER, "FAILED class download " + name + " from " + codebase + " " + ex.getMessage(), ex);
            }
            if (result != null) {
                return result;
            }
        } else {
            codebase = (String)AccessController.doPrivileged(new GetSystemPropertyAction("java.rmi.server.codebase"));
            if (codebase != null) {
                try {
                    result = RMIClassLoader.loadClass(codebase, name);
                }
                catch (ClassNotFoundException ex) {
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
                if (result != null) {
                    return result;
                }
            }
        }
        if (loader == null) {
            loader = UtilLoader.getContextClassLoader();
        }
        try {
            logger.finer("trying local loader");
            result = loader.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINER, "LocalLoader says " + ex.getMessage(), ex);
        }
        if (result != null) {
            return result;
        }
        throw new ClassNotFoundException(name);
    }

    static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static SecMan getSecMan() {
        try {
            return (SecMan)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return new SecMan();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    static class SecMan
    extends RMISecurityManager {
        SecMan() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

