/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.connector;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.management.j2ee.statistics.Stats;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.management.StatisticsProvider;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.connector.BaseHttp11Protocol;
import org.apache.geronimo.tomcat.connector.ConnectorGBean;
import org.apache.geronimo.tomcat.stats.ConnectorStats;

public abstract class BaseHttp11ConnectorGBean
extends ConnectorGBean
implements BaseHttp11Protocol,
StatisticsProvider {
    protected String connectHost;
    private ConnectorStats connStatsProvider = new ConnectorStats();
    private boolean reset = true;
    public static final GBeanInfo GBEAN_INFO;

    public BaseHttp11ConnectorGBean(String name, Map initParams, String tomcatProtocol, String host, int port, TomcatContainer container, ServerInfo serverInfo) throws Exception {
        super(name, initParams, tomcatProtocol, container, serverInfo);
        if (host == null) {
            host = "0.0.0.0";
        }
        if (port == 0) {
            throw new IllegalArgumentException("Must declare a port.");
        }
        this.connector.setAttribute("host", (Object)host);
        this.connector.setPort(port);
    }

    protected void initProtocol() {
    }

    public String getConnectUrl() {
        if (this.connectHost == null) {
            String host = this.getAddress();
            if (host == null || host.equals("0.0.0.0") || host.equals("0:0:0:0:0:0:0:1")) {
                InetAddress address = null;
                try {
                    address = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    host = "unknown-host";
                }
                if (address != null && ((host = address.getCanonicalHostName()) == null || host.equals(""))) {
                    host = address.getHostAddress();
                }
            }
            if (host.indexOf(":") >= 0) {
                host = "[" + host + "]";
            }
            this.connectHost = host;
        }
        return this.getScheme().toLowerCase() + "://" + this.connectHost + (this.getPort() == this.getDefaultPort() ? "" : ":" + this.getPort());
    }

    public abstract int getDefaultPort();

    public int getAcceptCount() {
        Object value = this.connector.getAttribute("acceptCount");
        return value == null ? 10 : Integer.parseInt(value.toString());
    }

    public String getAddress() {
        Object value = this.connector.getAttribute("address");
        if (value == null) {
            return "0.0.0.0";
        }
        if (value instanceof InetAddress) {
            return ((InetAddress)value).getHostAddress();
        }
        return value.toString();
    }

    public int getBufferSize() {
        Object value = this.connector.getAttribute("bufferSize");
        return value == null ? 2048 : Integer.parseInt(value.toString());
    }

    public String getCompressableMimeType() {
        return (String)this.connector.getAttribute("compressableMimeType");
    }

    public String getCompression() {
        return (String)this.connector.getAttribute("compression");
    }

    public int getConnectionLinger() {
        Object value = this.connector.getAttribute("connectionLinger");
        return value == null ? -1 : Integer.parseInt(value.toString());
    }

    public int getConnectionTimeout() {
        Object value = this.connector.getAttribute("connectionTimeout");
        return value == null ? 60000 : Integer.parseInt(value.toString());
    }

    public boolean getDisableUploadTimeout() {
        Object value = this.connector.getAttribute("disableUploadTimeout");
        return value == null ? true : new Boolean(value.toString());
    }

    public String getExecutor() {
        Object value = this.connector.getAttribute("executor");
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.getClass().getName();
    }

    public String getHost() {
        return this.getAddress();
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public int getKeepAliveTimeout() {
        Object value = this.connector.getAttribute("keepAliveTimeout");
        return value == null ? this.getConnectionTimeout() : Integer.parseInt(value.toString());
    }

    public int getMaxHttpHeaderSize() {
        Object value = this.connector.getAttribute("maxHttpHeaderSize");
        return value == null ? 4096 : Integer.parseInt(value.toString());
    }

    public int getMaxKeepAliveRequests() {
        Object value = this.connector.getAttribute("maxKeepAliveRequests");
        return value == null ? 100 : Integer.parseInt(value.toString());
    }

    public int getMaxThreads() {
        Object value = this.connector.getAttribute("maxThreads");
        return value == null ? 200 : Integer.parseInt(value.toString());
    }

    public int getMaxSpareThreads() {
        Object value = this.connector.getAttribute("maxSpareThreads");
        return value == null ? 100 : Integer.parseInt(value.toString());
    }

    public int getMinSpareThreads() {
        Object value = this.connector.getAttribute("minSpareThreads");
        return value == null ? 10 : Integer.parseInt(value.toString());
    }

    public String getNoCompressionUserAgents() {
        return (String)this.connector.getAttribute("noCompressionUserAgents");
    }

    public int getPort() {
        return this.connector.getPort();
    }

    public String getRestrictedUserAgents() {
        return (String)this.connector.getAttribute("restrictedUserAgents");
    }

    public String getServer() {
        return (String)this.connector.getAttribute("server");
    }

    public int getSocketBuffer() {
        Object value = this.connector.getAttribute("socketBuffer");
        return value == null ? 9000 : Integer.parseInt(value.toString());
    }

    public boolean getTcpNoDelay() {
        Object value = this.connector.getAttribute("tcpNoDelay");
        return value == null ? true : new Boolean(value.toString());
    }

    public int getThreadPriority() {
        Object value = this.connector.getAttribute("threadPriority");
        return value == null ? 5 : Integer.parseInt(value.toString());
    }

    public void setAcceptCount(int acceptCount) {
        this.connector.setAttribute("acceptCount", (Object)new Integer(acceptCount));
    }

    public void setAddress(String address) {
        this.connector.setAttribute("address", (Object)address);
    }

    public void setBufferSize(int bufferSize) {
        this.connector.setAttribute("bufferSize", (Object)new Integer(bufferSize));
    }

    public void setCompressableMimeType(String compressableMimeType) {
        this.connector.setAttribute("compressableMimeType", (Object)compressableMimeType);
    }

    public void setCompression(String compression) {
        this.connector.setAttribute("compression", (Object)compression);
    }

    public void setConnectionLinger(int connectionLinger) {
        this.connector.setAttribute("connectionLinger", (Object)new Integer(connectionLinger));
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connector.setAttribute("connectionTimeout", (Object)new Integer(connectionTimeout));
    }

    public void setDisableUploadTimeout(boolean disableUploadTimeout) {
        this.connector.setAttribute("disableUploadTimeout", (Object)new Boolean(disableUploadTimeout));
    }

    public void setExecutor(String executor) {
        this.connector.setAttribute("executor", (Object)executor);
    }

    public void setHost(String host) {
        this.setAddress(host);
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.connector.setAttribute("keepAliveTimeout", (Object)keepAliveTimeout);
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.connector.setAttribute("maxHttpHeaderSize", (Object)new Integer(maxHttpHeaderSize));
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.connector.setAttribute("maxKeepAliveRequests", (Object)new Integer(maxKeepAliveRequests));
    }

    public void setMaxThreads(int maxThreads) {
        this.connector.setAttribute("maxThreads", (Object)new Integer(maxThreads));
    }

    public void setMaxSpareThreads(int maxSpareThreads) {
        this.connector.setAttribute("maxSpareThreads", (Object)new Integer(maxSpareThreads));
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.connector.setAttribute("minSpareThreads", (Object)new Integer(minSpareThreads));
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.connector.setAttribute("noCompressionUserAgents", (Object)noCompressionUserAgents);
    }

    public void setPort(int port) {
        this.connector.setPort(port);
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        this.connector.setAttribute("restrictedUserAgents", (Object)restrictedUserAgents);
    }

    public void setServer(String server) {
        if (server.equals("")) {
            server = null;
        }
        this.connector.setAttribute("server", (Object)server);
    }

    public void setSocketBuffer(int socketBuffer) {
        this.connector.setAttribute("socketBuffer", (Object)new Integer(socketBuffer));
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.connector.setAttribute("tcpNoDelay", (Object)new Boolean(tcpNoDelay));
    }

    public void setThreadPriority(int threadPriority) {
        this.connector.setAttribute("threadPriority", (Object)new Integer(threadPriority));
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    public Stats getStats() {
        String port = String.valueOf(this.getPort());
        if (this.reset) {
            this.reset = false;
            return this.connStatsProvider.getStats(port);
        }
        return this.connStatsProvider.updateStats(port);
    }

    public void resetStats() {
        this.reset = true;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Tomcat Connector", BaseHttp11ConnectorGBean.class, (GBeanInfo)ConnectorGBean.GBEAN_INFO);
        infoFactory.addInterface(BaseHttp11Protocol.class, new String[]{"acceptCount", "address", "bufferSize", "compressableMimeType", "compression", "connectionLinger", "connectionTimeout", "executor", "host", "keepAliveTimeout", "disableUploadTimeout", "maxHttpHeaderSize", "maxKeepAliveRequests", "maxThreads", "maxSpareThreads", "minSpareThreads", "noCompressionUserAgents", "port", "restrictedUserAgents", "server", "socketBuffer", "tcpNoDelay", "threadPriority", "algorithm", "clientAuth", "keystoreFile", "keystorePass", "keystoreType", "sslProtocol", "ciphers", "keyAlias", "truststoreFile", "truststorePass", "truststoreType"}, new String[]{"acceptCount", "address", "bufferSize", "compressableMimeType", "compression", "connectionLinger", "connectionTimeout", "executor", "host", "keepAliveTimeout", "disableUploadTimeout", "maxHttpHeaderSize", "maxKeepAliveRequests", "maxThreads", "maxSpareThreads", "minSpareThreads", "noCompressionUserAgents", "port", "restrictedUserAgents", "server", "socketBuffer", "tcpNoDelay", "threadPriority", "algorithm", "clientAuth", "keystoreFile", "keystorePass", "keystoreType", "sslProtocol", "ciphers", "keyAlias", "truststoreFile", "truststorePass", "truststoreType"});
        infoFactory.setConstructor(new String[]{"name", "initParams", "protocol", "host", "port", "TomcatContainer", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

