/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert._MessageUtils;

public class EnumConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.Enum";
    public static final String ENUM_ID = "javax.faces.converter.EnumConverter.ENUM";
    public static final String ENUM_NO_CLASS_ID = "javax.faces.converter.EnumConverter.ENUM_NO_CLASS";
    private Class targetClass;
    private boolean isTransient = false;

    public EnumConverter() {
    }

    public EnumConverter(Class targetClass) {
        if (!targetClass.isEnum()) {
            throw new IllegalArgumentException("targetClass for EnumConverter must be an Enum");
        }
        this.targetClass = targetClass;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) throws ConverterException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext can not be null");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent can not be null");
        }
        if (value == null) {
            return "";
        }
        for (Object enumConstant : this.targetClass.getEnumConstants()) {
            if (enumConstant != value) continue;
            return enumConstant.toString();
        }
        return value.toString();
    }

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) throws ConverterException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return null;
        }
        if (this.targetClass == null) {
            Object[] params = new Object[]{value, _MessageUtils.getLabel(facesContext, uiComponent)};
            throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, ENUM_NO_CLASS_ID, params));
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        try {
            return Enum.valueOf(this.targetClass, value);
        }
        catch (IllegalArgumentException e) {
            Object[] params = new Object[]{value, this.firstConstantOfEnum(), _MessageUtils.getLabel(facesContext, uiComponent)};
            throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, ENUM_ID, params));
        }
    }

    private String firstConstantOfEnum() {
        T[] enumConstants = this.targetClass.getEnumConstants();
        if (enumConstants.length != 0) {
            return enumConstants[0].toString();
        }
        return "";
    }

    public void restoreState(FacesContext context, Object state) {
        this.targetClass = (Class)state;
    }

    public Object saveState(FacesContext context) {
        return this.targetClass;
    }

    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    public boolean isTransient() {
        return this.isTransient;
    }
}

