/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component._AttachedListStateWrapper;
import javax.faces.component._AttachedStateWrapper;
import javax.faces.component._ComponentAttributesMap;
import javax.faces.component._ComponentChildrenList;
import javax.faces.component._ComponentFacetMap;
import javax.faces.component._ComponentUtils;
import javax.faces.component._FacetsAndChildrenIterator;
import javax.faces.component._ValueBindingToValueExpression;
import javax.faces.component._ValueExpressionToValueBinding;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIComponentBase
extends UIComponent {
    private static Log log = LogFactory.getLog(UIComponentBase.class);
    private _ComponentAttributesMap _attributesMap = null;
    private List<UIComponent> _childrenList = null;
    private Map<String, UIComponent> _facetMap = null;
    private List<FacesListener> _facesListeners = null;
    private String _clientId = null;
    private String _id = null;
    private UIComponent _parent = null;
    private boolean _transient = false;
    private static final boolean DEFAULT_RENDERED = true;
    private Boolean _rendered = null;
    private String _rendererType = null;

    @Override
    public Map<String, Object> getAttributes() {
        if (this._attributesMap == null) {
            this._attributesMap = new _ComponentAttributesMap(this);
        }
        return this._attributesMap;
    }

    @Override
    public ValueBinding getValueBinding(String name) {
        ValueExpression expression = this.getValueExpression(name);
        if (expression != null) {
            if (expression instanceof _ValueBindingToValueExpression) {
                return ((_ValueBindingToValueExpression)expression).getValueBinding();
            }
            return new _ValueExpressionToValueBinding(expression);
        }
        return null;
    }

    @Override
    public void setValueBinding(String name, ValueBinding binding) {
        this.setValueExpression(name, binding == null ? null : new _ValueBindingToValueExpression(binding));
    }

    @Override
    public String getClientId(FacesContext context) {
        UIComponent namingContainer;
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this._clientId != null) {
            return this._clientId;
        }
        boolean idWasNull = false;
        String id = this.getId();
        if (id == null) {
            UIViewRoot viewRoot = context.getViewRoot();
            if (viewRoot == null) {
                throw new FacesException("Cannot create clientId. No id is assigned for component to create an id and UIViewRoot is not defined: " + this.getPathToComponent(this));
            }
            id = viewRoot.createUniqueId();
            this.setId(id);
            idWasNull = true;
        }
        this._clientId = (namingContainer = _ComponentUtils.findParentNamingContainer(this, false)) != null ? namingContainer.getContainerClientId(context) + ':' + id : id;
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            this._clientId = renderer.convertClientId(context, this._clientId);
        }
        if (idWasNull && log.isWarnEnabled()) {
            log.warn((Object)("WARNING: Component " + this._clientId + " just got an automatic id, because there was no id assigned yet. " + "If this component was created dynamically (i.e. not by a JSP tag) you should assign it an " + "explicit static id or assign it the id you get from " + "the createUniqueId from the current UIViewRoot " + "component right after creation! Path to Component: " + this.getPathToComponent(this)));
        }
        return this._clientId;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        return super.invokeOnComponent(context, clientId, callback);
    }

    @Override
    public void setId(String id) {
        this.isIdValid(id);
        this._id = id;
        this._clientId = null;
    }

    @Override
    public UIComponent getParent() {
        return this._parent;
    }

    @Override
    public void setParent(UIComponent parent) {
        this._parent = parent;
    }

    @Override
    public boolean getRendersChildren() {
        Renderer renderer = this.getRenderer(this.getFacesContext());
        return renderer != null ? renderer.getRendersChildren() : false;
    }

    @Override
    public List<UIComponent> getChildren() {
        if (this._childrenList == null) {
            this._childrenList = new _ComponentChildrenList(this);
        }
        return this._childrenList;
    }

    @Override
    public int getChildCount() {
        return this._childrenList == null ? 0 : this._childrenList.size();
    }

    @Override
    public UIComponent findComponent(String expr) {
        UIComponent findBase;
        if (expr == null) {
            throw new NullPointerException("expr");
        }
        if (expr.length() == 0) {
            return null;
        }
        if (expr.charAt(0) == ':') {
            findBase = _ComponentUtils.getRootComponent(this);
            expr = expr.substring(1);
        } else {
            findBase = this instanceof NamingContainer ? this : _ComponentUtils.findParentNamingContainer(this, true);
        }
        int separator = expr.indexOf(58);
        if (separator == -1) {
            return _ComponentUtils.findComponent(findBase, expr);
        }
        String id = expr.substring(0, separator);
        if ((findBase = _ComponentUtils.findComponent(findBase, id)) == null) {
            return null;
        }
        if (!(findBase instanceof NamingContainer)) {
            throw new IllegalArgumentException("Intermediate identifier " + id + " in search expression " + expr + " identifies a UIComponent that is not a NamingContainer");
        }
        return findBase.findComponent(expr.substring(separator + 1));
    }

    @Override
    public Map<String, UIComponent> getFacets() {
        if (this._facetMap == null) {
            this._facetMap = new _ComponentFacetMap<UIComponent>(this);
        }
        return this._facetMap;
    }

    @Override
    public UIComponent getFacet(String name) {
        return this._facetMap == null ? null : this._facetMap.get(name);
    }

    @Override
    public Iterator<UIComponent> getFacetsAndChildren() {
        return new _FacetsAndChildrenIterator(this._facetMap, this._childrenList);
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (this._facesListeners == null) {
            return;
        }
        for (FacesListener facesListener : this._facesListeners) {
            if (!event.isAppropriateListener(facesListener)) continue;
            event.processListener(facesListener);
        }
    }

    @Override
    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.decode(context, this);
        }
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.encodeBegin(context, this);
        }
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.encodeChildren(context, this);
        }
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.encodeEnd(context, this);
        }
    }

    @Override
    protected void addFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this._facesListeners == null) {
            this._facesListeners = new ArrayList<FacesListener>();
        }
        this._facesListeners.add(listener);
    }

    @Override
    protected FacesListener[] getFacesListeners(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("Class is null");
        }
        if (!FacesListener.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " must implement " + FacesListener.class);
        }
        if (this._facesListeners == null) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        ArrayList<FacesListener> lst = null;
        for (FacesListener facesListener : this._facesListeners) {
            if (!clazz.isAssignableFrom(facesListener.getClass())) continue;
            if (lst == null) {
                lst = new ArrayList<FacesListener>();
            }
            lst.add(facesListener);
        }
        if (lst == null) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        return lst.toArray((FacesListener[])Array.newInstance(clazz, lst.size()));
    }

    @Override
    protected void removeFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (this._facesListeners != null) {
            this._facesListeners.remove(listener);
        }
    }

    @Override
    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("component is not a descendant of a UIViewRoot");
        }
        parent.queueEvent(event);
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator<UIComponent> it = this.getFacetsAndChildren();
        while (it.hasNext()) {
            it.next().processDecodes(context);
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    @Override
    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator<UIComponent> it = this.getFacetsAndChildren();
        while (it.hasNext()) {
            it.next().processValidators(context);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator<UIComponent> it = this.getFacetsAndChildren();
        while (it.hasNext()) {
            it.next().processUpdates(context);
        }
    }

    @Override
    public Object processSaveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this.isTransient()) {
            return null;
        }
        HashMap<String, Object> facetMap = null;
        int facetCount = this.getFacetCount();
        if (facetCount > 0) {
            for (Map.Entry<String, UIComponent> entry : this.getFacets().entrySet()) {
                UIComponent component = entry.getValue();
                if (component.isTransient()) continue;
                if (facetMap == null) {
                    facetMap = new HashMap<String, Object>(facetCount, 1.0f);
                }
                facetMap.put(entry.getKey(), component.processSaveState(context));
            }
        }
        ArrayList<Object> childrenList = null;
        int childCount = this.getChildCount();
        if (childCount > 0) {
            for (UIComponent child : this.getChildren()) {
                Object childState;
                if (child.isTransient()) continue;
                if (childrenList == null) {
                    childrenList = new ArrayList<Object>(childCount);
                }
                if ((childState = child.processSaveState(context)) == null) continue;
                childrenList.add(childState);
            }
        }
        return new Object[]{this.saveState(context), facetMap, childrenList};
    }

    @Override
    public void processRestoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Object[] stateValues = (Object[])state;
        Object myState = stateValues[0];
        Map facetMap = (Map)stateValues[1];
        List childrenList = (List)stateValues[2];
        if (facetMap != null && this.getFacetCount() > 0) {
            for (Map.Entry<String, UIComponent> entry : this.getFacets().entrySet()) {
                Object facetState = facetMap.get(entry.getKey());
                if (facetState != null) {
                    entry.getValue().processRestoreState(context, facetState);
                    continue;
                }
                context.getExternalContext().log("No state found to restore facet " + entry.getKey());
            }
        }
        if (childrenList != null && this.getChildCount() > 0) {
            int idx = 0;
            for (UIComponent child : this.getChildren()) {
                Object childState;
                if (child.isTransient()) continue;
                if ((childState = childrenList.get(idx++)) != null) {
                    child.processRestoreState(context, childState);
                    continue;
                }
                context.getExternalContext().log("No state found to restore child of component " + this.getId());
            }
        }
        this.restoreState(context, myState);
    }

    @Override
    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    protected Renderer getRenderer(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        String rendererType = this.getRendererType();
        if (rendererType == null) {
            return null;
        }
        String renderKitId = context.getViewRoot().getRenderKitId();
        RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        RenderKit renderKit = rkf.getRenderKit(context, renderKitId);
        Renderer renderer = renderKit.getRenderer(this.getFamily(), rendererType);
        if (renderer == null) {
            this.getFacesContext().getExternalContext().log("No Renderer found for component " + this.getPathToComponent(this) + " (component-family=" + this.getFamily() + ", renderer-type=" + rendererType + ")");
            log.warn((Object)("No Renderer found for component " + this.getPathToComponent(this) + " (component-family=" + this.getFamily() + ", renderer-type=" + rendererType + ")"));
        }
        return renderer;
    }

    private String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        this.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf.toString());
        this.getPathToComponent(component.getParent(), buf);
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public void setTransient(boolean transientFlag) {
        this._transient = transientFlag;
    }

    public static Object saveAttachedState(FacesContext context, Object attachedObject) {
        if (attachedObject == null) {
            return null;
        }
        if (attachedObject instanceof List) {
            ArrayList<Object> lst = new ArrayList<Object>(((List)attachedObject).size());
            Iterator it = ((List)attachedObject).iterator();
            while (it.hasNext()) {
                lst.add(UIComponentBase.saveAttachedState(context, it.next()));
            }
            return new _AttachedListStateWrapper(lst);
        }
        if (attachedObject instanceof StateHolder) {
            if (((StateHolder)attachedObject).isTransient()) {
                return null;
            }
            return new _AttachedStateWrapper(attachedObject.getClass(), ((StateHolder)attachedObject).saveState(context));
        }
        if (attachedObject instanceof Serializable) {
            return attachedObject;
        }
        return new _AttachedStateWrapper(attachedObject.getClass(), null);
    }

    public static Object restoreAttachedState(FacesContext context, Object stateObj) throws IllegalStateException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (stateObj == null) {
            return null;
        }
        if (stateObj instanceof _AttachedListStateWrapper) {
            List<Object> lst = ((_AttachedListStateWrapper)stateObj).getWrappedStateList();
            ArrayList<Object> restoredList = new ArrayList<Object>(lst.size());
            Iterator<Object> it = lst.iterator();
            while (it.hasNext()) {
                restoredList.add(UIComponentBase.restoreAttachedState(context, it.next()));
            }
            return restoredList;
        }
        if (stateObj instanceof _AttachedStateWrapper) {
            Object restoredObject;
            Class clazz = ((_AttachedStateWrapper)stateObj).getClazz();
            try {
                restoredObject = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not restore StateHolder of type " + clazz.getName() + " (missing no-args constructor?)", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (restoredObject instanceof StateHolder) {
                Object wrappedState = ((_AttachedStateWrapper)stateObj).getWrappedStateObject();
                ((StateHolder)restoredObject).restoreState(context, wrappedState);
            }
            return restoredObject;
        }
        return stateObj;
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this._id, this._rendered, this._rendererType, this._clientId, this.saveAttributesMap(), UIComponentBase.saveAttachedState(context, this._facesListeners), this.saveBindings(context)};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this._id = (String)values[0];
        this._rendered = (Boolean)values[1];
        this._rendererType = (String)values[2];
        this._clientId = (String)values[3];
        this.restoreAttributesMap(values[4]);
        this._facesListeners = (List)UIComponentBase.restoreAttachedState(context, values[5]);
        this.restoreValueExpressionMap(context, values[6]);
    }

    private Object saveAttributesMap() {
        return this._attributesMap != null ? this._attributesMap.getUnderlyingMap() : null;
    }

    private void restoreAttributesMap(Object stateObj) {
        this._attributesMap = stateObj != null ? new _ComponentAttributesMap(this, (Map)stateObj) : null;
    }

    private Object saveBindings(FacesContext context) {
        if (this.bindings != null) {
            HashMap stateMap = new HashMap(this.bindings.size(), 1.0f);
            for (Map.Entry entry : this.bindings.entrySet()) {
                stateMap.put(entry.getKey(), UIComponentBase.saveAttachedState(context, entry.getValue()));
            }
            return stateMap;
        }
        return null;
    }

    private void restoreValueExpressionMap(FacesContext context, Object stateObj) {
        if (stateObj != null) {
            Map stateMap = (Map)stateObj;
            int initCapacity = (stateMap.size() * 4 + 3) / 3;
            this.bindings = new HashMap(initCapacity);
            for (Map.Entry entry : stateMap.entrySet()) {
                this.bindings.put((String)entry.getKey(), (ValueExpression)UIComponentBase.restoreAttachedState(context, entry.getValue()));
            }
        } else {
            this.bindings = null;
        }
    }

    private void isIdValid(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("component identifier must not be a zero-length String");
        }
        char[] chars = string.toCharArray();
        if (!Character.isLetter(chars[0]) && chars[0] != '_') {
            throw new IllegalArgumentException("component identifier's first character must be a letter or an underscore ('_')! But it is \"" + chars[0] + "\"");
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isDigit(chars[i]) || Character.isLetter(chars[i]) || chars[i] == '-' || chars[i] == '_') continue;
            throw new IllegalArgumentException("Subsequent characters of component identifier must be a letter, a digit, an underscore ('_'), or a dash ('-')! But component identifier contains \"" + chars[i] + "\"");
        }
    }

    <T> T getExpressionValue(String attribute, T explizitValue, T defaultValueIfExpressionNull) {
        return _ComponentUtils.getExpressionValue(this, attribute, explizitValue, defaultValueIfExpressionNull);
    }

    @Override
    public void setRendered(boolean rendered) {
        this._rendered = rendered;
    }

    @Override
    public boolean isRendered() {
        return this.getExpressionValue("rendered", this._rendered, true);
    }

    @Override
    public void setRendererType(String rendererType) {
        this._rendererType = rendererType;
    }

    @Override
    public String getRendererType() {
        return this.getExpressionValue("rendererType", this._rendererType, null);
    }

    @Override
    public int getFacetCount() {
        return this._facetMap == null ? 0 : this._facetMap.size();
    }
}

