/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.plugin.DownloadPoller;

public class DownloadResults
implements Serializable,
DownloadPoller {
    private List removedConfigIDs = new ArrayList();
    private List restartedConfigIDs = new ArrayList();
    private List installedConfigIDs = new ArrayList();
    private List dependenciesPresent = new ArrayList();
    private List dependenciesInstalled = new ArrayList();
    private String currentFile;
    private String currentMessage;
    private int currentFileProgress = -1;
    private Exception failure;
    private boolean finished;
    private long totalDownloadBytes = 0L;

    public synchronized DownloadResults duplicate() {
        DownloadResults other = new DownloadResults();
        other.removedConfigIDs.addAll(this.removedConfigIDs);
        other.restartedConfigIDs.addAll(this.restartedConfigIDs);
        other.installedConfigIDs.addAll(this.installedConfigIDs);
        other.dependenciesPresent.addAll(this.dependenciesPresent);
        other.dependenciesInstalled.addAll(this.dependenciesInstalled);
        other.currentFile = this.currentFile;
        other.currentMessage = this.currentMessage;
        other.currentFileProgress = this.currentFileProgress;
        other.failure = this.failure;
        other.finished = this.finished;
        other.totalDownloadBytes = this.totalDownloadBytes;
        return other;
    }

    public synchronized void addInstalledConfigID(Artifact dep) {
        this.installedConfigIDs.add(dep);
    }

    public synchronized void addRemovedConfigID(Artifact obsolete) {
        this.removedConfigIDs.add(obsolete);
    }

    public synchronized void addRestartedConfigID(Artifact target) {
        this.restartedConfigIDs.add(target);
    }

    public synchronized void addDependencyPresent(Artifact dep) {
        this.dependenciesPresent.add(dep);
    }

    public synchronized void addDependencyInstalled(Artifact dep) {
        this.dependenciesInstalled.add(dep);
    }

    public synchronized void setCurrentFile(String currentFile) {
        this.currentFile = currentFile;
    }

    public synchronized void setCurrentMessage(String currentMessage) {
        this.currentMessage = currentMessage;
    }

    public synchronized void setCurrentFilePercent(int currentFileProgress) {
        this.currentFileProgress = currentFileProgress;
    }

    public synchronized void setFailure(Exception failure) {
        this.failure = failure;
    }

    public synchronized void setFinished() {
        this.finished = true;
    }

    public synchronized void addDownloadBytes(long bytes) {
        this.totalDownloadBytes += bytes;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    public long getTotalDownloadBytes() {
        return this.totalDownloadBytes;
    }

    public Exception getFailure() {
        return this.failure;
    }

    public Artifact[] getInstalledConfigIDs() {
        return this.installedConfigIDs.toArray(new Artifact[this.installedConfigIDs.size()]);
    }

    public Artifact[] getRemovedConfigIDs() {
        return this.removedConfigIDs.toArray(new Artifact[this.installedConfigIDs.size()]);
    }

    public Artifact[] getRestartedConfigIDs() {
        return this.restartedConfigIDs.toArray(new Artifact[this.installedConfigIDs.size()]);
    }

    public Artifact[] getDependenciesPresent() {
        return this.dependenciesPresent.toArray(new Artifact[this.dependenciesPresent.size()]);
    }

    public Artifact[] getDependenciesInstalled() {
        return this.dependenciesInstalled.toArray(new Artifact[this.dependenciesInstalled.size()]);
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public String getCurrentMessage() {
        return this.currentMessage;
    }

    public int getCurrentFilePercent() {
        return this.currentFileProgress;
    }
}

