/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.GeronimoEnvironment;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactory;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.DebugLoggingLifecycleMonitor;
import org.apache.geronimo.kernel.config.LifecycleException;
import org.apache.geronimo.kernel.config.LifecycleMonitor;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.log.GeronimoLogging;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.system.main.CommandLineManifest;
import org.apache.geronimo.system.main.ExceptionUtil;

public class CommandLine {
    protected static final Log log;
    private Kernel kernel;
    private AbstractName configurationName;

    public static void main(String[] args) {
        log.info((Object)"Server startup begun");
        try {
            CommandLineManifest manifest = CommandLineManifest.getManifestEntries();
            List configurations = manifest.getConfigurations();
            AbstractNameQuery mainGBean = manifest.getMainGBeanQuery();
            String mainMethod = manifest.getMainMethod();
            new CommandLine().invokeMainGBean(configurations, mainGBean, mainMethod, args);
            log.info((Object)"Server shutdown completed");
        }
        catch (Exception e) {
            ExceptionUtil.trimStackTrace(e);
            e.printStackTrace();
            System.exit(2);
            throw new AssertionError();
        }
    }

    public void invokeMainGBean(List configurations, AbstractNameQuery mainGBeanQuery, String mainMethod, String[] args) throws Exception {
        this.kernel = this.getBootedKernel();
        this.initializeKernel();
        this.loadConfigurations(configurations);
        log.info((Object)"Server startup completed");
        this.doInvokeMainGBean(mainGBeanQuery, mainMethod, args);
    }

    protected void doInvokeMainGBean(AbstractNameQuery mainGBeanQuery, String mainMethod, String[] args) throws Exception {
        Set matches = this.kernel.listGBeans(mainGBeanQuery);
        if (matches.isEmpty()) {
            throw new Exception("No match for AbstractNameQuery: " + mainGBeanQuery);
        }
        if (matches.size() > 1) {
            throw new Exception("Ambiguous AbstractNameQuery: " + mainGBeanQuery + " matches: " + matches);
        }
        AbstractName mainGBean = (AbstractName)matches.iterator().next();
        this.kernel.invoke(mainGBean, mainMethod, new Object[]{args}, new String[]{String[].class.getName()});
    }

    protected void initializeKernel() throws Exception {
        this.loadBootstrapConfiguration();
        Runtime.getRuntime().addShutdownHook(new Thread("Geronimo shutdown thread"){

            public void run() {
                log.info((Object)"Server shutdown started");
                try {
                    CommandLine.this.stopKernel();
                }
                catch (GBeanNotFoundException gBeanNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBootstrapConfiguration() throws Exception {
        ClassLoader classLoader = CommandLine.class.getClassLoader();
        InputStream in = classLoader.getResourceAsStream("META-INF/config.ser");
        try {
            this.configurationName = ConfigurationUtil.loadBootstrapConfiguration((Kernel)this.kernel, (InputStream)in, (ClassLoader)classLoader);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected Kernel getBootedKernel() throws Exception {
        this.kernel = KernelFactory.newInstance().createKernel("geronimo");
        this.kernel.boot();
        return this.kernel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startKernel(Artifact moduleId) throws Exception {
        this.getBootedKernel();
        ClassLoader classLoader = CommandLine.class.getClassLoader();
        Enumeration<URL> modules = classLoader.getResources("META-INF/config.ser");
        while (modules.hasMoreElements()) {
            URL moduleDataURL = modules.nextElement();
            InputStream in = moduleDataURL.openStream();
            try {
                ConfigurationData moduleData = ConfigurationUtil.readConfigurationData((InputStream)in);
                if (!moduleId.matches(moduleData.getId())) continue;
                this.configurationName = ConfigurationUtil.loadBootstrapConfiguration((Kernel)this.kernel, (ConfigurationData)moduleData, (ClassLoader)classLoader);
                return;
            }
            finally {
                in.close();
            }
        }
        throw new NoSuchConfigException(moduleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfigurations(List configurations) throws NoSuchConfigException, LifecycleException, MissingDependencyException {
        ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
        LinkedHashSet resolvedModules = configurationManager.getArtifactResolver().resolveInClassLoader((Collection)configurations);
        DebugLoggingLifecycleMonitor lifecycleMonitor = new DebugLoggingLifecycleMonitor(log);
        try {
            for (Artifact moduleId : resolvedModules) {
                configurationManager.loadConfiguration(moduleId, (LifecycleMonitor)lifecycleMonitor);
                configurationManager.startConfiguration(moduleId, (LifecycleMonitor)lifecycleMonitor);
            }
        }
        finally {
            ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)configurationManager);
        }
    }

    protected Kernel getKernel() {
        return this.kernel;
    }

    protected void stopKernel() throws GBeanNotFoundException, InternalKernelException {
        this.kernel.stopGBean(this.configurationName);
        this.kernel.shutdown();
    }

    static {
        GeronimoEnvironment.init();
        GeronimoLogging.initialize((GeronimoLogging)GeronimoLogging.ERROR);
        log = LogFactory.getLog((String)CommandLine.class.getName());
    }
}

