/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration.condition;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.system.configuration.condition.ConditionParser;
import org.apache.geronimo.system.configuration.condition.ConditionParserException;
import org.apache.geronimo.system.configuration.condition.JavaVariable;
import org.apache.geronimo.system.configuration.condition.OsVariable;

public class JexlConditionParser
implements ConditionParser {
    private static final Log log = LogFactory.getLog(JexlConditionParser.class);
    private final Map<String, Object> vars = new HashMap<String, Object>();

    public JexlConditionParser() {
        this.vars.put("java", new JavaVariable());
        this.vars.put("os", new OsVariable());
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        this.vars.put("props", props);
    }

    public boolean evaluate(String expression) throws ConditionParserException {
        Object result;
        if (expression == null) {
            throw new IllegalArgumentException("Expression must not be null");
        }
        if (expression.trim().length() == 0) {
            log.debug((Object)"Expression is empty; skipping evaluation");
            return true;
        }
        try {
            result = this.doEvaluate(expression);
        }
        catch (Exception e) {
            throw new ConditionParserException("Failed to evaluate expression: " + expression, e);
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new ConditionParserException("Expression '" + expression + "' did not evaluate to a boolean value; found: " + result);
    }

    private Object doEvaluate(String expression) throws Exception {
        assert (expression != null);
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Evaluating expression: " + expression));
        }
        Expression expr = ExpressionFactory.createExpression((String)expression);
        JexlContext ctx = JexlHelper.createContext();
        ctx.setVars(this.vars);
        Object result = expr.evaluate(ctx);
        if (debug) {
            log.debug((Object)("Result: " + result));
        }
        return result;
    }
}

