/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.XmlUtil;
import org.apache.geronimo.system.configuration.ConfigurationOverride;
import org.apache.geronimo.system.configuration.GBeanOverride;
import org.apache.geronimo.system.configuration.InvalidAttributeException;
import org.apache.geronimo.system.configuration.PluginAttributeStore;
import org.apache.geronimo.system.configuration.ServerOverride;
import org.apache.geronimo.system.configuration.condition.JexlExpressionParser;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalAttributeManager
implements PluginAttributeStore,
PersistentConfigurationList,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog(LocalAttributeManager.class);
    private static final String CONFIG_FILE_PROPERTY = "org.apache.geronimo.config.file";
    private static final String SUBSTITUTIONS_FILE_PROPERTY = "org.apache.geronimo.config.substitutions.file";
    private static final String SUBSTITUTION_PREFIX_PREFIX = "org.apache.geronimo.config.substitution.prefix";
    private static final String BACKUP_EXTENSION = ".bak";
    private static final String TEMP_EXTENSION = ".working";
    private static final int SAVE_BUFFER_MS = 5000;
    private final ServerInfo serverInfo;
    private final String configFile;
    private final boolean readOnly;
    private final JexlExpressionParser expressionParser;
    private File attributeFile;
    private File backupFile;
    private File tempFile;
    private ServerOverride serverOverride;
    private Timer timer;
    private TimerTask currentTask;
    private boolean kernelFullyStarted;
    public static final GBeanInfo GBEAN_INFO;

    public LocalAttributeManager(String configFile, String configSubstitutionsFile, String configSubstitutionsPrefix, boolean readOnly, ServerInfo serverInfo) {
        this.configFile = System.getProperty(CONFIG_FILE_PROPERTY, configFile);
        String resolvedPropertiesFile = System.getProperty(SUBSTITUTIONS_FILE_PROPERTY, configSubstitutionsFile);
        String prefix = System.getProperty(SUBSTITUTION_PREFIX_PREFIX, configSubstitutionsPrefix);
        this.expressionParser = LocalAttributeManager.loadProperties(resolvedPropertiesFile, serverInfo, prefix);
        this.readOnly = readOnly;
        this.serverInfo = serverInfo;
        this.serverOverride = new ServerOverride();
        log.debug((Object)("setting configSubstitutionsFile to " + configSubstitutionsFile + "."));
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized Collection applyOverrides(Artifact configName, Collection untypedGbeanDatas, ClassLoader classLoader) throws InvalidConfigException {
        ArrayList<GBeanData> gbeanDatas = new ArrayList<GBeanData>(untypedGbeanDatas);
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configName);
        if (configuration == null) {
            return gbeanDatas;
        }
        HashMap<Object, GBeanData> datasByName = new HashMap<Object, GBeanData>();
        for (GBeanData gBeanData : gbeanDatas) {
            datasByName.put(gBeanData.getAbstractName(), gBeanData);
            datasByName.put(gBeanData.getAbstractName().getName().get("name"), gBeanData);
        }
        for (Object object : configuration.getGBeans().entrySet()) {
            Map.Entry entry = (Map.Entry)object;
            Object name = entry.getKey();
            GBeanOverride gbean = (GBeanOverride)entry.getValue();
            if (datasByName.containsKey(name) || !gbean.isLoad()) continue;
            if (gbean.getGBeanInfo() == null || !(name instanceof AbstractName)) {
                String sep = "";
                StringBuffer message = new StringBuffer("New GBeans must be specified with ");
                if (gbean.getGBeanInfo() == null) {
                    message.append("a GBeanInfo ");
                    sep = "and ";
                }
                if (!(name instanceof AbstractName)) {
                    message.append(sep).append("a full AbstractName ");
                }
                message.append("configuration=").append(configName);
                message.append(" gbeanName=").append(name);
                throw new InvalidConfigException(message.toString());
            }
            GBeanInfo gbeanInfo = GBeanInfo.getGBeanInfo((String)gbean.getGBeanInfo(), (ClassLoader)classLoader);
            AbstractName abstractName = (AbstractName)name;
            GBeanData gBeanData = new GBeanData(abstractName, gbeanInfo);
            gbeanDatas.add(gBeanData);
        }
        Iterator iterator = gbeanDatas.iterator();
        while (iterator.hasNext()) {
            GBeanData gBeanData = (GBeanData)iterator.next();
            boolean load = this.setAttributes(gBeanData, configuration, configName, classLoader);
            if (load) continue;
            iterator.remove();
        }
        return gbeanDatas;
    }

    private synchronized boolean setAttributes(GBeanData data, ConfigurationOverride configuration, Artifact configName, ClassLoader classLoader) throws InvalidConfigException {
        AbstractName gbeanName = data.getAbstractName();
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null) {
            gbean = configuration.getGBean((String)gbeanName.getName().get("name"));
        }
        if (gbean == null) {
            return true;
        }
        return gbean.applyOverrides(data, configName, gbeanName, classLoader);
    }

    @Override
    public void setModuleGBeans(Artifact moduleName, GBeanOverride[] gbeans) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(moduleName, true);
        for (GBeanOverride gbean : gbeans) {
            configuration.addGBean(gbean);
        }
        this.attributeChanged();
    }

    public synchronized void setValue(Artifact configurationName, AbstractName gbeanName, GAttributeInfo attribute, Object value, ClassLoader classLoader) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null && (gbean = configuration.getGBean((String)gbeanName.getName().get("name"))) == null) {
            gbean = new GBeanOverride(gbeanName, true, this.expressionParser);
            configuration.addGBean(gbeanName, gbean);
        }
        try {
            gbean.setAttribute(attribute.getName(), value, attribute.getType(), classLoader);
            this.attributeChanged();
        }
        catch (InvalidAttributeException e) {
            log.error((Object)e.getMessage());
        }
    }

    public synchronized void setReferencePatterns(Artifact configurationName, AbstractName gbeanName, GReferenceInfo reference, ReferencePatterns patterns) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null && (gbean = configuration.getGBean((String)gbeanName.getName().get("name"))) == null) {
            gbean = new GBeanOverride(gbeanName, true, this.expressionParser);
            configuration.addGBean(gbeanName, gbean);
        }
        gbean.setReferencePatterns(reference.getName(), patterns);
        this.attributeChanged();
    }

    public synchronized void setShouldLoad(Artifact configurationName, AbstractName gbeanName, boolean load) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null) {
            gbean = configuration.getGBean((String)gbeanName.getName().get("name"));
        }
        if (gbean == null) {
            gbean = new GBeanOverride(gbeanName, load, this.expressionParser);
            configuration.addGBean(gbeanName, gbean);
        } else {
            gbean.setLoad(load);
        }
        this.attributeChanged();
    }

    public void addGBean(Artifact configurationName, GBeanData gbeanData, ClassLoader classLoader) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName);
        if (configuration == null) {
            log.debug((Object)("Can not add GBean; Configuration not found " + configurationName));
            return;
        }
        try {
            GBeanOverride gbean = new GBeanOverride(gbeanData, this.expressionParser, classLoader);
            configuration.addGBean(gbean);
            this.attributeChanged();
        }
        catch (InvalidAttributeException e) {
            log.error((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() throws IOException {
        this.ensureParentDirectory();
        if (!this.attributeFile.exists()) {
            return;
        }
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.attributeFile));
        InputSource source = new InputSource(input);
        source.setSystemId(this.attributeFile.toString());
        DocumentBuilderFactory dFactory = XmlUtil.newDocumentBuilderFactory();
        try {
            dFactory.setValidating(true);
            dFactory.setNamespaceAware(true);
            dFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            dFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", LocalAttributeManager.class.getResourceAsStream("/META-INF/schema/attributes-1.1.xsd"));
            DocumentBuilder builder = dFactory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException e) {
                    log.error((Object)("Unable to read saved manageable attributes. SAX parse error: " + e.getMessage() + " at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " in entity " + e.getSystemId()));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Exception deatils", (Throwable)e);
                    }
                }

                public void fatalError(SAXParseException e) {
                    log.error((Object)("Unable to read saved manageable attributes. Fatal SAX parse error: " + e.getMessage() + " at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " in entity " + e.getSystemId()));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Exception deatils", (Throwable)e);
                    }
                }

                public void warning(SAXParseException e) {
                    log.error((Object)("SAX parse warning whilst reading saved manageable attributes: " + e.getMessage() + " at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " in entity " + e.getSystemId()));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Exception deatils", (Throwable)e);
                    }
                }
            });
            Document doc = builder.parse(source);
            Element root = doc.getDocumentElement();
            this.serverOverride = new ServerOverride(root, this.expressionParser);
        }
        catch (SAXException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        catch (InvalidGBeanException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        finally {
            ((InputStream)input).close();
        }
    }

    public synchronized void save() throws IOException {
        if (this.readOnly) {
            return;
        }
        this.ensureParentDirectory();
        if (!this.tempFile.exists() && !this.tempFile.createNewFile()) {
            throw new IOException("Unable to create manageable attribute working file for save " + this.tempFile.getAbsolutePath());
        }
        if (!this.tempFile.canWrite()) {
            throw new IOException("Unable to write to manageable attribute working file for save " + this.tempFile.getAbsolutePath());
        }
        LocalAttributeManager.saveXmlToFile(this.tempFile, this.serverOverride);
        if (this.backupFile.exists() && !this.backupFile.delete()) {
            throw new IOException("Unable to delete old backup file in order to back up current manageable attribute working file for save");
        }
        if (this.attributeFile.exists() && !this.attributeFile.renameTo(this.backupFile)) {
            throw new IOException("Unable to rename " + this.attributeFile.getAbsolutePath() + " to " + this.backupFile.getAbsolutePath() + " in order to back up manageable attribute save file");
        }
        if (!this.tempFile.renameTo(this.attributeFile)) {
            throw new IOException("EXTREMELY CRITICAL!  Unable to move manageable attributes working file to proper file name!  Configuration will revert to defaults unless this is manually corrected!  (could not rename " + this.tempFile.getAbsolutePath() + " to " + this.attributeFile.getAbsolutePath() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXmlToFile(File file, ServerOverride serverOverride) {
        DocumentBuilderFactory dFactory = XmlUtil.newDocumentBuilderFactory();
        dFactory.setValidating(true);
        dFactory.setNamespaceAware(true);
        dFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        dFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", LocalAttributeManager.class.getResourceAsStream("/META-INF/schema/attributes-1.1.xsd"));
        OutputStream output = null;
        try {
            Document doc = dFactory.newDocumentBuilder().newDocument();
            serverOverride.writeXml(doc);
            TransformerFactory xfactory = XmlUtil.newTransformerFactory();
            Transformer xform = xfactory.newTransformer();
            xform.setOutputProperty("indent", "yes");
            xform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            output = new BufferedOutputStream(new FileOutputStream(file));
            StreamResult sr = new StreamResult(output);
            xform.transform(new DOMSource(doc), sr);
            output.flush();
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Unable to write config.xml", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Unable to write config.xml", (Throwable)e);
        }
        catch (TransformerException e) {
            log.error((Object)"Unable to write config.xml", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Unable to write config.xml", (Throwable)e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public synchronized boolean isKernelFullyStarted() {
        return this.kernelFullyStarted;
    }

    public synchronized void setKernelFullyStarted(boolean kernelFullyStarted) {
        this.kernelFullyStarted = kernelFullyStarted;
    }

    public synchronized List restore() throws IOException {
        ArrayList<Artifact> configs = new ArrayList<Artifact>();
        for (Map.Entry<Artifact, ConfigurationOverride> entry : this.serverOverride.getConfigurations().entrySet()) {
            ConfigurationOverride configuration = entry.getValue();
            if (!configuration.isLoad()) continue;
            Artifact configID = entry.getKey();
            configs.add(configID);
        }
        return configs;
    }

    public void startConfiguration(Artifact configurationName) {
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, false);
        if (configuration == null) {
            return;
        }
        configuration.setLoad(true);
        this.attributeChanged();
    }

    public synchronized void addConfiguration(Artifact configurationName) {
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, false);
        if (configuration == null) {
            configuration = this.serverOverride.getConfiguration(configurationName, true);
            configuration.setLoad(false);
            this.attributeChanged();
        }
    }

    public synchronized void removeConfiguration(Artifact configName) {
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configName);
        if (configuration == null) {
            return;
        }
        this.serverOverride.removeConfiguration(configName);
        this.attributeChanged();
    }

    public Artifact[] getListedConfigurations(Artifact query) {
        return this.serverOverride.queryConfigurations(query);
    }

    public void stopConfiguration(Artifact configName) {
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configName);
        if (configuration == null) {
            return;
        }
        configuration.setLoad(false);
        this.attributeChanged();
    }

    public void migrateConfiguration(Artifact oldName, Artifact newName, Configuration configuration) {
        ConfigurationOverride configInfo = this.serverOverride.getConfiguration(oldName);
        if (configInfo == null) {
            throw new IllegalArgumentException("Trying to migrate unknown configuration: " + oldName);
        }
        this.serverOverride.removeConfiguration(oldName);
        configInfo = new ConfigurationOverride(configInfo, newName);
        this.serverOverride.addConfiguration(configInfo);
        this.attributeChanged();
    }

    public boolean hasGBeanAttributes(Artifact configName) {
        ConfigurationOverride configInfo = this.serverOverride.getConfiguration(configName);
        return configInfo != null && !configInfo.getGBeans().isEmpty();
    }

    public synchronized void doStart() throws Exception {
        this.load();
        if (!this.readOnly) {
            this.timer = new Timer();
        }
        log.debug((Object)("Started LocalAttributeManager with data on " + this.serverOverride.getConfigurations().size() + " configurations"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStop() throws Exception {
        boolean doSave = false;
        LocalAttributeManager localAttributeManager = this;
        synchronized (localAttributeManager) {
            if (this.timer != null) {
                this.timer.cancel();
                if (this.currentTask != null) {
                    this.currentTask.cancel();
                    doSave = true;
                }
            }
        }
        if (doSave) {
            this.save();
        }
        log.debug((Object)("Stopped LocalAttributeManager with data on " + this.serverOverride.getConfigurations().size() + " configurations"));
        this.serverOverride = new ServerOverride();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doFail() {
        LocalAttributeManager localAttributeManager = this;
        synchronized (localAttributeManager) {
            if (this.timer != null) {
                this.timer.cancel();
                if (this.currentTask != null) {
                    this.currentTask.cancel();
                }
            }
        }
        this.serverOverride = new ServerOverride();
    }

    private synchronized void ensureParentDirectory() throws IOException {
        File parent;
        if (this.attributeFile == null) {
            this.attributeFile = this.serverInfo.resolveServer(this.configFile);
            this.tempFile = new File(this.attributeFile.getAbsolutePath() + TEMP_EXTENSION);
            this.backupFile = new File(this.attributeFile.getAbsolutePath() + BACKUP_EXTENSION);
        }
        if (!(parent = this.attributeFile.getParentFile()).isDirectory() && !parent.mkdirs()) {
            throw new IOException("Unable to create directory for list:" + parent);
        }
        if (!parent.canRead()) {
            throw new IOException("Unable to read manageable attribute files in directory " + parent.getAbsolutePath());
        }
        if (!this.readOnly && !parent.canWrite()) {
            throw new IOException("Unable to write manageable attribute files to directory " + parent.getAbsolutePath());
        }
    }

    private synchronized void attributeChanged() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        if (this.timer != null) {
            this.currentTask = new TimerTask(){

                public void run() {
                    try {
                        LocalAttributeManager.this.save();
                    }
                    catch (IOException e) {
                        log.error((Object)"IOException occurred while saving attributes", (Throwable)e);
                    }
                    catch (Throwable t) {
                        log.error((Object)"Error occurred during execution of attributeChanged TimerTask", t);
                    }
                }
            };
            this.timer.schedule(this.currentTask, 5000L);
        }
    }

    private static JexlExpressionParser loadProperties(String propertiesFile, ServerInfo serverInfo, String prefix) {
        HashMap<String, String> vars = new HashMap<String, String>();
        if (propertiesFile != null) {
            Properties properties = new Properties();
            File thePropertiesFile = serverInfo.resolveServer(propertiesFile);
            log.debug((Object)("Loading properties file " + thePropertiesFile.getAbsolutePath()));
            try {
                properties.load(new FileInputStream(thePropertiesFile));
            }
            catch (Exception e) {
                log.error((Object)("Caught exception " + e + " trying to open properties file " + thePropertiesFile.getAbsolutePath()));
            }
            LocalAttributeManager.addGeronimoSubstitutions(vars, properties, "");
        }
        LocalAttributeManager.addGeronimoSubstitutions(vars, System.getenv(), prefix);
        LocalAttributeManager.addGeronimoSubstitutions(vars, System.getProperties(), prefix);
        return new JexlExpressionParser(vars);
    }

    private static void addGeronimoSubstitutions(Map<String, String> vars, Map props, String prefix) {
        if (prefix != null) {
            int start = prefix.length();
            for (Map.Entry o : props.entrySet()) {
                Map.Entry entry = o;
                if (!((String)entry.getKey()).startsWith(prefix)) continue;
                vars.put(((String)entry.getKey()).substring(start), (String)entry.getValue());
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(LocalAttributeManager.class, (String)"AttributeStore");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addAttribute("configFile", String.class, true);
        infoFactory.addAttribute("readOnly", Boolean.TYPE, true);
        infoFactory.addAttribute("substitutionsFile", String.class, true);
        infoFactory.addAttribute("substitutionPrefix", String.class, true);
        infoFactory.addInterface(ManageableAttributeStore.class);
        infoFactory.addInterface(PersistentConfigurationList.class);
        infoFactory.setConstructor(new String[]{"configFile", "substitutionsFile", "substitutionPrefix", "readOnly", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

