/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.XmlUtil;
import org.apache.geronimo.system.configuration.InvalidAttributeException;
import org.apache.geronimo.system.configuration.OutputFormat;
import org.apache.geronimo.system.configuration.XMLSerializer;
import org.apache.geronimo.system.configuration.condition.JexlExpressionParser;
import org.apache.geronimo.util.EncryptionManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GBeanOverride
implements Serializable {
    private static final Log log = LogFactory.getLog(GBeanOverride.class);
    private final Object name;
    private boolean load;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final Map<String, ReferencePatterns> references = new LinkedHashMap<String, ReferencePatterns>();
    private final ArrayList<String> clearAttributes = new ArrayList();
    private final ArrayList<String> nullAttributes = new ArrayList();
    private final ArrayList<String> clearReferences = new ArrayList();
    private final String gbeanInfo;
    private final JexlExpressionParser expressionParser;

    public GBeanOverride(String name, boolean load, JexlExpressionParser expressionParser) {
        this.name = name;
        this.load = load;
        this.gbeanInfo = null;
        this.expressionParser = expressionParser;
    }

    public GBeanOverride(AbstractName name, boolean load, JexlExpressionParser expressionParser) {
        this.name = name;
        this.load = load;
        this.gbeanInfo = null;
        this.expressionParser = expressionParser;
    }

    public GBeanOverride(GBeanOverride original, String oldArtifact, String newArtifact) {
        Object name = original.name;
        if (name instanceof String) {
            name = GBeanOverride.replace((String)name, oldArtifact, newArtifact);
        } else if (name instanceof AbstractName) {
            String value = name.toString();
            value = GBeanOverride.replace(value, oldArtifact, newArtifact);
            name = new AbstractName(URI.create(value));
        }
        this.name = name;
        this.load = original.load;
        this.attributes.putAll(original.attributes);
        this.references.putAll(original.references);
        this.clearAttributes.addAll(original.clearAttributes);
        this.nullAttributes.addAll(original.nullAttributes);
        this.clearReferences.addAll(original.clearReferences);
        this.gbeanInfo = original.gbeanInfo;
        this.expressionParser = original.expressionParser;
    }

    private static String replace(String original, String oldArtifact, String newArtifact) {
        int pos = original.indexOf(oldArtifact);
        if (pos == -1) {
            return original;
        }
        int last = -1;
        StringBuffer buf = new StringBuffer();
        while (pos > -1) {
            buf.append(original.substring(last + 1, pos));
            buf.append(newArtifact);
            last = pos + oldArtifact.length() - 1;
            pos = original.indexOf(oldArtifact, last);
        }
        buf.append(original.substring(last + 1));
        return buf.toString();
    }

    public GBeanOverride(GBeanData gbeanData, JexlExpressionParser expressionParser, ClassLoader classLoader) throws InvalidAttributeException {
        GBeanInfo gbeanInfo = gbeanData.getGBeanInfo();
        this.gbeanInfo = gbeanInfo.getSourceClass();
        if (this.gbeanInfo == null) {
            throw new IllegalArgumentException("GBeanInfo must have a source class set");
        }
        this.name = gbeanData.getAbstractName();
        this.load = true;
        for (Map.Entry o : gbeanData.getAttributes().entrySet()) {
            Map.Entry entry = o;
            String attributeName = (String)entry.getKey();
            GAttributeInfo attributeInfo = gbeanInfo.getAttribute(attributeName);
            if (attributeInfo == null) {
                throw new InvalidAttributeException("No attribute: " + attributeName + " for gbean: " + gbeanData.getAbstractName());
            }
            Object attributeValue = entry.getValue();
            this.setAttribute(attributeName, attributeValue, attributeInfo.getType(), classLoader);
        }
        this.references.putAll(gbeanData.getReferences());
        this.expressionParser = expressionParser;
    }

    public GBeanOverride(Element gbean, JexlExpressionParser expressionParser) throws InvalidGBeanException {
        String nameString = gbean.getAttribute("name");
        this.name = nameString.indexOf(63) > -1 ? new AbstractName(URI.create(nameString)) : nameString;
        String gbeanInfoString = gbean.getAttribute("gbeanInfo");
        this.gbeanInfo = gbeanInfoString.length() > 0 ? gbeanInfoString : null;
        if (this.gbeanInfo != null && !(this.name instanceof AbstractName)) {
            throw new InvalidGBeanException("A gbean element using the gbeanInfo attribute must be specified using a full AbstractName: name=" + nameString);
        }
        String loadString = gbean.getAttribute("load");
        this.load = !"false".equals(loadString);
        NodeList attributes = gbean.getElementsByTagName("attribute");
        for (int a = 0; a < attributes.getLength(); ++a) {
            String nullString;
            Element attribute = (Element)attributes.item(a);
            String attributeName = attribute.getAttribute("name");
            if (attribute.hasAttribute("value")) {
                this.setAttribute(attributeName, (String)((Object)EncryptionManager.decrypt((String)attribute.getAttribute("value"))));
                continue;
            }
            if (attribute.hasAttribute("null") && (nullString = attribute.getAttribute("null")).equals("true")) {
                this.setNullAttribute(attributeName);
                continue;
            }
            String rawAttribute = GBeanOverride.getContentsAsText(attribute);
            if (rawAttribute.length() == 0) {
                this.setClearAttribute(attributeName);
                continue;
            }
            String attributeValue = (String)((Object)EncryptionManager.decrypt((String)rawAttribute));
            this.setAttribute(attributeName, attributeValue);
        }
        NodeList references = gbean.getElementsByTagName("reference");
        for (int r = 0; r < references.getLength(); ++r) {
            Element reference = (Element)references.item(r);
            String referenceName = reference.getAttribute("name");
            LinkedHashSet<AbstractNameQuery> objectNamePatterns = new LinkedHashSet<AbstractNameQuery>();
            NodeList patterns = reference.getElementsByTagName("pattern");
            if (patterns.getLength() == 0) {
                this.setClearReference(referenceName);
                continue;
            }
            for (int p = 0; p < patterns.getLength(); ++p) {
                Element pattern = (Element)patterns.item(p);
                if (pattern == null) continue;
                String groupId = GBeanOverride.getChildAsText(pattern, "groupId");
                String artifactId = GBeanOverride.getChildAsText(pattern, "artifactId");
                String version = GBeanOverride.getChildAsText(pattern, "version");
                String type = GBeanOverride.getChildAsText(pattern, "type");
                String module = GBeanOverride.getChildAsText(pattern, "module");
                String name = GBeanOverride.getChildAsText(pattern, "name");
                Artifact referenceArtifact = null;
                if (artifactId != null) {
                    referenceArtifact = new Artifact(groupId, artifactId, version, type);
                }
                HashMap<String, String> nameMap = new HashMap<String, String>();
                if (module != null) {
                    nameMap.put("module", module);
                }
                if (name != null) {
                    nameMap.put("name", name);
                }
                AbstractNameQuery abstractNameQuery = new AbstractNameQuery(referenceArtifact, nameMap, Collections.EMPTY_SET);
                objectNamePatterns.add(abstractNameQuery);
            }
            this.setReferencePatterns(referenceName, new ReferencePatterns(objectNamePatterns));
        }
        this.expressionParser = expressionParser;
    }

    private static String getChildAsText(Element element, String name) throws InvalidGBeanException {
        NodeList children = element.getElementsByTagName(name);
        if (children == null || children.getLength() == 0) {
            return null;
        }
        if (children.getLength() > 1) {
            throw new InvalidGBeanException("invalid name, too many parts named: " + name);
        }
        return GBeanOverride.getContentsAsText((Element)children.item(0));
    }

    private static String getContentsAsText(Element element) throws InvalidGBeanException {
        String value = "";
        NodeList text = element.getChildNodes();
        for (int t = 0; t < text.getLength(); ++t) {
            Node n = text.item(t);
            if (n.getNodeType() == 3) {
                value = value + n.getNodeValue();
                continue;
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            OutputFormat of = new OutputFormat("xml", null, false);
            of.setOmitXMLDeclaration(true);
            XMLSerializer serializer = new XMLSerializer(pw, of);
            try {
                serializer.prepare();
                serializer.serializeNode(n);
                value = value + sw.toString();
                continue;
            }
            catch (IOException ioe) {
                throw new InvalidGBeanException("Error serializing GBean element", (Throwable)ioe);
            }
        }
        return value.trim();
    }

    public Object getName() {
        return this.name;
    }

    public String getGBeanInfo() {
        return this.gbeanInfo;
    }

    public boolean isLoad() {
        return this.load;
    }

    public void setLoad(boolean load) {
        this.load = load;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public ArrayList<String> getClearAttributes() {
        return this.clearAttributes;
    }

    public ArrayList<String> getNullAttributes() {
        return this.nullAttributes;
    }

    public boolean getNullAttribute(String attributeName) {
        return this.nullAttributes.contains(attributeName);
    }

    public boolean getClearAttribute(String attributeName) {
        return this.clearAttributes.contains(attributeName);
    }

    public ArrayList<String> getClearReferences() {
        return this.clearReferences;
    }

    public boolean getClearReference(String referenceName) {
        return this.clearReferences.contains(referenceName);
    }

    public void setClearAttribute(String attributeName) {
        if (!this.clearAttributes.contains(attributeName)) {
            this.clearAttributes.add(attributeName);
        }
    }

    public void setNullAttribute(String attributeName) {
        if (!this.nullAttributes.contains(attributeName)) {
            this.nullAttributes.add(attributeName);
        }
    }

    public void setClearReference(String referenceName) {
        if (!this.clearReferences.contains(referenceName)) {
            this.clearReferences.add(referenceName);
        }
    }

    public void setAttribute(String attributeName, Object attributeValue, String attributeType, ClassLoader classLoader) throws InvalidAttributeException {
        String stringValue = GBeanOverride.getAsText(attributeValue, attributeType, classLoader);
        this.setAttribute(attributeName, stringValue);
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public Map<String, ReferencePatterns> getReferences() {
        return this.references;
    }

    public ReferencePatterns getReferencePatterns(String name) {
        return this.references.get(name);
    }

    public void setReferencePatterns(String name, ReferencePatterns patterns) {
        this.references.put(name, patterns);
    }

    public boolean applyOverrides(GBeanData data, Artifact configName, AbstractName gbeanName, ClassLoader classLoader) throws InvalidConfigException {
        if (!this.isLoad()) {
            return false;
        }
        GBeanInfo gbeanInfo = data.getGBeanInfo();
        for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
            String attributeName = entry.getKey();
            GAttributeInfo attributeInfo = gbeanInfo.getAttribute(attributeName);
            if (attributeInfo == null) {
                throw new InvalidConfigException("No attribute: " + attributeName + " for gbean: " + data.getAbstractName());
            }
            String valueString = entry.getValue();
            Object value = this.getValue(attributeInfo, valueString, configName, gbeanName, classLoader);
            data.setAttribute(attributeName, value);
        }
        for (String string : this.getClearAttributes()) {
            if (!this.getClearAttribute(string)) continue;
            data.clearAttribute(string);
        }
        for (String string : this.getNullAttributes()) {
            if (!this.getNullAttribute(string)) continue;
            data.setAttribute(string, null);
        }
        for (Map.Entry entry : this.getReferences().entrySet()) {
            String referenceName = (String)entry.getKey();
            GReferenceInfo referenceInfo = gbeanInfo.getReference(referenceName);
            if (referenceInfo == null) {
                throw new InvalidConfigException("No reference: " + referenceName + " for gbean: " + data.getAbstractName());
            }
            ReferencePatterns referencePatterns = (ReferencePatterns)entry.getValue();
            data.setReferencePatterns(referenceName, referencePatterns);
        }
        for (String string : this.getClearReferences()) {
            if (!this.getClearReference(string)) continue;
            data.clearReference(string);
        }
        return true;
    }

    private synchronized Object getValue(GAttributeInfo attribute, String value, Artifact configurationName, AbstractName gbeanName, ClassLoader classLoader) {
        if (value == null) {
            return null;
        }
        value = this.substituteVariables(attribute.getName(), value);
        try {
            PropertyEditor editor = PropertyEditors.findEditor((String)attribute.getType(), (ClassLoader)classLoader);
            if (editor == null) {
                log.debug((Object)("Unable to parse attribute of type " + attribute.getType() + "; no editor found"));
                return null;
            }
            editor.setAsText(value);
            log.debug((Object)("Setting value for " + configurationName + "/" + gbeanName + "/" + attribute.getName() + " to value " + value));
            return editor.getValue();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to load attribute type " + attribute.getType()));
            return null;
        }
    }

    public String substituteVariables(String attributeName, String input) {
        if (this.expressionParser != null) {
            return this.expressionParser.parse(input);
        }
        return input;
    }

    public Element writeXml(Document doc, Element parent) {
        Element attribute;
        String name;
        String gbeanName = this.name instanceof String ? (String)this.name : this.name.toString();
        Element gbean = doc.createElement("gbean");
        parent.appendChild(gbean);
        gbean.setAttribute("name", gbeanName);
        if (this.gbeanInfo != null) {
            gbean.setAttribute("gbeanInfo", this.gbeanInfo);
        }
        if (!this.load) {
            gbean.setAttribute("load", "false");
        }
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            name = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                this.setNullAttribute(name);
                continue;
            }
            if (this.getNullAttribute(name)) {
                this.nullAttributes.remove(name);
            }
            if (name.toLowerCase().indexOf("password") > -1) {
                value = EncryptionManager.encrypt((Serializable)((Object)value));
            }
            Element attribute2 = doc.createElement("attribute");
            attribute2.setAttribute("name", name);
            gbean.appendChild(attribute2);
            if (value.length() == 0) {
                attribute2.setAttribute("value", "");
                continue;
            }
            try {
                DocumentBuilderFactory factory = XmlUtil.newDocumentBuilderFactory();
                DocumentBuilder builder = factory.newDocumentBuilder();
                value = value.replaceAll("&(?!amp;)", "&amp;");
                String xml = "<fragment>" + value + "</fragment>";
                InputSource input = new InputSource(new StringReader(xml));
                Document fragment = builder.parse(input);
                Node root = fragment.getFirstChild();
                NodeList children = root.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    child = doc.importNode(child, true);
                    attribute2.appendChild(child);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to write attribute value fragment: " + e.getMessage(), e);
            }
        }
        for (String string : this.clearAttributes) {
            attribute = doc.createElement("attribute");
            gbean.appendChild(attribute);
            attribute.setAttribute("name", string);
        }
        for (String string : this.nullAttributes) {
            attribute = doc.createElement("attribute");
            gbean.appendChild(attribute);
            attribute.setAttribute("name", string);
            attribute.setAttribute("null", "true");
        }
        for (Map.Entry entry : this.references.entrySet()) {
            name = (String)entry.getKey();
            ReferencePatterns patterns = (ReferencePatterns)entry.getValue();
            Element reference = doc.createElement("reference");
            reference.setAttribute("name", name);
            gbean.appendChild(reference);
            Set<AbstractNameQuery> patternSet = patterns.isResolved() ? Collections.singleton(new AbstractNameQuery(patterns.getAbstractName())) : patterns.getPatterns();
            for (AbstractNameQuery pattern : patternSet) {
                Map nameMap;
                Element pat = doc.createElement("pattern");
                reference.appendChild(pat);
                Artifact artifact = pattern.getArtifact();
                if (artifact != null) {
                    if (artifact.getGroupId() != null) {
                        Element group = doc.createElement("groupId");
                        group.appendChild(doc.createTextNode(artifact.getGroupId()));
                        pat.appendChild(group);
                    }
                    if (artifact.getArtifactId() != null) {
                        Element art = doc.createElement("artifactId");
                        art.appendChild(doc.createTextNode(artifact.getArtifactId()));
                        pat.appendChild(art);
                    }
                    if (artifact.getVersion() != null) {
                        Element version = doc.createElement("version");
                        version.appendChild(doc.createTextNode(artifact.getVersion().toString()));
                        pat.appendChild(version);
                    }
                    if (artifact.getType() != null) {
                        Element type = doc.createElement("type");
                        type.appendChild(doc.createTextNode(artifact.getType()));
                        pat.appendChild(type);
                    }
                }
                if ((nameMap = pattern.getName()).get("module") != null) {
                    Element module = doc.createElement("module");
                    module.appendChild(doc.createTextNode(nameMap.get("module").toString()));
                    pat.appendChild(module);
                }
                if (nameMap.get("name") == null) continue;
                Element patName = doc.createElement("name");
                patName.appendChild(doc.createTextNode(nameMap.get("name").toString()));
                pat.appendChild(patName);
            }
        }
        for (String string : this.clearReferences) {
            Element reference = doc.createElement("reference");
            reference.setAttribute("name", string);
            gbean.appendChild(reference);
        }
        return gbean;
    }

    public static String getAsText(Object value, String type, ClassLoader classLoader) throws InvalidAttributeException {
        try {
            String attributeStringValue = null;
            if (value != null) {
                PropertyEditor editor = PropertyEditors.findEditor((String)type, (ClassLoader)classLoader);
                if (editor == null) {
                    throw new InvalidAttributeException("Unable to format attribute of type " + type + "; no editor found");
                }
                editor.setValue(value);
                attributeStringValue = editor.getAsText();
            }
            return attributeStringValue;
        }
        catch (ClassNotFoundException e) {
            throw (InvalidAttributeException)new InvalidAttributeException("Unable to store attribute type " + type).initCause(e);
        }
    }
}

