/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.remote;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileUploadServlet
extends HttpServlet {
    public static final int REMOTE_DEPLOY_REQUEST_VER_0 = 0;
    public static final int REMOTE_DEPLOY_RESPONSE_VER_0 = 0;
    public static final int REMOTE_DEPLOY_REQUEST_VER = 0;
    public static final int REMOTE_DEPLOY_RESPONSE_VER = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int fileCount = 0;
        int filesCreated = 0;
        String[] names = null;
        String status = "OK";
        DataInputStream in = null;
        try {
            in = new DataInputStream((InputStream)request.getInputStream());
            int reqVer = in.readInt();
            if (reqVer >= 0 && reqVer <= 0) {
                fileCount = in.readInt();
                names = new String[fileCount];
                for (int i = 0; i < fileCount; ++i) {
                    String fileName = in.readUTF();
                    long length = in.readLong();
                    File temp = new File(System.getProperty("java.io.tmpdir"), fileName.trim());
                    temp.createNewFile();
                    temp.deleteOnExit();
                    names[i] = temp.getAbsolutePath();
                    FileUploadServlet.readToFile(in, temp, length);
                    ++filesCreated;
                }
            }
        }
        catch (IOException e) {
            status = "ERROR: " + e.getMessage();
        }
        finally {
            if (in != null) {
                in.close();
                in = null;
            }
        }
        DataOutputStream out = null;
        try {
            out = new DataOutputStream((OutputStream)response.getOutputStream());
            out.writeInt(0);
            out.writeUTF(status);
            if (filesCreated == fileCount) {
                out.writeInt(fileCount);
                for (int i = 0; i < names.length; ++i) {
                    out.writeUTF(names[i]);
                }
            } else {
                out.writeInt(0);
            }
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readToFile(DataInputStream in, File temp, long length) throws IOException {
        long total;
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(temp));
        try {
            int read;
            byte[] buf = new byte[8192];
            total = 0L;
            while ((read = in.read(buf, 0, (int)Math.min((long)buf.length, length - total))) > -1) {
                out.write(buf, 0, read);
                if ((total += (long)read) != length) continue;
                break;
            }
        }
        finally {
            try {
                out.flush();
            }
            catch (IOException e) {}
            out.close();
            out = null;
        }
        if (total != length) {
            throw new IOException("Unable to read entire upload file (" + total + "B expecting " + length + "B)");
        }
    }
}

