/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.util;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.rest.internal.web.util.JsonWriter;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class JSONUtils {
    private static AtomicReference<ObjectMapper> objectMapper = new AtomicReference<Object>(null);

    public static void setObjectMapper(ObjectMapper objectMapper) {
        JSONUtils.objectMapper.compareAndSet(null, objectMapper);
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper localObjectMapper = (ObjectMapper)objectMapper.get();
        Assert.state((localObjectMapper != null ? 1 : 0) != 0, (String)"The ObjectMapper reference must not be null!");
        return localObjectMapper;
    }

    public static JsonGenerator enableDisableJSONGeneratorFeature(JsonGenerator generator) {
        generator.enable(JsonGenerator.Feature.ESCAPE_NON_ASCII);
        generator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        return generator;
    }

    public static String formulateJsonForListFunctionsCall(Set<String> functionIds) {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature((JsonGenerator)JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            generator.writeStartObject();
            generator.writeFieldName("functions");
            JsonWriter.writeCollectionAsJson((JsonGenerator)generator, functionIds);
            generator.writeEndObject();
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String formulateJsonForListKeys(Object[] keys, String fieldName) {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature((JsonGenerator)JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            generator.writeStartObject();
            generator.writeFieldName(fieldName);
            JsonWriter.writeObjectArrayAsJson((JsonGenerator)generator, (Object[])keys, null);
            generator.writeEndObject();
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String formulateJsonForListRegions(Set<Region<?, ?>> regions, String fieldName) {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature((JsonGenerator)JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            generator.writeStartObject();
            generator.writeFieldName(fieldName);
            JsonWriter.writeRegionSetAsJson((JsonGenerator)generator, regions);
            generator.writeEndObject();
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String formulateJsonForListQueriesCall(Region<String, String> queryRegion) {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature((JsonGenerator)JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            JsonWriter.writeQueryListAsJson((JsonGenerator)generator, (String)"queries", queryRegion);
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String formulateJsonForExistingQuery(String queryId, String oql) {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature((JsonGenerator)JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            JsonWriter.writeQueryAsJson((JsonGenerator)generator, (String)queryId, (String)oql);
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String convertCollectionToJson(Collection<Object> collection) {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature((JsonGenerator)JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            JsonWriter.writeCollectionAsJson((JsonGenerator)generator, collection);
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }
}

