/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.security;

import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.GemFireSecurityException;
import org.springframework.stereotype.Component;

@Component(value="securityService")
public class RestSecurityService {
    private SecurityService securityService = SecurityService.getSecurityService();

    public boolean authorize(String resource, String operation) {
        return this.authorize(resource, operation, null, null);
    }

    public boolean authorize(String resource, String operation, String region) {
        return this.authorize(resource, operation, region, null);
    }

    public boolean authorize(String resource, String operation, String region, String key) {
        try {
            this.securityService.authorize(resource, operation, region, key);
            return true;
        }
        catch (GemFireSecurityException ex) {
            return false;
        }
    }

    public boolean authorize(String operation, String region, String[] keys) {
        boolean authorized = false;
        for (String key : keys) {
            authorized = this.authorize("DATA", operation, region, key);
            if (authorized) continue;
            return false;
        }
        return true;
    }

    public Object postProcess(String regionPath, Object key, Object value, boolean valueIsSerialized) {
        return this.securityService.postProcess(regionPath, key, value, valueIsSerialized);
    }
}

