/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.security;

import java.util.Collection;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.GemFireSecurityException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.stereotype.Component;

@Component
public class GeodeAuthenticationProvider
implements AuthenticationProvider {
    private SecurityService securityService = SecurityService.getSecurityService();

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        String password = authentication.getCredentials().toString();
        try {
            this.securityService.login(username, password);
            return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, (Collection)AuthorityUtils.NO_AUTHORITIES);
        }
        catch (GemFireSecurityException e) {
            throw new BadCredentialsException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class);
    }
}

