/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.util;

import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class IdentifiableUtils {
    private static final AtomicLong ID_SEQUENCE = new AtomicLong(0L);
    protected static final Logger LOGGER = Logger.getLogger(IdentifiableUtils.class.getName());

    public static synchronized long createId() {
        return ID_SEQUENCE.incrementAndGet();
    }

    public static synchronized Long createId(Long baseId) {
        long delta = (baseId != null ? baseId : 0L) - ID_SEQUENCE.get();
        long newId = delta > 0L ? ID_SEQUENCE.addAndGet(delta) : IdentifiableUtils.createId();
        return newId;
    }

    public static <T> T getId(Object identifiableObject) {
        if (IdentifiableUtils.isGetIdMethodAvailable((Object)identifiableObject)) {
            MethodInvoker method = new MethodInvoker();
            method.setTargetObject(identifiableObject);
            method.setTargetMethod("getId");
            try {
                return (T)method.invoke();
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isGetIdMethodAvailable(Object identifiableObject) {
        return identifiableObject != null && ClassUtils.hasMethod(identifiableObject.getClass(), (String)"getId", (Class[])new Class[0]);
    }

    public static <T> void setId(Object identifiableObject, T id) {
        if (IdentifiableUtils.isSetIdMethodAvailable((Object)identifiableObject, id)) {
            MethodInvoker method = new MethodInvoker();
            method.setTargetObject(identifiableObject);
            method.setTargetMethod("setId");
            method.setArguments(new Object[]{id});
            try {
                method.prepare();
                method.invoke();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Failed to set ID (%1$s) on Object (%2$s)!", id, identifiableObject), e);
            }
        } else {
            LOGGER.warning(String.format("Not able to set ID (%1$s) of type (%2$s) on Object of type (%3$s)", id, ObjectUtils.nullSafeClassName(id), ObjectUtils.nullSafeClassName((Object)identifiableObject)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> boolean isSetIdMethodAvailable(Object identifiableObject, T id) {
        if (identifiableObject == null) return false;
        if (!ClassUtils.hasMethod(identifiableObject.getClass(), (String)"setId", (Class[])new Class[]{id == null ? Object.class : id.getClass()})) return false;
        return true;
    }
}

