/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.swagger.config;

import com.mangofactory.swagger.configuration.JacksonScalaSupport;
import com.mangofactory.swagger.configuration.SpringSwaggerConfig;
import com.mangofactory.swagger.configuration.SpringSwaggerModelConfig;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.SwaggerApiResourceListing;
import com.mangofactory.swagger.core.SwaggerPathProvider;
import com.mangofactory.swagger.scanners.ApiListingReferenceScanner;
import com.wordnik.swagger.model.ApiInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.rest.internal.web.swagger.config.RestApiPathProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"com.mangofactory.swagger"})
public class SwaggerConfig {
    protected static final List<String> DEFAULT_INCLUDE_PATTERNS = Arrays.asList("/.*");
    protected static final String SWAGGER_GROUP = "gemfireApi";
    @Autowired
    private SpringSwaggerConfig springSwaggerConfig;
    @Autowired
    private SpringSwaggerModelConfig springSwaggerModelConfig;
    @Value(value="${app.docs}")
    private String docsLocation;

    private ApiInfo apiInfo() {
        return new ApiInfo(LocalizedStrings.SwaggerConfig_VENDOR_PRODUCT_LINE.toLocalizedString(), LocalizedStrings.SwaggerConfig_DESCRIPTOR.toLocalizedString(), LocalizedStrings.SwaggerConfig_EULA_LINK.toLocalizedString(), LocalizedStrings.SwaggerConfig_SUPPORT_LINK.toLocalizedString(), LocalizedStrings.SwaggerConfig_DOC_TITLE.toLocalizedString(), LocalizedStrings.SwaggerConfig_DOC_LINK.toLocalizedString());
    }

    @Bean
    public JacksonScalaSupport jacksonScalaSupport() {
        JacksonScalaSupport jacksonScalaSupport = new JacksonScalaSupport();
        jacksonScalaSupport.setRegisterScalaModule(Boolean.valueOf(true));
        return jacksonScalaSupport;
    }

    @Bean
    public SwaggerApiResourceListing swaggerApiResourceListing() {
        SwaggerApiResourceListing swaggerApiResourceListing = new SwaggerApiResourceListing(this.springSwaggerConfig.swaggerCache(), SWAGGER_GROUP);
        swaggerApiResourceListing.setSwaggerGlobalSettings(this.swaggerGlobalSettings());
        swaggerApiResourceListing.setSwaggerPathProvider((SwaggerPathProvider)this.apiPathProvider());
        swaggerApiResourceListing.setApiInfo(this.apiInfo());
        swaggerApiResourceListing.setApiListingReferenceScanner(this.apiListingReferenceScanner());
        swaggerApiResourceListing.setAuthorizationTypes(Collections.emptyList());
        return swaggerApiResourceListing;
    }

    @Bean
    public SwaggerGlobalSettings swaggerGlobalSettings() {
        SwaggerGlobalSettings swaggerGlobalSettings = new SwaggerGlobalSettings();
        swaggerGlobalSettings.setGlobalResponseMessages(this.springSwaggerConfig.defaultResponseMessages());
        swaggerGlobalSettings.setIgnorableParameterTypes(this.springSwaggerConfig.defaultIgnorableParameterTypes());
        swaggerGlobalSettings.setParameterDataTypes(this.springSwaggerModelConfig.defaultParameterDataTypes());
        return swaggerGlobalSettings;
    }

    @Bean
    public ApiListingReferenceScanner apiListingReferenceScanner() {
        ApiListingReferenceScanner apiListingReferenceScanner = new ApiListingReferenceScanner();
        apiListingReferenceScanner.setRequestMappingHandlerMapping(this.springSwaggerConfig.swaggerRequestMappingHandlerMappings());
        apiListingReferenceScanner.setExcludeAnnotations(this.springSwaggerConfig.defaultExcludeAnnotations());
        apiListingReferenceScanner.setIncludePatterns(DEFAULT_INCLUDE_PATTERNS);
        apiListingReferenceScanner.setResourceGroupingStrategy(this.springSwaggerConfig.defaultResourceGroupingStrategy());
        apiListingReferenceScanner.setSwaggerPathProvider((SwaggerPathProvider)this.apiPathProvider());
        apiListingReferenceScanner.setSwaggerGroup(SWAGGER_GROUP);
        return apiListingReferenceScanner;
    }

    @Bean
    public RestApiPathProvider apiPathProvider() {
        RestApiPathProvider apiPathProvider = new RestApiPathProvider(this.docsLocation);
        apiPathProvider.setDefaultPathProvider(this.springSwaggerConfig.defaultSwaggerPathProvider());
        return apiPathProvider;
    }
}

