/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.swagger.config;

import com.mangofactory.swagger.core.SwaggerPathProvider;
import java.net.UnknownHostException;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.net.SocketCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

public class RestApiPathProvider
implements SwaggerPathProvider {
    @Autowired
    private ServletContext servletContext;
    private final String docsLocation;
    private SwaggerPathProvider defaultPathProvider;

    public RestApiPathProvider(String docsLocation) {
        Assert.isTrue((!org.apache.geode.internal.lang.StringUtils.isBlank((String)docsLocation) ? 1 : 0) != 0, (String)"The docs location must be specified!");
        DistributionConfig config = InternalDistributedSystem.getAnyInstance().getConfig();
        String scheme = config.getHttpServiceSSLEnabled() ? "https" : "http";
        this.docsLocation = scheme + "://" + this.getBindAddressForHttpService() + ":" + config.getHttpServicePort();
    }

    private String getBindAddressForHttpService() {
        DistributionConfig config = InternalDistributedSystem.getAnyInstance().getConfig();
        String bindAddress = config.getHttpServiceBindAddress();
        if (StringUtils.isBlank((String)bindAddress)) {
            if (StringUtils.isBlank((String)config.getServerBindAddress())) {
                if (StringUtils.isBlank((String)config.getBindAddress())) {
                    try {
                        bindAddress = SocketCreator.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                    }
                } else {
                    bindAddress = config.getBindAddress();
                }
            } else {
                bindAddress = config.getServerBindAddress();
            }
        }
        return bindAddress;
    }

    public String getApiResourcePrefix() {
        return this.defaultPathProvider.getApiResourcePrefix();
    }

    public String getAppBasePath() {
        return UriComponentsBuilder.fromHttpUrl((String)this.docsLocation).path(this.servletContext.getContextPath()).build().toString();
    }

    public String getSwaggerDocumentationBasePath() {
        return UriComponentsBuilder.fromHttpUrl((String)this.getAppBasePath()).pathSegment(new String[]{"api-docs/"}).build().toString();
    }

    public String getRequestMappingEndpoint(String requestMappingPattern) {
        return this.defaultPathProvider.getRequestMappingEndpoint(requestMappingPattern);
    }

    public void setDefaultPathProvider(SwaggerPathProvider defaultSwaggerPathProvider) {
        this.defaultPathProvider = defaultSwaggerPathProvider;
    }
}

