/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.security;

import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.rest.internal.web.security.GeodeAuthentication;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.shiro.subject.Subject;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class GeodeAuthenticationProvider
implements AuthenticationProvider {
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        String password = authentication.getCredentials().toString();
        try {
            Subject subject = IntegratedSecurityService.getSecurityService().login(username, password);
            if (subject != null) {
                return new GeodeAuthentication(subject.getPrincipal(), authentication.getCredentials());
            }
        }
        catch (AuthenticationFailedException authFailedEx) {
            throw new BadCredentialsException("Invalid username or password");
        }
        return authentication;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

