/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.controllers;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.rest.internal.web.controllers.AbstractBaseController;
import org.apache.geode.rest.internal.web.exception.GemfireRestException;
import org.apache.geode.rest.internal.web.util.ArrayUtils;
import org.apache.geode.rest.internal.web.util.JSONUtils;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller(value="functionController")
@Api(value="functions", description="Rest api for gemfire function execution")
@RequestMapping(value={"/v1/functions"})
public class FunctionAccessController
extends AbstractBaseController {
    private static final Logger logger = LogService.getLogger();
    protected static final String REST_API_VERSION = "/v1";

    protected String getRestApiVersion() {
        return REST_API_VERSION;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="list all functions", notes="list all functions available in the GemFire cluster", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<?> list() {
        this.securityService.authorizeDataRead();
        if (logger.isDebugEnabled()) {
            logger.debug("Listing all registered Functions in GemFire...");
        }
        Map registeredFunctions = FunctionService.getRegisteredFunctions();
        String listFunctionsAsJson = JSONUtils.formulateJsonForListFunctionsCall(registeredFunctions.keySet());
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri(new String[]{"functions"}));
        return new ResponseEntity((Object)listFunctionsAsJson, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{functionId}"}, produces={"application/json"})
    @ApiOperation(value="execute function", notes="Execute function with arguments on regions, members, or group(s). By default function will be executed on all nodes if none of (onRegion, onMembers, onGroups) specified", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=500, message="if GemFire throws an error or exception"), @ApiResponse(code=400, message="if Function arguments specified as JSON document in the request body is invalid")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<String> execute(@PathVariable(value="functionId") String functionId, @RequestParam(value="onRegion", required=false) String region, @RequestParam(value="onMembers", required=false) String[] members, @RequestParam(value="onGroups", required=false) String[] groups, @RequestParam(value="filter", required=false) String[] filter, @RequestBody(required=false) String argsInBody) {
        ResultCollector results;
        this.securityService.authorizeDataWrite();
        Execution function = null;
        functionId = this.decode(functionId);
        if (StringUtils.hasText((String)region)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function ({}) with arguments ({}) on Region ({})...", (Object)functionId, (Object)ArrayUtils.toString((String[])new String[]{argsInBody}), (Object)region);
            }
            region = this.decode(region);
            try {
                function = FunctionService.onRegion((Region)this.getRegion(region));
            }
            catch (FunctionException fe) {
                throw new GemfireRestException(String.format("The Region identified by name (%1$s) could not found!", region), (Throwable)fe);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])members)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function ({}) with arguments ({}) on Member ({})...", (Object)functionId, (Object)ArrayUtils.toString((String[])new String[]{argsInBody}), (Object)ArrayUtils.toString((String[])members));
            }
            try {
                function = FunctionService.onMembers((Set)this.getMembers(members));
            }
            catch (FunctionException fe) {
                throw new GemfireRestException("Could not found the specified members in distributed system!", (Throwable)fe);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])groups)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function ({}) with arguments ({}) on Groups ({})...", (Object)functionId, (Object)ArrayUtils.toString((String[])new String[]{argsInBody}), (Object)ArrayUtils.toString((String[])groups));
            }
            try {
                function = FunctionService.onMembers((String[])groups);
            }
            catch (FunctionException fe) {
                throw new GemfireRestException("no member(s) are found belonging to the provided group(s)!", (Throwable)fe);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing Function ({}) with arguments ({}) on all Members...", (Object)functionId, (Object)ArrayUtils.toString((String[])new String[]{argsInBody}));
        }
        try {
            function = FunctionService.onMembers((Set)this.getAllMembersInDS());
        }
        catch (FunctionException fe) {
            throw new GemfireRestException("Distributed system does not contain any valid data node to run the specified  function!", (Throwable)fe);
        }
        if (!ArrayUtils.isEmpty((Object[])filter)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function ({}) with filter ({})", (Object)functionId, (Object)ArrayUtils.toString((String[])filter));
            }
            Set filter1 = ArrayUtils.asSet((String[])filter);
            function = function.withFilter(filter1);
        }
        try {
            Object[] args;
            results = argsInBody != null ? ((args = this.jsonToObjectArray(argsInBody)).length == 1 ? function.withArgs(args[0]).execute(functionId) : function.withArgs((Object)args).execute(functionId)) : function.execute(functionId);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException("Key is of an inappropriate type for this region!", (Throwable)cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException("Specified key is null and this region does not permit null keys!", (Throwable)npe);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has encountered low memory condition!", (Throwable)lme);
        }
        catch (IllegalArgumentException ie) {
            throw new GemfireRestException("Input parameter is null! ", (Throwable)ie);
        }
        catch (FunctionException fe) {
            throw new GemfireRestException("Server has encountered error while executing the function!", (Throwable)fe);
        }
        try {
            Object functionResult = results.getResult();
            if (functionResult instanceof List) {
                HttpHeaders headers = new HttpHeaders();
                headers.setLocation(this.toUri(new String[]{"functions", functionId}));
                try {
                    String functionResultAsJson = JSONUtils.convertCollectionToJson((Collection)((ArrayList)functionResult));
                    return new ResponseEntity((Object)functionResultAsJson, (MultiValueMap)headers, HttpStatus.OK);
                }
                catch (JSONException e) {
                    throw new GemfireRestException("Could not convert function results into Restful (JSON) format!", (Throwable)e);
                }
            }
            throw new GemfireRestException("Function has returned results that could not be converted into Restful (JSON) format!");
        }
        catch (FunctionException fe) {
            fe.printStackTrace();
            throw new GemfireRestException("Server has encountered an error while processing function execution!", (Throwable)fe);
        }
    }
}

