/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.controllers;

import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.rest.internal.web.controllers.AbstractBaseController;
import org.apache.geode.rest.internal.web.controllers.support.RestServersResultCollector;
import org.apache.geode.rest.internal.web.exception.GemfireRestException;
import org.apache.geode.rest.internal.web.util.ArrayUtils;
import org.apache.geode.rest.internal.web.util.JSONUtils;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class CommonCrudController
extends AbstractBaseController {
    private static final Logger logger = LogService.getLogger();

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json", "application/json"})
    @ApiOperation(value="list all resources (Regions)", notes="List all available resources (Regions) in the GemFire cluster", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    public ResponseEntity<?> regions() {
        this.securityService.authorizeDataRead();
        if (logger.isDebugEnabled()) {
            logger.debug("Listing all resources (Regions) in GemFire...");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri(new String[0]));
        Set regions = this.getCache().rootRegions();
        String listRegionsAsJson = JSONUtils.formulateJsonForListRegions((Set)regions, (String)"regions");
        return new ResponseEntity((Object)listRegionsAsJson, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{region}/keys"}, produces={"application/json"})
    @ApiOperation(value="list all keys", notes="List all keys in region", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=404, message="Region does not exist"), @ApiResponse(code=500, message="GemFire throws an error or exception")})
    public ResponseEntity<?> keys(@PathVariable(value="region") String region) {
        this.securityService.authorizeRegionRead(region);
        if (logger.isDebugEnabled()) {
            logger.debug("Reading all Keys in Region ({})...", (Object)region);
        }
        region = this.decode(region);
        Object[] keys = this.getKeys(region, null);
        String listKeysAsJson = JSONUtils.formulateJsonForListKeys((Object[])keys, (String)"keys");
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri(new String[]{region, "keys"}));
        return new ResponseEntity((Object)listKeysAsJson, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{region}/{keys}"}, produces={"application/json"})
    @ApiOperation(value="delete data for key(s)", notes="Delete data for single key or specific keys in region", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=404, message="Region or key(s) does not exist"), @ApiResponse(code=500, message="GemFire throws an error or exception")})
    public ResponseEntity<?> delete(@PathVariable(value="region") String region, @PathVariable(value="keys") String[] keys) {
        for (String key : keys) {
            this.securityService.authorizeRegionWrite(region, key);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Delete data for key {} on region {}", (Object)ArrayUtils.toString((Object[])keys), (Object)region);
        }
        region = this.decode(region);
        this.deleteValues(region, (Object[])keys);
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{region}"})
    @ApiOperation(value="delete all data", notes="Delete all data in the region", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=404, message="Region does not exist"), @ApiResponse(code=500, message="if GemFire throws an error or exception")})
    public ResponseEntity<?> delete(@PathVariable(value="region") String region) {
        this.securityService.authorizeRegionWrite(region);
        if (logger.isDebugEnabled()) {
            logger.debug("Deleting all data in Region ({})...", (Object)region);
        }
        region = this.decode(region);
        this.deleteValues(region);
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.HEAD}, value={"/ping"})
    @ApiOperation(value="Check Rest service status ", notes="Check whether gemfire REST service is up and running!", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="if GemFire throws an error or exception")})
    public ResponseEntity<?> ping() {
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/servers"})
    @ApiOperation(value="fetch all REST enabled servers in the DS", notes="Find all gemfire node where developer REST service is up and running!", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=500, message="if GemFire throws an error or exception")})
    public ResponseEntity<?> servers() {
        Execution function;
        this.securityService.authorizeClusterRead();
        if (logger.isDebugEnabled()) {
            logger.debug("Executing function to get REST enabled gemfire nodes in the DS!");
        }
        try {
            function = FunctionService.onMembers((Set)this.getAllMembersInDS());
        }
        catch (FunctionException fe) {
            throw new GemfireRestException("Disributed system does not contain any valid data node that can host REST service!", (Throwable)fe);
        }
        try {
            ResultCollector results = function.withCollector((ResultCollector)new RestServersResultCollector()).execute(GemFireCacheImpl.FIND_REST_ENABLED_SERVERS_FUNCTION_ID);
            Object functionResult = results.getResult();
            if (functionResult instanceof List) {
                HttpHeaders headers = new HttpHeaders();
                headers.setLocation(this.toUri(new String[]{"servers"}));
                try {
                    String functionResultAsJson = JSONUtils.convertCollectionToJson((Collection)((ArrayList)functionResult));
                    return new ResponseEntity((Object)functionResultAsJson, (MultiValueMap)headers, HttpStatus.OK);
                }
                catch (JSONException e) {
                    throw new GemfireRestException("Could not convert function results into Restful (JSON) format!", (Throwable)e);
                }
            }
            throw new GemfireRestException("Function has returned results that could not be converted into Restful (JSON) format!");
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException("Key is of an inappropriate type for this region!", (Throwable)cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException("Specified key is null and this region does not permit null keys!", (Throwable)npe);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has encountered low memory condition!", (Throwable)lme);
        }
        catch (IllegalArgumentException ie) {
            throw new GemfireRestException("Input parameter is null! ", (Throwable)ie);
        }
        catch (FunctionException fe) {
            throw new GemfireRestException("Server has encountered error while executing the function!", (Throwable)fe);
        }
    }
}

