/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.geode.rest.internal.web.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * The DateTimeUtils class is a utility class for working with dates and times.
 * <p/>
 * @see java.util.Calendar
 * @see java.text.DateFormat
 * @see java.util.Date
 * @since GemFire 8.0
 */
@SuppressWarnings("unused")
public abstract class DateTimeUtils {

  public static Calendar createCalendar(final int year, final int month, final int day) {
    final Calendar dateTime = Calendar.getInstance();
    dateTime.clear();
    dateTime.set(Calendar.YEAR, year);
    dateTime.set(Calendar.MONTH, month);
    dateTime.set(Calendar.DAY_OF_MONTH, day);
    return dateTime;
  }

  public static Date createDate(final int year, final int month, final int day) {
    return createCalendar(year, month, day).getTime();
  }

  public static String format(final Date dateTime, final String formatPattern) {
    return (dateTime != null ? new SimpleDateFormat(formatPattern).format(dateTime) : null);
  }

}

