/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.rest.internal.web.swagger.config;

import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.mangofactory.swagger.core.SwaggerPathProvider;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

public class RestApiPathProvider
implements SwaggerPathProvider {
    @Autowired
    private ServletContext servletContext;
    private final String docsLocation;
    private SwaggerPathProvider defaultPathProvider;

    public RestApiPathProvider(String docsLocation) {
        Assert.isTrue((!StringUtils.isBlank((String)docsLocation) ? 1 : 0) != 0, (String)"The docs location must be specified!");
        DistributionConfig config = InternalDistributedSystem.getAnyInstance().getConfig();
        String scheme = config.getHttpServiceSSLEnabled() ? "https" : "http";
        this.docsLocation = scheme + "://" + config.getHttpServiceBindAddress() + ":" + config.getHttpServicePort();
    }

    public String getApiResourcePrefix() {
        return this.defaultPathProvider.getApiResourcePrefix();
    }

    public String getAppBasePath() {
        return UriComponentsBuilder.fromHttpUrl((String)this.docsLocation).path(this.servletContext.getContextPath()).build().toString();
    }

    public String getSwaggerDocumentationBasePath() {
        return UriComponentsBuilder.fromHttpUrl((String)this.getAppBasePath()).pathSegment(new String[]{"api-docs/"}).build().toString();
    }

    public String getRequestMappingEndpoint(String requestMappingPattern) {
        return this.defaultPathProvider.getRequestMappingEndpoint(requestMappingPattern);
    }

    public void setDefaultPathProvider(SwaggerPathProvider defaultSwaggerPathProvider) {
        this.defaultPathProvider = defaultSwaggerPathProvider;
    }
}

