/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.rest.internal.web.controllers;

import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.rest.internal.web.controllers.AbstractBaseController;
import com.gemstone.gemfire.rest.internal.web.exception.DataTypeNotSupportedException;
import com.gemstone.gemfire.rest.internal.web.exception.GemfireRestException;
import com.gemstone.gemfire.rest.internal.web.exception.MalformedJsonException;
import com.gemstone.gemfire.rest.internal.web.exception.RegionNotFoundException;
import com.gemstone.gemfire.rest.internal.web.exception.ResourceNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class BaseControllerAdvice
extends AbstractBaseController {
    private static final Logger logger = LogService.getLogger();
    protected static final String REST_API_VERSION = "/v1";

    protected String getRestApiVersion() {
        return REST_API_VERSION;
    }

    @ExceptionHandler(value={RegionNotFoundException.class, ResourceNotFoundException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public String handle(RuntimeException e) {
        return this.convertErrorAsJson(e.getMessage());
    }

    @ExceptionHandler(value={MalformedJsonException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public String handleException(RuntimeException e) {
        return this.convertErrorAsJson(e.getMessage());
    }

    @ExceptionHandler(value={GemfireRestException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public String handleException(GemfireRestException ge) {
        return this.convertErrorAsJson((Throwable)ge);
    }

    @ExceptionHandler(value={DataTypeNotSupportedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public String handleException(DataTypeNotSupportedException tns) {
        return this.convertErrorAsJson(tns.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public String handleException(HttpRequestMethodNotSupportedException e) {
        return this.convertErrorAsJson(e.getMessage());
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public String handleException(Throwable cause) {
        StringWriter stackTraceWriter = new StringWriter();
        cause.printStackTrace(new PrintWriter(stackTraceWriter));
        String stackTrace = stackTraceWriter.toString();
        if (logger.isDebugEnabled()) {
            logger.debug(stackTrace);
        }
        return this.convertErrorAsJson(cause.getMessage());
    }
}

