/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.rest.internal.web.controllers;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.LeaseExpiredException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.pdx.JSONFormatter;
import com.gemstone.gemfire.pdx.JSONFormatterException;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.rest.internal.web.controllers.AbstractBaseController;
import com.gemstone.gemfire.rest.internal.web.controllers.support.JSONTypes;
import com.gemstone.gemfire.rest.internal.web.controllers.support.UpdateOp;
import com.gemstone.gemfire.rest.internal.web.exception.DataTypeNotSupportedException;
import com.gemstone.gemfire.rest.internal.web.exception.GemfireRestException;
import com.gemstone.gemfire.rest.internal.web.exception.MalformedJsonException;
import com.gemstone.gemfire.rest.internal.web.exception.RegionNotFoundException;
import com.gemstone.gemfire.rest.internal.web.exception.ResourceNotFoundException;
import com.gemstone.gemfire.rest.internal.web.util.ArrayUtils;
import com.gemstone.gemfire.rest.internal.web.util.IdentifiableUtils;
import com.gemstone.gemfire.rest.internal.web.util.JSONUtils;
import com.gemstone.gemfire.rest.internal.web.util.NumberUtils;
import com.gemstone.gemfire.rest.internal.web.util.ValidationUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public abstract class AbstractBaseController {
    private static final Logger logger = LogService.getLogger();
    protected static final String NEW_META_DATA_PROPERTY = "@new";
    protected static final String OLD_META_DATA_PROPERTY = "@old";
    protected static final String TYPE_META_DATA_PROPERTY = "@type";
    protected static final String UTF_8 = "UTF-8";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    private static final AtomicLong ID_SEQUENCE = new AtomicLong(0L);
    @Autowired
    private ObjectMapper objectMapper;

    @PostConstruct
    private void init() {
        JSONUtils.setObjectMapper((ObjectMapper)this.objectMapper);
    }

    protected Cache getCache() {
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting();
        Assert.state((cache != null ? 1 : 0) != 0, (String)"The Gemfire Cache reference was not properly initialized");
        return cache;
    }

    protected URI toUri(String ... pathSegments) {
        return ServletUriComponentsBuilder.fromCurrentContextPath().path(this.getRestApiVersion()).pathSegment(pathSegments).build().toUri();
    }

    protected abstract String getRestApiVersion();

    protected String validateQuery(String queryInUrl, String queryInBody) {
        if (!StringUtils.hasText((String)queryInUrl) && !StringUtils.hasText((String)queryInBody)) {
            throw new GemfireRestException("could not process null value specified in query String");
        }
        return StringUtils.hasText((String)queryInUrl) ? this.decode(queryInUrl) : queryInBody;
    }

    protected String decode(String value) {
        if (value == null) {
            throw new GemfireRestException("could not process null value specified in query String");
        }
        return this.decode(value, "UTF-8");
    }

    protected PdxInstance convert(String json) {
        try {
            return StringUtils.hasText((String)json) ? JSONFormatter.fromJSON((String)json) : null;
        }
        catch (JSONFormatterException jpe) {
            throw new MalformedJsonException("Json doc specified is either not supported or invalid!", jpe);
        }
    }

    protected String convert(PdxInstance pdxObj) {
        try {
            return pdxObj != null ? JSONFormatter.toJSON((PdxInstance)pdxObj) : null;
        }
        catch (JSONFormatterException jpe) {
            throw new GemfireRestException("Requested data could not convert into REST format(JSON)!", (Throwable)jpe);
        }
    }

    protected String convert(Iterable<PdxInstance> pdxObjs) {
        StringBuilder buffer = new StringBuilder("[");
        int count = 0;
        for (PdxInstance pdxObj : pdxObjs) {
            String json = this.convert(pdxObj);
            if (!StringUtils.hasText((String)json)) continue;
            buffer.append(count++ > 0 ? ", " : "").append(json);
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected <T> T casValue(String regionNamePath, String key, String jsonData) {
        try {
            JSONObject jsonObject = new JSONObject(jsonData);
            String oldValue = jsonObject.get(OLD_META_DATA_PROPERTY).toString();
            String newValue = jsonObject.get(NEW_META_DATA_PROPERTY).toString();
            return (T)this.casValue(regionNamePath, (Object)key, (Object)this.convert(oldValue), (Object)this.convert(newValue));
        }
        catch (JSONException je) {
            throw new MalformedJsonException("Json doc specified in request body is invalid!", (Throwable)je);
        }
    }

    public ResponseEntity<String> processQueryResponse(Object queryResult, String queryId) throws JSONException {
        if (queryResult instanceof Collection) {
            Collection result = (Collection)queryResult;
            String queryResultAsJson = JSONUtils.convertCollectionToJson((Collection)result);
            HttpHeaders headers = new HttpHeaders();
            headers.setLocation(this.toUri(new String[]{"queries", queryId}));
            return new ResponseEntity((Object)queryResultAsJson, (MultiValueMap)headers, HttpStatus.OK);
        }
        throw new GemfireRestException("Server has encountered error while generating query result into restful format(JSON)!");
    }

    protected Collection<PdxInstance> convertJsonArrayIntoPdxCollection(String jsonArray) {
        JSONArray jsonArr = null;
        try {
            jsonArr = new JSONArray(jsonArray);
            ArrayList<PdxInstance> pdxInstances = new ArrayList<PdxInstance>();
            for (int index = 0; index < jsonArr.length(); ++index) {
                Object object = jsonArr.get(index);
                String element = object.toString();
                PdxInstance pi = this.convert(element);
                pdxInstances.add(pi);
            }
            return pdxInstances;
        }
        catch (JSONException je) {
            throw new MalformedJsonException("Json document specified in request body is not valid!", (Throwable)je);
        }
    }

    protected Object casValue(String regionNamePath, Object key, Object oldValue, Object newValue) {
        Region region = this.getRegion(regionNamePath);
        try {
            return region.replace(key, oldValue, newValue) ? null : region.get(key);
        }
        catch (UnsupportedOperationException use) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not support the requested operation!", regionNamePath), (Throwable)use);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow to store specified key or value type in this region!", regionNamePath), (Throwable)cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow null keys or values!", regionNamePath), (Throwable)npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration prevents specified data from being stored in it!", regionNamePath), (Throwable)iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", (Throwable)lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", (Throwable)toe);
        }
        catch (CacheWriterException cwe) {
            throw new GemfireRestException("Server has encountered CacheWriter error while processing this request!", (Throwable)cwe);
        }
        catch (PartitionedRegionStorageException prse) {
            throw new GemfireRestException("Requested operation could not be completed on a partitioned region!", (Throwable)prse);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", (Throwable)lme);
        }
    }

    protected void replaceValue(String regionNamePath, Object key, PdxInstance value) {
        try {
            if (this.getRegion(regionNamePath).replace(key, (Object)value) == null) {
                throw new ResourceNotFoundException(String.format("No resource at (%1$s) exists!", this.toUri(new String[]{regionNamePath, String.valueOf(key)})));
            }
        }
        catch (UnsupportedOperationException use) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not support the requested operation!", regionNamePath), (Throwable)use);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow to store specified key or value type in this region!", regionNamePath), (Throwable)cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow null keys or values!", regionNamePath), (Throwable)npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration prevents specified data from being stored in it!", regionNamePath), (Throwable)iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", (Throwable)lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", (Throwable)toe);
        }
        catch (CacheWriterException cwe) {
            throw new GemfireRestException("Server has encountered CacheWriter error while processing this request!", (Throwable)cwe);
        }
        catch (PartitionedRegionStorageException prse) {
            throw new GemfireRestException("Requested operation could not be completed on a partitioned region!", (Throwable)prse);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", (Throwable)lme);
        }
    }

    protected void replaceValue(String regionNamePath, Object key, Object value) {
        try {
            if (this.getRegion(regionNamePath).replace(key, value) == null) {
                throw new ResourceNotFoundException(String.format("No resource at (%1$s) exists!", this.toUri(new String[]{regionNamePath, String.valueOf(key)})));
            }
        }
        catch (UnsupportedOperationException use) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not support the requested operation!", regionNamePath), (Throwable)use);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow to store specified key or value type in this region!", regionNamePath), (Throwable)cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow null keys or values!", regionNamePath), (Throwable)npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration prevents specified data from being stored in it!", regionNamePath), (Throwable)iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", (Throwable)lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", (Throwable)toe);
        }
        catch (CacheWriterException cwe) {
            throw new GemfireRestException("Server has encountered CacheWriter error while processing this request!", (Throwable)cwe);
        }
        catch (PartitionedRegionStorageException prse) {
            throw new GemfireRestException("Requested operation could not be completed on a partitioned region!", (Throwable)prse);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", (Throwable)lme);
        }
    }

    protected void putValue(String regionNamePath, Object key, Object value) {
        try {
            this.getRegion(regionNamePath).put(key, value);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow null keys or values!", regionNamePath), (Throwable)npe);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow to store specified key or value type in this region!", regionNamePath), (Throwable)cce);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", (Throwable)lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", (Throwable)toe);
        }
        catch (CacheWriterException cwe) {
            throw new GemfireRestException("Server has encountered CacheWriter error while processing this request!", (Throwable)cwe);
        }
        catch (PartitionedRegionStorageException prse) {
            throw new GemfireRestException("Requested operation could not be completed on a partitioned region!", (Throwable)prse);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", (Throwable)lme);
        }
    }

    protected void deleteQueryId(String regionNamePath, String key) {
        this.getQueryStore(regionNamePath).remove((Object)key);
    }

    protected void deleteNamedQuery(String regionNamePath, String key) {
        this.checkForQueryIdExist(regionNamePath, key);
        this.deleteQueryId(regionNamePath, key);
    }

    protected void checkForQueryIdExist(String region, String key) {
        if (!this.getQueryStore(region).containsKey((Object)key)) {
            throw new ResourceNotFoundException(String.format("Named query (%1$s) does not exist!", key));
        }
    }

    protected Region<String, String> getQueryStore(String namePath) {
        return (Region)ValidationUtils.returnValueThrowOnNull((Object)this.getCache().getRegion(namePath), (RuntimeException)new GemfireRestException(String.format("Query store does not exist!", namePath)));
    }

    protected String getQueryIdValue(String regionNamePath, String key) {
        Assert.notNull((Object)key, (String)"queryId cannot be null!");
        try {
            return (String)this.getQueryStore(regionNamePath).get((Object)key);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException("NULL query ID or query string is not supported!", (Throwable)npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException("Server has not allowed to perform the requested operation!", (Throwable)iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", (Throwable)lee);
        }
        catch (TimeoutException te) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", (Throwable)te);
        }
    }

    protected void updateNamedQuery(String regionNamePath, String key, String value) {
        try {
            this.getQueryStore(regionNamePath).put((Object)key, (Object)value);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException("NULL query ID or query string is not supported!", (Throwable)npe);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException("specified queryId or query string is not supported!", (Throwable)cce);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", (Throwable)lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", (Throwable)toe);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", (Throwable)lme);
        }
    }

    protected <T> T createNamedQuery(String regionNamePath, String key, String value) {
        try {
            return (T)this.getQueryStore(regionNamePath).putIfAbsent((Object)key, (Object)value);
        }
        catch (UnsupportedOperationException use) {
            throw new GemfireRestException("Requested operation is not supported!", (Throwable)use);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException("Specified queryId or query string is not supported!", (Throwable)cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException("NULL query ID or query string is not supported!", (Throwable)npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException("Configuration does not allow to perform the requested operation!", (Throwable)iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", (Throwable)lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", (Throwable)toe);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", (Throwable)lme);
        }
    }

    protected void putPdxValues(String regionNamePath, Map<Object, PdxInstance> map) {
        try {
            this.getRegion(regionNamePath).putAll(map);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("low memory condition is detected.", (Throwable)lme);
        }
    }

    protected void putValues(String regionNamePath, Map<Object, Object> values) {
        this.getRegion(regionNamePath).putAll(values);
    }

    protected void putValues(String regionNamePath, String[] keys, List<?> values) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (keys.length != values.size()) {
            throw new GemfireRestException("Bad request, Keys and Value size does not match");
        }
        for (int i = 0; i < keys.length; ++i) {
            Object domainObj = this.introspectAndConvert(values.get(i));
            map.put(keys[i], domainObj);
        }
        if (!map.isEmpty()) {
            this.putValues(regionNamePath, map);
        }
    }

    protected <T> T postValue(String regionNamePath, Object key, Object value) {
        try {
            return (T)this.getRegion(regionNamePath).putIfAbsent(key, value);
        }
        catch (UnsupportedOperationException use) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not support the requested operation!", regionNamePath), (Throwable)use);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow to store specified key or value type in this region!", regionNamePath), (Throwable)cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow null keys or values!", regionNamePath), (Throwable)npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration prevents specified data from being stored in it!", regionNamePath), (Throwable)iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", (Throwable)lee);
        }
        catch (TimeoutException toe) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", (Throwable)toe);
        }
        catch (CacheWriterException cwe) {
            throw new GemfireRestException("Server has encountered CacheWriter error while processing this request!", (Throwable)cwe);
        }
        catch (PartitionedRegionStorageException prse) {
            throw new GemfireRestException("Requested operation could not be completed on a partitioned region!", (Throwable)prse);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has detected low memory while processing this request!", (Throwable)lme);
        }
    }

    protected Object getActualTypeValue(String value, String valueType) {
        Object actualValue = value;
        if (valueType != null) {
            try {
                actualValue = NumberUtils.convertToActualType((String)value, (String)valueType);
            }
            catch (IllegalArgumentException ie) {
                throw new GemfireRestException(ie.getMessage(), (Throwable)ie);
            }
        }
        return actualValue;
    }

    protected String generateKey(String existingKey) {
        return this.generateKey(existingKey, null);
    }

    protected String generateKey(String existingKey, Object domainObject) {
        String newKey;
        Object domainObjectId = IdentifiableUtils.getId((Object)domainObject);
        if (StringUtils.hasText((String)existingKey)) {
            Long newId;
            newKey = existingKey;
            if (NumberUtils.isNumeric((String)newKey) && domainObjectId == null && newKey.equals((newId = IdentifiableUtils.createId((Long)NumberUtils.parseLong((String)newKey))).toString())) {
                IdentifiableUtils.setId((Object)domainObject, (Object)newId);
            }
        } else if (domainObjectId != null) {
            Long domainObjectIdAsLong = NumberUtils.longValue((Object)domainObjectId);
            if (domainObjectIdAsLong != null) {
                Long newId = IdentifiableUtils.createId((Long)domainObjectIdAsLong);
                if (!domainObjectIdAsLong.equals(newId)) {
                    IdentifiableUtils.setId((Object)domainObject, (Object)newId);
                }
                newKey = String.valueOf(newId);
            } else {
                newKey = String.valueOf(domainObjectId);
            }
        } else {
            domainObjectId = IdentifiableUtils.createId();
            newKey = String.valueOf(domainObjectId);
            IdentifiableUtils.setId((Object)domainObject, (Object)domainObjectId);
        }
        return newKey;
    }

    protected String decode(String value, String encoding) {
        try {
            return URLDecoder.decode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new GemfireRestException("Server has encountered unsupported encoding!");
        }
    }

    protected <T> Region<Object, T> getRegion(String namePath) {
        return (Region)ValidationUtils.returnValueThrowOnNull((Object)this.getCache().getRegion(namePath), (RuntimeException)new RegionNotFoundException(String.format("The Region identified by name (%1$s) could not be found!", namePath)));
    }

    protected void checkForKeyExist(String region, String key) {
        if (!this.getRegion(region).containsKey((Object)key)) {
            throw new ResourceNotFoundException(String.format("Key (%1$s) does not exist for region (%2$s) in cache!", key, region));
        }
    }

    protected List<String> checkForMultipleKeysExist(String region, String ... keys) {
        ArrayList<String> unknownKeys = new ArrayList<String>();
        for (int index = 0; index < keys.length; ++index) {
            if (this.getRegion(region).containsKey((Object)keys[index])) continue;
            unknownKeys.add(keys[index]);
        }
        return unknownKeys;
    }

    protected Object[] getKeys(String regionNamePath, Object[] keys) {
        return keys != null && keys.length != 0 ? keys : this.getRegion(regionNamePath).keySet().toArray();
    }

    protected <T> Map<Object, T> getValues(String regionNamePath, Object ... keys) {
        try {
            Region region = this.getRegion(regionNamePath);
            Map entries = region.getAll(Arrays.asList(this.getKeys(regionNamePath, keys)));
            return entries;
        }
        catch (SerializationException se) {
            throw new DataTypeNotSupportedException("The resource identified could not convert into the supported content characteristics (JSON)!", (Throwable)se);
        }
    }

    protected <T> Map<Object, T> getValues(String regionNamePath, String ... keys) {
        return this.getValues(regionNamePath, (Object[])keys);
    }

    protected <T extends PdxInstance> Collection<T> getPdxValues(String regionNamePath, Object ... keys) {
        Region region = this.getRegion(regionNamePath);
        Map entries = region.getAll(Arrays.asList(this.getKeys(regionNamePath, keys)));
        return entries.values();
    }

    protected void deleteValue(String regionNamePath, Object key) {
        this.getRegion(regionNamePath).remove(key);
    }

    protected void deleteValues(String regionNamePath, Object ... keys) {
        for (Object key : keys) {
            this.checkForKeyExist(regionNamePath, key.toString());
        }
        for (Object key : keys) {
            this.deleteValue(regionNamePath, key);
        }
    }

    protected void deleteValues(String regionNamePath) {
        try {
            this.getRegion(regionNamePath).clear();
        }
        catch (UnsupportedOperationException ue) {
            throw new GemfireRestException("Requested operation not allowed on partition region", (Throwable)ue);
        }
    }

    private boolean isForm(Map<Object, Object> rawDataBinding) {
        return !rawDataBinding.containsKey(TYPE_META_DATA_PROPERTY) && rawDataBinding.containsKey(OLD_META_DATA_PROPERTY) && rawDataBinding.containsKey(NEW_META_DATA_PROPERTY);
    }

    protected <T> T introspectAndConvert(T value) {
        if (value instanceof Map) {
            Map rawDataBinding = (Map)value;
            if (this.isForm(rawDataBinding)) {
                rawDataBinding.put(OLD_META_DATA_PROPERTY, this.introspectAndConvert(rawDataBinding.get(OLD_META_DATA_PROPERTY)));
                rawDataBinding.put(NEW_META_DATA_PROPERTY, this.introspectAndConvert(rawDataBinding.get(NEW_META_DATA_PROPERTY)));
                return (T)rawDataBinding;
            }
            String typeValue = (String)rawDataBinding.get(TYPE_META_DATA_PROPERTY);
            if (NumberUtils.isPrimitiveOrObject((String)typeValue.toString())) {
                Object primitiveValue = rawDataBinding.get("@value");
                try {
                    return (T)NumberUtils.convertToActualType((String)primitiveValue.toString(), (String)typeValue);
                }
                catch (IllegalArgumentException e) {
                    throw new GemfireRestException("Server has encountered error (illegal or inappropriate arguments).", (Throwable)e);
                }
            }
            Assert.state((typeValue != null ? 1 : 0) != 0, (String)"The class type of the object to persist in GemFire must be specified in JSON content using the '@type' property!");
            Assert.state((boolean)ClassUtils.isPresent((String)String.valueOf(typeValue), (ClassLoader)Thread.currentThread().getContextClassLoader()), (String)String.format("Class (%1$s) could not be found!", typeValue));
            return (T)this.objectMapper.convertValue((Object)rawDataBinding, ClassUtils.resolveClassName((String)String.valueOf(typeValue), (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        return value;
    }

    protected String convertErrorAsJson(String errorMessage) {
        return "{\"cause\":\"" + errorMessage + "\"" + "}";
    }

    protected String convertErrorAsJson(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return String.format("{\"message\" : \"%1$s\", \"stackTrace\" : \"%2$s\"}", t.getMessage(), writer.toString());
    }

    protected Map<?, ?> convertJsonToMap(String jsonString) {
        Map map = new HashMap();
        try {
            map = (Map)this.objectMapper.readValue(jsonString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (JsonParseException e) {
            throw new MalformedJsonException("Bind params specified as JSON document in the request is incorrect!", (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new MalformedJsonException("Server unable to process bind params specified as JSON document in the request!", (Throwable)e);
        }
        catch (IOException e) {
            throw new GemfireRestException("Server has encountered error while process this request!", (Throwable)e);
        }
        return map;
    }

    protected Object jsonToObject(String jsonString) {
        return this.introspectAndConvert((Object)this.convertJsonToMap(jsonString));
    }

    protected Object[] jsonToObjectArray(String arguments) {
        JSONTypes jsonType = this.validateJsonAndFindType(arguments);
        if (JSONTypes.JSON_ARRAY.equals((Object)jsonType)) {
            try {
                JSONArray jsonArray = new JSONArray(arguments);
                Object[] args = new Object[jsonArray.length()];
                for (int index = 0; index < jsonArray.length(); ++index) {
                    args[index] = this.jsonToObject(jsonArray.get(index).toString());
                }
                return args;
            }
            catch (JSONException je) {
                throw new MalformedJsonException("Json document specified in request body is not valid!", (Throwable)je);
            }
        }
        if (JSONTypes.JSON_OBJECT.equals((Object)jsonType)) {
            return new Object[]{this.jsonToObject(arguments)};
        }
        throw new MalformedJsonException("Json document specified in request body is not valid!");
    }

    public ResponseEntity<String> updateSingleKey(String region, String key, String json, String opValue) {
        JSONTypes jsonType = this.validateJsonAndFindType(json);
        UpdateOp op = UpdateOp.valueOf((String)opValue.toUpperCase());
        String existingValue = null;
        switch (2.$SwitchMap$com$gemstone$gemfire$rest$internal$web$controllers$support$UpdateOp[op.ordinal()]) {
            case 1: {
                PdxInstance existingPdxObj = (PdxInstance)this.casValue(region, key, json);
                existingValue = this.convert(existingPdxObj);
                break;
            }
            case 2: {
                this.replaceValue(region, (Object)key, this.convert(json));
                break;
            }
            default: {
                if (JSONTypes.JSON_ARRAY.equals((Object)jsonType)) {
                    this.putValue(region, (Object)key, (Object)this.convertJsonArrayIntoPdxCollection(json));
                    break;
                }
                this.putValue(region, (Object)key, (Object)this.convert(json));
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri(new String[]{region, key}));
        return new ResponseEntity((Object)existingValue, (MultiValueMap)headers, existingValue == null ? HttpStatus.OK : HttpStatus.CONFLICT);
    }

    public ResponseEntity<String> updateMultipleKeys(String region, String[] keys, String json) {
        JSONArray jsonArr = null;
        try {
            jsonArr = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new MalformedJsonException("JSON document specified in the request is incorrect", (Throwable)e);
        }
        if (jsonArr.length() != keys.length) {
            throw new MalformedJsonException("Each key must have corresponding value (JSON document) specified in the request");
        }
        HashMap<String, PdxInstance> map = new HashMap<String, PdxInstance>();
        for (int i = 0; i < keys.length; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug("Updating (put) Json document ({}) having key ({}) in Region ({})", new Object[]{json, keys[i], region});
            }
            try {
                PdxInstance pdxObj = this.convert(jsonArr.getJSONObject(i).toString());
                map.put(keys[i], pdxObj);
                continue;
            }
            catch (JSONException e) {
                throw new MalformedJsonException(String.format("JSON document at index (%1$s) in the request body is incorrect", i), (Throwable)e);
            }
        }
        if (!CollectionUtils.isEmpty(map)) {
            this.putPdxValues(region, map);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri(new String[]{region, StringUtils.arrayToCommaDelimitedString((Object[])keys)}));
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }

    public JSONTypes validateJsonAndFindType(String json) {
        try {
            Object jsonObj = new JSONTokener(json).nextValue();
            if (jsonObj instanceof JSONObject) {
                return JSONTypes.JSON_OBJECT;
            }
            if (jsonObj instanceof JSONArray) {
                return JSONTypes.JSON_ARRAY;
            }
            return JSONTypes.UNRECOGNIZED_JSON;
        }
        catch (JSONException je) {
            throw new MalformedJsonException("JSON document specified in the request is incorrect", (Throwable)je);
        }
    }

    protected QueryService getQueryService() {
        return this.getCache().getQueryService();
    }

    protected <T> T getValue(String regionNamePath, Object key) {
        Assert.notNull((Object)key, (String)"The Cache Region key to read the value for cannot be null!");
        Region r = this.getRegion(regionNamePath);
        try {
            Object value = r.get(key);
            return (T)value;
        }
        catch (SerializationException se) {
            throw new DataTypeNotSupportedException("The resource identified could not convert into the supported content characteristics (JSON)!", (Throwable)se);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow null keys!", regionNamePath), (Throwable)npe);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException(String.format("Resource (%1$s) configuration does not allow requested operation on specified key!", regionNamePath), (Throwable)iae);
        }
        catch (LeaseExpiredException lee) {
            throw new GemfireRestException("Server has encountered error while processing this request!", (Throwable)lee);
        }
        catch (TimeoutException te) {
            throw new GemfireRestException("Server has encountered timeout error while processing this request!", (Throwable)te);
        }
        catch (CacheLoaderException cle) {
            throw new GemfireRestException("Server has encountered CacheLoader error while processing this request!", (Throwable)cle);
        }
        catch (PartitionedRegionStorageException prse) {
            throw new GemfireRestException("CacheLoader could not be invoked on partitioned region!", (Throwable)prse);
        }
    }

    protected Set<DistributedMember> getMembers(String ... memberIdNames) {
        ValidationUtils.returnValueThrowOnNull((Object)memberIdNames, (RuntimeException)new GemfireRestException("No member found to run function"));
        HashSet<DistributedMember> targetedMembers = new HashSet<DistributedMember>(ArrayUtils.length((Object[])memberIdNames));
        List<String> memberIdNameList = Arrays.asList(memberIdNames);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Set distMembers = c.getDistributedSystem().getAllOtherMembers();
        distMembers.add(c.getDistributedSystem().getDistributedMember());
        for (DistributedMember member : distMembers) {
            if (!memberIdNameList.contains(member.getId()) && !memberIdNameList.contains(member.getName())) continue;
            targetedMembers.add(member);
        }
        return targetedMembers;
    }

    protected Set<DistributedMember> getAllMembersInDS() {
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Set distMembers = c.getDistributedSystem().getAllOtherMembers();
        HashSet<DistributedMember> targetedMembers = new HashSet<DistributedMember>();
        for (DistributedMember member : distMembers) {
            InternalDistributedMember idm = (InternalDistributedMember)member;
            if (idm.getVmKind() != 10) continue;
            targetedMembers.add(member);
        }
        targetedMembers.add((DistributedMember)c.getDistributedSystem().getDistributedMember());
        return targetedMembers;
    }
}

