/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.modules.session.catalina.ClientServerSessionCache;
import org.apache.geode.modules.session.catalina.CommitSessionValve;
import org.apache.geode.modules.session.catalina.DeltaSession;
import org.apache.geode.modules.session.catalina.DeltaSessionInterface;
import org.apache.geode.modules.session.catalina.JvmRouteBinderValve;
import org.apache.geode.modules.session.catalina.PeerToPeerSessionCache;
import org.apache.geode.modules.session.catalina.SessionCache;
import org.apache.geode.modules.session.catalina.SessionManager;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionStatistics;
import org.apache.geode.modules.util.ContextMapper;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class DeltaSessionManager
extends ManagerBase
implements Lifecycle,
PropertyChangeListener,
SessionManager {
    private AtomicInteger rejectedSessions;
    protected int maxActiveSessions = -1;
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected String name;
    protected Valve jvmRouteBinderValve;
    protected Valve commitSessionValve;
    protected SessionCache sessionCache;
    protected static final String DEFAULT_REGION_NAME = "gemfire_modules_sessions";
    protected static final boolean DEFAULT_ENABLE_GATEWAY_DELTA_REPLICATION = false;
    protected static final boolean DEFAULT_ENABLE_GATEWAY_REPLICATION = false;
    protected static final boolean DEFAULT_ENABLE_DEBUG_LISTENER = false;
    protected static final boolean DEFAULT_ENABLE_COMMIT_VALVE = true;
    protected static final boolean DEFAULT_ENABLE_COMMIT_VALVE_FAILFAST = false;
    protected static final boolean DEFAULT_PREFER_DESERIALIZED_FORM = true;
    protected Log LOGGER;
    protected String regionName = "gemfire_modules_sessions";
    protected String regionAttributesId;
    protected Boolean enableLocalCache;
    protected boolean enableCommitValve = true;
    protected boolean enableCommitValveFailfast = false;
    protected boolean enableGatewayDeltaReplication = false;
    protected boolean enableGatewayReplication = false;
    protected boolean enableDebugListener = false;
    protected boolean preferDeserializedForm = true;
    private Timer timer;
    private final Set<String> sessionsToTouch = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final long TIMER_TASK_PERIOD = Long.getLong("gemfiremodules.sessionTimerTaskPeriod", 10000L);
    private static final long TIMER_TASK_DELAY = Long.getLong("gemfiremodules.sessionTimerTaskDelay", 10000L);

    @Override
    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setMaxInactiveInterval(int interval) {
        super.setMaxInactiveInterval(interval);
    }

    @Override
    public String getRegionAttributesId() {
        if (this.regionAttributesId == null) {
            this.regionAttributesId = this.getSessionCache().getDefaultRegionAttributesId();
        }
        return this.regionAttributesId;
    }

    public void setRegionAttributesId(String regionType) {
        this.regionAttributesId = regionType;
    }

    @Override
    public boolean getEnableLocalCache() {
        if (this.enableLocalCache == null) {
            this.enableLocalCache = this.getSessionCache().getDefaultEnableLocalCache();
        }
        return this.enableLocalCache;
    }

    public void setEnableLocalCache(boolean enableLocalCache) {
        this.enableLocalCache = enableLocalCache;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(int maxActiveSessions) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = maxActiveSessions;
        this.support.firePropertyChange("maxActiveSessions", new Integer(oldMaxActiveSessions), new Integer(this.maxActiveSessions));
    }

    @Override
    public boolean getEnableGatewayDeltaReplication() {
        return false;
    }

    public void setEnableGatewayDeltaReplication(boolean enableGatewayDeltaReplication) {
        this.enableGatewayDeltaReplication = enableGatewayDeltaReplication;
    }

    @Override
    public boolean getEnableGatewayReplication() {
        return this.enableGatewayReplication;
    }

    public void setEnableGatewayReplication(boolean enableGatewayReplication) {
        this.enableGatewayReplication = enableGatewayReplication;
    }

    @Override
    public boolean getEnableDebugListener() {
        return this.enableDebugListener;
    }

    public void setEnableDebugListener(boolean enableDebugListener) {
        this.enableDebugListener = enableDebugListener;
    }

    @Override
    public boolean isCommitValveEnabled() {
        return this.enableCommitValve;
    }

    public void setEnableCommitValve(boolean enable) {
        this.enableCommitValve = enable;
    }

    @Override
    public boolean isCommitValveFailfastEnabled() {
        return this.enableCommitValveFailfast;
    }

    public void setEnableCommitValveFailfast(boolean enable) {
        this.enableCommitValveFailfast = enable;
    }

    @Override
    public boolean isBackingCacheAvailable() {
        return this.sessionCache.isBackingCacheAvailable();
    }

    public void setPreferDeserializedForm(boolean enable) {
        this.preferDeserializedForm = enable;
    }

    @Override
    public boolean getPreferDeserializedForm() {
        return this.preferDeserializedForm;
    }

    @Override
    public String getStatisticsName() {
        return this.getContextName().replace("/", "");
    }

    @Override
    public Log getLogger() {
        if (this.LOGGER == null) {
            this.LOGGER = LogFactory.getLog(DeltaSessionManager.class);
        }
        return this.LOGGER;
    }

    public SessionCache getSessionCache() {
        return this.sessionCache;
    }

    public DeltaSessionStatistics getStatistics() {
        return this.getSessionCache().getStatistics();
    }

    public boolean isPeerToPeer() {
        return this.getSessionCache().isPeerToPeer();
    }

    public boolean isClientServer() {
        return this.getSessionCache().isClientServer();
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public Session findSession(String id) throws IOException {
        DeltaSessionInterface session;
        if (id == null) {
            return null;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + ": Finding session " + id + " in " + this.getSessionCache().getOperatingRegionName()));
        }
        if ((session = (DeltaSessionInterface)this.getSessionCache().getSession(id)) != null && !session.getContextName().isEmpty() && !this.getContextName().equals(session.getContextName())) {
            this.getLogger().info((Object)(this + ": Session " + id + " rejected as container name and context do not match: " + this.getContextName() + " != " + session.getContextName()));
            session = null;
        }
        if (session == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + ": Did not find session " + id + " in " + this.getSessionCache().getOperatingRegionName()));
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + ": Found session " + id + " in " + this.getSessionCache().getOperatingRegionName() + ": " + session));
            }
            session.setNew(false);
            if (session.getManager() == null) {
                DeltaSessionInterface ds = session;
                ds.setOwner(this);
                ds.activate();
            }
        }
        return session;
    }

    protected void initializeSessionCache() {
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
        if (cache == null) {
            throw new IllegalStateException("No cache exists. Please configure either a PeerToPeerCacheLifecycleListener or ClientServerCacheLifecycleListener in the server.xml file.");
        }
        this.sessionCache = cache.isClient() ? new ClientServerSessionCache(this, (ClientCache)cache) : new PeerToPeerSessionCache(this, (Cache)cache);
        this.sessionCache.initialize();
    }

    protected StandardSession getNewSession() {
        return new DeltaSession((Manager)this);
    }

    public void remove(Session session) {
        this.remove(session, false);
    }

    public void remove(Session session, boolean update) {
        DeltaSessionInterface ds = (DeltaSessionInterface)session;
        if (ds.getExpired()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + ": Expired session " + session.getId() + " from " + this.getSessionCache().getOperatingRegionName()));
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + ": Destroying session " + session.getId() + " from " + this.getSessionCache().getOperatingRegionName()));
            }
            this.getSessionCache().destroySession(session.getId());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + ": Destroyed session " + session.getId() + " from " + this.getSessionCache().getOperatingRegionName()));
            }
        }
    }

    public void add(Session session) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + ": Storing session " + session.getId() + " into " + this.getSessionCache().getOperatingRegionName()));
        }
        this.getSessionCache().putSession(session);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + ": Stored session " + session.getId() + " into " + this.getSessionCache().getOperatingRegionName()));
        }
        this.getSessionCache().getStatistics().incSessionsCreated();
    }

    public int getRejectedSessions() {
        return this.rejectedSessions.get();
    }

    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedSessions.set(rejectedSessions);
    }

    private void incrementRejectedSessions() {
        this.rejectedSessions.incrementAndGet();
    }

    public int getActiveSessions() {
        return this.getSessionCache().size();
    }

    public String listSessionIds() {
        StringBuilder builder = new StringBuilder();
        Iterator<String> sessionIds = this.getSessionCache().keySet().iterator();
        while (sessionIds.hasNext()) {
            builder.append(sessionIds.next());
            if (!sessionIds.hasNext()) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    protected void addSessionToTouch(String sessionId) {
        this.sessionsToTouch.add(sessionId);
    }

    protected Set<String> getSessionsToTouch() {
        return this.sessionsToTouch;
    }

    protected boolean removeTouchedSession(String sessionId) {
        return this.sessionsToTouch.remove(sessionId);
    }

    protected void scheduleTimerTasks() {
        this.timer = new Timer("Timer for " + this.toString(), true);
        this.scheduleTouchSessionsTask();
        this.scheduleDetermineMaxActiveSessionsTask();
    }

    private void scheduleTouchSessionsTask() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                HashSet<String> sessionIds = null;
                sessionIds = new HashSet<String>(DeltaSessionManager.this.getSessionsToTouch());
                DeltaSessionManager.this.getSessionsToTouch().clear();
                if (sessionIds != null && !sessionIds.isEmpty()) {
                    DeltaSessionManager.this.getSessionCache().touchSessions(sessionIds);
                    if (DeltaSessionManager.this.getLogger().isDebugEnabled()) {
                        DeltaSessionManager.this.getLogger().debug((Object)(DeltaSessionManager.this + ": Touched sessions: " + sessionIds));
                    }
                }
            }
        };
        this.timer.schedule(task, TIMER_TASK_DELAY, TIMER_TASK_PERIOD);
    }

    protected void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void scheduleDetermineMaxActiveSessionsTask() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                int currentActiveSessions = DeltaSessionManager.this.getSessionCache().size();
                if (currentActiveSessions > DeltaSessionManager.this.getMaxActive()) {
                    DeltaSessionManager.this.setMaxActive(currentActiveSessions);
                    if (DeltaSessionManager.this.getLogger().isDebugEnabled()) {
                        DeltaSessionManager.this.getLogger().debug((Object)(DeltaSessionManager.this + ": Set max active sessions: " + currentActiveSessions));
                    }
                }
            }
        };
        this.timer.schedule(task, TIMER_TASK_DELAY, TIMER_TASK_PERIOD);
    }

    public void load() throws ClassNotFoundException, IOException {
        this.doLoad();
        ContextMapper.addContext(this.getContextName(), this);
    }

    public void unload() throws IOException {
        this.doUnload();
        ContextMapper.removeContext(this.getContextName());
    }

    protected void registerJvmRouteBinderValve() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + ": Registering JVM route binder valve"));
        }
        this.jvmRouteBinderValve = new JvmRouteBinderValve();
        this.getPipeline().addValve(this.jvmRouteBinderValve);
    }

    protected Pipeline getPipeline() {
        return this.getContainer().getPipeline();
    }

    protected void unregisterJvmRouteBinderValve() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + ": Unregistering JVM route binder valve"));
        }
        if (this.jvmRouteBinderValve != null) {
            this.getPipeline().removeValve(this.jvmRouteBinderValve);
        }
    }

    protected void registerCommitSessionValve() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + ": Registering CommitSessionValve"));
        }
        this.commitSessionValve = new CommitSessionValve();
        this.getPipeline().addValve(this.commitSessionValve);
    }

    protected void unregisterCommitSessionValve() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + ": Unregistering CommitSessionValve"));
        }
        if (this.commitSessionValve != null) {
            this.getPipeline().removeValve(this.commitSessionValve);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        Context context = (Context)event.getSource();
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                int interval = (Integer)event.getNewValue();
                if (interval < -1) {
                    this.getLogger().warn((Object)("The configured session timeout of " + interval + " minutes is invalid. Using the original value of " + event.getOldValue() + " minutes."));
                    interval = (Integer)event.getOldValue();
                }
                this.setMaxInactiveInterval(interval == -1 ? -1 : interval * 60);
            }
            catch (NumberFormatException e) {
                this.getLogger().error((Object)sm.getString("standardManager.sessionTimeout", (Object)event.getNewValue().toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnload() throws IOException {
        SelectResults results;
        QueryService querySvc = this.sessionCache.getCache().getQueryService();
        Context context = this.getTheContext();
        if (context == null) {
            return;
        }
        String regionName = this.getRegionName().startsWith("/") ? this.getRegionName() : "/" + this.getRegionName();
        Query query = querySvc.newQuery("select s.id from " + regionName + " as s where s.contextName = '" + context.getPath() + "'");
        this.getLogger().debug((Object)("Query: " + query.getQueryString()));
        try {
            results = (SelectResults)query.execute();
        }
        catch (Exception ex) {
            this.getLogger().error((Object)"Unable to perform query during doUnload", (Throwable)ex);
            return;
        }
        if (results.isEmpty()) {
            this.getLogger().debug((Object)("No sessions to unload for context " + context.getPath()));
            return;
        }
        File store = this.sessionStore(context.getPath());
        if (store == null) {
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Unloading sessions to " + store.getAbsolutePath()));
        }
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        ObjectOutputStream oos = null;
        boolean error = false;
        try {
            fos = new FileOutputStream(store.getAbsolutePath());
            bos = new BufferedOutputStream(fos);
            oos = new ObjectOutputStream(bos);
        }
        catch (IOException e) {
            error = true;
            this.getLogger().error((Object)"Exception unloading sessions", (Throwable)e);
            throw e;
        }
        finally {
            if (error) {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        ArrayList<DeltaSessionInterface> list = new ArrayList<DeltaSessionInterface>();
        for (Object id : results) {
            DeltaSessionInterface session = (DeltaSessionInterface)this.findSession((String)id);
            if (session == null) continue;
            list.add(session);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Unloading " + list.size() + " sessions"));
        }
        try {
            oos.writeObject(new Integer(list.size()));
            for (DeltaSessionInterface session : list) {
                if (session instanceof StandardSession) {
                    StandardSession standardSession = (StandardSession)session;
                    standardSession.passivate();
                    standardSession.writeObjectData(oos);
                    continue;
                }
                throw new IOException("Session should be of type StandardSession");
            }
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Exception unloading sessions", (Throwable)e);
            try {
                oos.close();
            }
            catch (IOException session) {
                // empty catch block
            }
            throw e;
        }
        try {
            oos.flush();
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException iOException) {}
        }
        if (this.getSessionCache().isClientServer()) {
            for (DeltaSessionInterface session : list) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Locally destroying session " + session.getId()));
                }
                this.getSessionCache().getOperatingRegion().localDestroy((Object)session.getId());
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Unloading complete");
        }
    }

    protected void doLoad() throws ClassNotFoundException, IOException {
        Context context = this.getTheContext();
        if (context == null) {
            return;
        }
        File store = this.sessionStore(context.getPath());
        if (store == null) {
            this.getLogger().debug((Object)"No session store file found");
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Loading sessions from " + store.getAbsolutePath()));
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        try {
            fis = new FileInputStream(store.getAbsolutePath());
            bis = new BufferedInputStream(fis);
            if (this.getTheContext() != null) {
                loader = this.getTheContext().getLoader();
            }
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Creating custom object input stream for class loader");
                }
                ois = new CustomObjectInputStream((InputStream)bis, classLoader);
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Creating standard object input stream");
                }
                ois = new ObjectInputStream(bis);
            }
        }
        catch (FileNotFoundException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"No persisted data file found");
            }
            return;
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Exception loading sessions", (Throwable)e);
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            Integer count = (Integer)ois.readObject();
            int n = count;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Loading " + n + " persisted sessions"));
            }
            for (int i = 0; i < n; ++i) {
                StandardSession session = this.getNewSession();
                session.readObjectData(ois);
                session.setManager((Manager)this);
                Region<String, HttpSession> region = this.getSessionCache().getOperatingRegion();
                DeltaSessionInterface existingSession = (DeltaSessionInterface)region.get((Object)session.getId());
                if (existingSession != null && existingSession.getLastAccessedTime() > session.getLastAccessedTime()) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug((Object)("Loaded session " + session.getId() + " is older than cached copy"));
                    continue;
                }
                if (!session.isValid()) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug((Object)("Loaded session " + session.getId() + " is invalid"));
                    continue;
                }
                this.getLogger().debug((Object)("Loading session " + session.getId()));
                session.activate();
                this.add((Session)session);
            }
        }
        catch (ClassNotFoundException e) {
            this.getLogger().error((Object)e);
            try {
                ois.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        catch (IOException e) {
            this.getLogger().error((Object)e);
            try {
                ois.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        finally {
            try {
                ois.close();
            }
            catch (IOException iOException) {}
            if (store.exists()) {
                store.delete();
            }
        }
    }

    private File sessionStore(String ctxPath) {
        String storeDir = System.getProperty("catalina.base");
        storeDir = storeDir == null || storeDir.isEmpty() ? System.getProperty("java.io.tmpdir") : storeDir + System.getProperty("file.separator") + "temp";
        File file = new File(storeDir, ctxPath.replaceAll("/", "_") + ".sessions.ser");
        return file;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "container=" + this.getTheContext() + "; regionName=" + this.regionName + "; regionAttributesId=" + this.regionAttributesId + "]";
    }

    protected String getContextName() {
        return this.getTheContext().getName();
    }

    public Context getTheContext() {
        if (this.getContainer() instanceof Context) {
            return (Context)this.getContainer();
        }
        this.getLogger().error((Object)("Unable to unload sessions - container is of type " + this.getContainer().getClass().getName() + " instead of StandardContext"));
        return null;
    }
}

