/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.gatewaydelta;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.Instantiator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.modules.gatewaydelta.AbstractGatewayDeltaEvent;

public class GatewayDeltaDestroyEvent
extends AbstractGatewayDeltaEvent {
    public GatewayDeltaDestroyEvent() {
    }

    public GatewayDeltaDestroyEvent(String regionName, String key) {
        super(regionName, key);
    }

    @Override
    public void apply(Cache cache) {
        Region region = this.getRegion(cache);
        try {
            region.destroy((Object)this.key);
            if (cache.getLogger().fineEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Applied ").append(this);
                cache.getLogger().fine(builder.toString());
            }
        }
        catch (EntryNotFoundException e) {
            StringBuilder builder = new StringBuilder();
            builder.append(this).append(": Session ").append(this.key).append(" was not found");
            cache.getLogger().warning(builder.toString());
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    public static void registerInstantiator(int id) {
        Instantiator.register((Instantiator)new Instantiator(GatewayDeltaDestroyEvent.class, id){

            public DataSerializable newInstance() {
                return new GatewayDeltaDestroyEvent();
            }
        });
    }

    public String toString() {
        return "GatewayDeltaDestroyEvent[" + "regionName=" + this.regionName + "; key=" + this.key + "]";
    }
}

