/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jline.Terminal;
import jline.console.ConsoleReader;
import jline.console.history.History;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.internal.SystemDescription;
import org.apache.geode.internal.lang.utils.ClassUtils;
import org.apache.geode.internal.logging.Banner;
import org.apache.geode.internal.process.signal.AbstractSignalNotificationHandler;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.apache.geode.internal.util.HostName;
import org.apache.geode.internal.util.ProductVersionUtil;
import org.apache.geode.internal.util.SunAPINotFoundException;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.management.cli.CommandProcessingException;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtils;
import org.apache.geode.management.internal.cli.CommandManager;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.GfshConfig;
import org.apache.geode.management.internal.cli.shell.GfshExecutionStrategy;
import org.apache.geode.management.internal.cli.shell.MultiCommandHelper;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.apache.geode.management.internal.cli.shell.ScriptExecutionDetails;
import org.apache.geode.management.internal.cli.shell.jline.ANSIHandler;
import org.apache.geode.management.internal.cli.shell.jline.GfshHistory;
import org.apache.geode.management.internal.cli.shell.jline.GfshUnsupportedTerminal;
import org.apache.geode.management.internal.cli.shell.unsafe.GfshSignalHandler;
import org.apache.geode.management.internal.cli.util.CommentSkipHelper;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.core.ExitShellRequest;
import org.springframework.shell.core.JLineLogHandler;
import org.springframework.shell.core.JLineShell;
import org.springframework.shell.core.Parser;
import org.springframework.shell.event.ShellStatus;

public class Gfsh
extends JLineShell {
    public static final int DEFAULT_APP_FETCH_SIZE = 100;
    public static final int DEFAULT_APP_LAST_EXIT_STATUS = 0;
    public static final int DEFAULT_APP_COLLECTION_LIMIT = 20;
    public static final boolean DEFAULT_APP_QUIET_EXECUTION = false;
    public static final String DEFAULT_APP_QUERY_RESULTS_DISPLAY_MODE = "table";
    public static final String DEFAULT_APP_RESULT_VIEWER = "basic";
    public static final String EXTERNAL_RESULT_VIEWER = "external";
    public static final String GFSH_APP_NAME = "gfsh";
    public static final String LINE_INDENT = "    ";
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final int DEFAULT_WIDTH = 100;
    public static final String ENV_APP_NAME = "APP_NAME";
    public static final String ENV_APP_CONTEXT_PATH = "APP_CONTEXT_PATH";
    public static final String ENV_APP_FETCH_SIZE = "APP_FETCH_SIZE";
    public static final String ENV_APP_LAST_EXIT_STATUS = "APP_LAST_EXIT_STATUS";
    public static final String ENV_APP_COLLECTION_LIMIT = "APP_COLLECTION_LIMIT";
    public static final String ENV_APP_QUERY_RESULTS_DISPLAY_MODE = "APP_QUERY_RESULTS_DISPLAY_MODE";
    public static final String ENV_APP_QUIET_EXECUTION = "APP_QUIET_EXECUTION";
    public static final String ENV_APP_LOGGING_ENABLED = "APP_LOGGING_ENABLED";
    public static final String ENV_APP_LOG_FILE = "APP_LOG_FILE";
    public static final String ENV_APP_PWD = "APP_PWD";
    public static final String ENV_APP_RESULT_VIEWER = "APP_RESULT_VIEWER";
    public static final String ENV_SYS_USER = "SYS_USER";
    public static final String ENV_SYS_USER_HOME = "SYS_USER_HOME";
    public static final String ENV_SYS_HOST_NAME = "SYS_HOST_NAME";
    public static final String ENV_SYS_CLASSPATH = "SYS_CLASSPATH";
    public static final String ENV_SYS_JAVA_VERSION = "SYS_JAVA_VERSION";
    public static final String ENV_SYS_OS = "SYS_OS";
    public static final String ENV_SYS_OS_LINE_SEPARATOR = "SYS_OS_LINE_SEPARATOR";
    public static final String ENV_SYS_GEODE_HOME_DIR = "SYS_GEODE_HOME_DIR";
    private static final String DEFAULT_SECONDARY_PROMPT = ">";
    private static final int DEFAULT_HEIGHT = 100;
    private static final Object INSTANCE_LOCK = new Object();
    @MutableForTesting
    protected static PrintStream gfshout = System.out;
    @MutableForTesting
    protected static PrintStream gfsherr = System.err;
    protected static final ThreadLocal<Gfsh> gfshThreadLocal = new ThreadLocal();
    @MakeNotStatic
    private static volatile Gfsh instance;
    private static final ThreadLocal<Boolean> resultTypeTL;
    private static final String OS;
    private final Map<String, String> env = new TreeMap<String, String>();
    private final List<String> readonlyAppEnv = new ArrayList<String>();
    private final Map<String, String> expandedPropCommandsMap = new HashMap<String, String>();
    private final ExecutionStrategy executionStrategy;
    private final GfshParser parser;
    private final LogWrapper gfshFileLogger;
    private final GfshConfig gfshConfig;
    private final GfshHistory gfshHistory;
    private final ANSIHandler ansiHandler;
    private final boolean isHeadlessMode;
    private OperationInvoker operationInvoker;
    private int lastExecutionStatus;
    private Thread runner;
    private boolean debugON;
    private Terminal terminal;
    private boolean suppressScriptCmdOutput;
    private boolean isScriptRunning;
    private AbstractSignalNotificationHandler signalHandler;

    public Gfsh() {
        this(null);
    }

    protected Gfsh(String[] args) {
        this(true, args, new GfshConfig());
    }

    protected Gfsh(boolean launchShell, String[] args, GfshConfig gfshConfig) {
        JLineLogHandler.setSuppressDuplicateMessages((boolean)false);
        this.gfshConfig = gfshConfig;
        this.gfshFileLogger = LogWrapper.getInstance(null);
        this.gfshFileLogger.configure(this.gfshConfig);
        this.ansiHandler = ANSIHandler.getInstance(this.gfshConfig.isANSISupported());
        Banner banner = new Banner();
        this.gfshFileLogger.info(banner.getString());
        this.gfshHistory = new GfshHistory();
        this.initializeEnvironment();
        this.executionStrategy = new GfshExecutionStrategy(this);
        this.parser = new GfshParser(new CommandManager());
        this.setHistorySize(gfshConfig.getHistorySize());
        String envProps = this.env.toString();
        envProps = envProps.substring(1, envProps.length() - 1);
        envProps = envProps.replaceAll(",", LINE_SEPARATOR);
        this.gfshFileLogger.config("***** gfsh Environment ******" + LINE_SEPARATOR + envProps);
        if (this.gfshFileLogger.fineEnabled()) {
            String gfshConfigStr = this.gfshConfig.toString();
            gfshConfigStr = gfshConfigStr.substring(0, gfshConfigStr.length() - 1);
            gfshConfigStr = gfshConfigStr.replaceAll(",", LINE_SEPARATOR);
            this.gfshFileLogger.fine("***** gfsh Configuration ******" + LINE_SEPARATOR + gfshConfigStr);
        }
        try {
            ClassUtils.forName((String)"sun.misc.Signal", (RuntimeException)((Object)new SunAPINotFoundException("WARNING!!! Not running a Sun JVM.  Could not find the sun.misc.Signal class; Signal handling disabled.")));
            this.signalHandler = new GfshSignalHandler();
        }
        catch (SunAPINotFoundException e) {
            this.signalHandler = new AbstractSignalNotificationHandler(){};
            this.gfshFileLogger.warning(e.getMessage());
        }
        if (this.gfshConfig.isTestConfig()) {
            instance = this;
        }
        boolean bl = this.isHeadlessMode = !launchShell;
        if (this.isHeadlessMode) {
            this.gfshFileLogger.config("Running in headless mode");
            System.setProperty("jline.terminal", GfshUnsupportedTerminal.class.getName());
            this.env.put(ENV_APP_QUIET_EXECUTION, String.valueOf(true));
            this.gfshFileLogger.setParentFor(this.logger);
        }
        this.redirectInternalJavaLoggers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Gfsh getInstance(boolean launchShell, String[] args, GfshConfig gfshConfig) {
        Gfsh localGfshInstance = instance;
        if (localGfshInstance == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                localGfshInstance = instance;
                if (localGfshInstance == null) {
                    localGfshInstance = new Gfsh(launchShell, args, gfshConfig);
                    localGfshInstance.executeInitFileIfPresent();
                    instance = localGfshInstance;
                }
            }
        }
        return instance;
    }

    public static boolean isInfoResult() {
        if (resultTypeTL.get() == null) {
            return false;
        }
        return resultTypeTL.get();
    }

    public static void println() {
        gfshout.println();
    }

    public static void println(Object toPrint) {
        gfshout.println(toPrint);
    }

    public static void print(Object toPrint) {
        gfshout.print(toPrint);
    }

    public static void printlnErr(Object toPrint) {
        gfsherr.println(toPrint);
    }

    private static String readLine(ConsoleReader reader, String prompt) throws IOException {
        String readLine;
        String earlierLine = reader.getCursorBuffer().toString();
        try {
            readLine = reader.readLine(prompt);
        }
        catch (IndexOutOfBoundsException e) {
            if (earlierLine.length() == 0) {
                reader.println();
                readLine = LINE_SEPARATOR;
                reader.getCursorBuffer().cursor = 0;
            }
            readLine = Gfsh.readLine(reader, prompt);
        }
        return readLine;
    }

    private static String removeBackslash(String result) {
        if (result.endsWith("\\")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public void redirectInternalJavaLoggers() {
        LogManager logManager = LogManager.getLogManager();
        try {
            Enumeration<String> loggerNames = logManager.getLoggerNames();
            while (loggerNames.hasMoreElements()) {
                Logger javaLogger;
                String loggerName = loggerNames.nextElement();
                if (!loggerName.startsWith("java.") && !loggerName.startsWith("javax.") || (javaLogger = logManager.getLogger(loggerName)) == null) continue;
                this.gfshFileLogger.setParentFor(javaLogger);
            }
        }
        catch (SecurityException e) {
            this.gfshFileLogger.warning(e.getMessage(), e);
        }
    }

    public static Gfsh getCurrentInstance() {
        return instance;
    }

    private static String extractKey(String input) {
        return input.substring("${".length(), input.length() - "}".length());
    }

    public static ConsoleReader getConsoleReader() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        return gfsh == null ? null : gfsh.reader;
    }

    public static String wrapText(String string, int indentationLevel, int terminalWidth) {
        if (terminalWidth <= 1) {
            return string;
        }
        int maxLineLength = terminalWidth - 1;
        StringBuilder stringBuf = new StringBuilder();
        int index = 0;
        int startOfCurrentLine = 0;
        while (index < string.length()) {
            for (int i = 0; i < indentationLevel; ++i) {
                stringBuf.append(LINE_INDENT);
            }
            for (int currentLineLength = LINE_INDENT.length() * indentationLevel; index < string.length() && currentLineLength < maxLineLength && string.charAt(index) != '\n'; ++index, ++currentLineLength) {
            }
            if (index != string.length() && string.charAt(index) == '\n') {
                stringBuf.append(string, startOfCurrentLine, index);
                stringBuf.append(LINE_SEPARATOR);
                startOfCurrentLine = ++index;
            } else if (index == string.length() || string.charAt(index) == ' ') {
                stringBuf.append(string, startOfCurrentLine, index);
                if (index != string.length()) {
                    stringBuf.append(LINE_SEPARATOR);
                }
            } else {
                int spaceCharIndex = string.lastIndexOf(" ", index);
                if (spaceCharIndex == -1 || spaceCharIndex < startOfCurrentLine) {
                    stringBuf.append(string, startOfCurrentLine, index).append(LINE_SEPARATOR);
                } else {
                    stringBuf.append(string, startOfCurrentLine, spaceCharIndex).append(LINE_SEPARATOR);
                    index = spaceCharIndex + 1;
                }
            }
            startOfCurrentLine = ++index;
        }
        return stringBuf.toString();
    }

    private void initializeEnvironment() {
        this.env.put(ENV_SYS_USER, System.getProperty("user.name"));
        this.env.put(ENV_SYS_USER_HOME, System.getProperty("user.home"));
        this.env.put(ENV_SYS_HOST_NAME, new HostName().determineHostName());
        this.env.put(ENV_SYS_CLASSPATH, System.getProperty("java.class.path"));
        this.env.put(ENV_SYS_JAVA_VERSION, System.getProperty("java.version"));
        this.env.put(ENV_SYS_OS, System.getProperty("os.name"));
        this.env.put(ENV_SYS_OS_LINE_SEPARATOR, System.lineSeparator());
        this.env.put(ENV_SYS_GEODE_HOME_DIR, System.getenv("GEODE_HOME"));
        this.env.put(ENV_APP_NAME, GFSH_APP_NAME);
        this.readonlyAppEnv.add(ENV_APP_NAME);
        this.env.put(ENV_APP_LOGGING_ENABLED, String.valueOf(!Level.OFF.equals(this.gfshConfig.getLogLevel())));
        this.readonlyAppEnv.add(ENV_APP_LOGGING_ENABLED);
        this.env.put(ENV_APP_LOG_FILE, this.gfshConfig.getLogFilePath());
        this.readonlyAppEnv.add(ENV_APP_LOG_FILE);
        this.env.put(ENV_APP_PWD, System.getProperty("user.dir"));
        this.readonlyAppEnv.add(ENV_APP_PWD);
        this.env.put(ENV_APP_FETCH_SIZE, String.valueOf(100));
        this.env.put(ENV_APP_LAST_EXIT_STATUS, String.valueOf(0));
        this.readonlyAppEnv.add(ENV_APP_LAST_EXIT_STATUS);
        this.env.put(ENV_APP_COLLECTION_LIMIT, String.valueOf(20));
        this.env.put(ENV_APP_QUERY_RESULTS_DISPLAY_MODE, DEFAULT_APP_QUERY_RESULTS_DISPLAY_MODE);
        this.env.put(ENV_APP_QUIET_EXECUTION, String.valueOf(false));
        this.env.put(ENV_APP_RESULT_VIEWER, DEFAULT_APP_RESULT_VIEWER);
    }

    public AbstractSignalNotificationHandler getSignalHandler() {
        return this.signalHandler;
    }

    public String readPassword(String textToPrompt) {
        if (this.isHeadlessMode && this.isQuietMode()) {
            return null;
        }
        return this.readWithMask(textToPrompt, Character.valueOf('*'));
    }

    public String readText(String textToPrompt) {
        if (this.isHeadlessMode && this.isQuietMode()) {
            return null;
        }
        return this.interact(textToPrompt);
    }

    public void start() {
        this.runner = new LoggingThread(this.getShellName(), false, (Runnable)((Object)this));
        this.runner.start();
    }

    protected String getShellName() {
        return "Gfsh Launcher";
    }

    public void stop() {
        this.closeShell();
        LogWrapper.close();
        if (this.operationInvoker != null && this.operationInvoker.isConnected()) {
            this.operationInvoker.stop();
        }
        instance = null;
    }

    public void waitForComplete() throws InterruptedException {
        this.runner.join();
    }

    private void executeInitFileIfPresent() {
        String initFileName = this.gfshConfig.getInitFileName();
        if (initFileName != null) {
            this.gfshFileLogger.info("Using " + initFileName);
            try {
                File gfshInitFile = new File(initFileName);
                boolean continueOnError = false;
                this.executeScript(gfshInitFile, this.isQuietMode(), continueOnError);
            }
            catch (Exception exception) {
                this.gfshFileLogger.severe(initFileName, exception);
                this.setLastExecutionStatus(-1);
            }
        }
    }

    protected Collection<URL> findResources(String resourceName) {
        return null;
    }

    protected ExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    public Parser getParser() {
        return this.parser;
    }

    public LogWrapper getGfshFileLogger() {
        return this.gfshFileLogger;
    }

    public org.springframework.shell.core.CommandResult executeCommand(String line) {
        return super.executeCommand(!line.contains("$") ? line : this.expandProperties(line));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeScriptLine(String line) {
        boolean success = false;
        String withPropsExpanded = line;
        try {
            if (line.contains("$")) {
                withPropsExpanded = this.expandProperties(line);
            }
            String logMessage = "Command String to execute .. ";
            if (!line.equals(withPropsExpanded)) {
                if (!this.isQuietMode()) {
                    Gfsh.println("Post substitution: " + withPropsExpanded);
                }
                logMessage = "Command String after substitution : ";
                this.expandedPropCommandsMap.put(withPropsExpanded, line);
            }
            if (this.gfshFileLogger.fineEnabled()) {
                this.gfshFileLogger.fine(logMessage + ArgumentRedactor.redact((String)withPropsExpanded));
            }
            success = super.executeScriptLine(withPropsExpanded);
        }
        catch (Exception e) {
            this.setLastExecutionStatus(-1);
        }
        finally {
            this.gfshHistory.setAutoFlush(true);
            this.gfshHistory.addToHistory(line);
            this.gfshHistory.setAutoFlush(false);
            this.expandedPropCommandsMap.clear();
        }
        return success;
    }

    public String interact(String textToPrompt) {
        try {
            return this.reader.readLine(textToPrompt);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String readWithMask(String textToPrompt, Character mask) {
        try {
            return this.reader.readLine(textToPrompt, mask);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void printBannerAndWelcome() {
        this.printAsInfo(this.getBanner());
        this.printAsInfo(this.getWelcomeMessage());
    }

    public String getBanner() {
        String sb = "    _________________________     __" + LINE_SEPARATOR + "   / _____/ ______/ ______/ /____/ /" + LINE_SEPARATOR + "  / /  __/ /___  /_____  / _____  / " + LINE_SEPARATOR + " / /__/ / ____/  _____/ / /    / /  " + LINE_SEPARATOR + "/______/_/      /______/_/    /_/    " + this.getVersion() + LINE_SEPARATOR;
        return this.ansiHandler.decorateString(sb, ANSIHandler.ANSIStyle.BLUE);
    }

    protected String getProductName() {
        return GFSH_APP_NAME;
    }

    public String getVersion() {
        return this.getVersion(false);
    }

    public String getVersion(boolean full) {
        return full ? this.getFullVersion() : this.getShortVersion();
    }

    private String getShortVersion() {
        return ProductVersionUtil.getDistributionVersion().getVersion();
    }

    private String getFullVersion() {
        try {
            return ((StringBuilder)ProductVersionUtil.appendFullVersion((Appendable)new StringBuilder())).append(System.lineSeparator()).append(SystemDescription.getRunningOnInfo()).append(System.lineSeparator()).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getGeodeSerializationVersion() {
        return KnownVersion.CURRENT.getName();
    }

    public String getWelcomeMessage() {
        return this.ansiHandler.decorateString("Monitor and Manage " + ProductVersionUtil.getDistributionVersion().getName(), ANSIHandler.ANSIStyle.CYAN);
    }

    protected void handleExecutionResult(Object result) {
        try {
            if (result instanceof Result) {
                Result commandResult = (Result)result;
                boolean isError = Result.Status.ERROR.equals((Object)commandResult.getStatus());
                if (isError) {
                    this.setLastExecutionStatus(-2);
                } else {
                    this.setLastExecutionStatus(0);
                }
                if (this.useExternalViewer(commandResult)) {
                    CliUtils.runLessCommandAsExternalViewer(commandResult);
                } else {
                    if (!this.isScriptRunning) {
                        while (commandResult.hasNextLine()) {
                            String nextLine = commandResult.nextLine();
                            this.write(nextLine, isError);
                        }
                    } else if (!this.suppressScriptCmdOutput) {
                        while (commandResult.hasNextLine()) {
                            this.write(commandResult.nextLine(), isError);
                        }
                    }
                    commandResult.resetToFirstLine();
                }
                resultTypeTL.set(null);
            }
            if (result != null && !(result instanceof Result)) {
                this.printAsInfo(result.toString());
            }
        }
        catch (Exception e) {
            this.printAsWarning(e.getMessage());
            this.logToFile(e.getMessage(), e);
        }
    }

    private boolean useExternalViewer(Result result) {
        boolean flag;
        boolean bl = flag = EXTERNAL_RESULT_VIEWER.equals(this.getEnvProperty(ENV_APP_RESULT_VIEWER)) && this.isUnix();
        if (result instanceof CommandResult) {
            CommandResult commandResult = (CommandResult)result;
            resultTypeTL.set(commandResult.getType().equals("info"));
            return flag && !commandResult.getType().equals("info");
        }
        return false;
    }

    private boolean isUnix() {
        return !OS.contains("win");
    }

    private void write(String message, boolean isError) {
        if (isError) {
            this.printAsWarning(message);
        } else {
            Gfsh.println(message);
        }
    }

    protected ConsoleReader createConsoleReader() {
        ConsoleReader consoleReader = super.createConsoleReader();
        consoleReader.setHistory((History)this.gfshHistory);
        this.terminal = consoleReader.getTerminal();
        return consoleReader;
    }

    protected void logCommandToOutput(String processedLine) {
        String originalString = this.expandedPropCommandsMap.get(processedLine);
        if (originalString != null) {
            super.logCommandToOutput(ArgumentRedactor.redact((String)originalString));
            super.logCommandToOutput(ArgumentRedactor.redact((String)"// Post substitution"));
            super.logCommandToOutput(ArgumentRedactor.redact((String)("//" + processedLine)));
        } else {
            super.logCommandToOutput(ArgumentRedactor.redact((String)processedLine));
        }
    }

    public String versionInfo() {
        return this.getVersion();
    }

    public int getTerminalHeight() {
        return this.terminal != null ? this.terminal.getHeight() : 100;
    }

    public int getTerminalWidth() {
        if (this.terminal != null) {
            return this.terminal.getWidth();
        }
        Map<String, String> env = System.getenv();
        String columnsFromEnv = env.get("COLUMNS");
        if (columnsFromEnv != null) {
            return Integer.parseInt(columnsFromEnv);
        }
        return 100;
    }

    public int getLastExecutionStatus() {
        return this.lastExecutionStatus;
    }

    public void setLastExecutionStatus(int lastExecutionStatus) {
        this.lastExecutionStatus = lastExecutionStatus;
        this.env.put(ENV_APP_LAST_EXIT_STATUS, String.valueOf(lastExecutionStatus));
    }

    public void printAsInfo(String message) {
        if (this.isHeadlessMode) {
            Gfsh.println(message);
        } else {
            this.logger.info(message);
        }
    }

    public void printAsWarning(String message) {
        if (this.isHeadlessMode) {
            Gfsh.printlnErr(message);
        } else {
            this.logger.warning(message);
        }
    }

    public void printAsSevere(String message) {
        if (this.isHeadlessMode) {
            Gfsh.printlnErr(message);
        } else {
            this.logger.severe(message);
        }
    }

    public void logInfo(String message, Throwable t) {
        if (this.debugON) {
            this.logger.log(Level.INFO, message, t);
        } else {
            this.logger.info(message);
        }
        if (this.gfshFileLogger.infoEnabled()) {
            this.gfshFileLogger.info(message, t);
        }
    }

    public void logWarning(String message, Throwable t) {
        if (this.debugON) {
            this.logger.log(Level.WARNING, message, t);
        } else {
            this.logger.warning(message);
        }
        if (this.gfshFileLogger.warningEnabled()) {
            this.gfshFileLogger.warning(message, t);
        }
    }

    public void logSevere(String message, Throwable t) {
        if (this.debugON) {
            this.logger.log(Level.SEVERE, message, t);
        } else {
            this.logger.severe(message);
        }
        if (this.gfshFileLogger.severeEnabled()) {
            this.gfshFileLogger.severe(message, t);
        }
    }

    public boolean logToFile(String message, Throwable t) {
        boolean loggedMessage = false;
        if (this.gfshFileLogger != null) {
            this.gfshFileLogger.info(message, t);
            loggedMessage = true;
        }
        return loggedMessage;
    }

    public ResultModel executeScript(File scriptFile, boolean quiet, boolean continueOnError) {
        ResultModel result = null;
        String initialIsQuiet = this.getEnvProperty(ENV_APP_QUIET_EXECUTION);
        try {
            BufferedReader reader;
            this.isScriptRunning = true;
            if (scriptFile == null) {
                throw new IllegalArgumentException("Given script file is null.");
            }
            if (!scriptFile.exists()) {
                throw new IllegalArgumentException("Given script file does not exist.");
            }
            if (scriptFile.exists() && scriptFile.isDirectory()) {
                throw new IllegalArgumentException(scriptFile.getPath() + " is a directory.");
            }
            ScriptExecutionDetails scriptInfo = new ScriptExecutionDetails(scriptFile.getPath());
            if (scriptFile.exists()) {
                this.setEnvProperty(ENV_APP_QUIET_EXECUTION, String.valueOf(quiet));
                this.suppressScriptCmdOutput = quiet;
                reader = new BufferedReader(new FileReader(scriptFile));
                String lineRead = "";
                StringBuilder linesBuffer = new StringBuilder();
                String linesBufferString = "";
                int commandSrNum = 0;
                CommentSkipHelper commentSkipper = new CommentSkipHelper();
                block5: while (this.exitShellRequest == null && (lineRead = reader.readLine()) != null) {
                    String lineWithoutComments;
                    if (linesBuffer == null) {
                        linesBuffer = new StringBuilder();
                    }
                    if ((lineWithoutComments = commentSkipper.skipComments(lineRead)) == null || lineWithoutComments.isEmpty()) continue;
                    if (linesBuffer.length() != 0) {
                        linesBuffer.append(" ");
                    }
                    linesBuffer.append(lineWithoutComments);
                    linesBufferString = linesBuffer.toString();
                    if (!linesBufferString.endsWith("\\")) {
                        List<String> commandList = MultiCommandHelper.getMultipleCommands(linesBufferString);
                        for (String cmdLet : commandList) {
                            if (cmdLet.isEmpty()) continue;
                            String redactedCmdLet = ArgumentRedactor.redact((String)cmdLet);
                            Gfsh.println(++commandSrNum + ". Executing - " + redactedCmdLet);
                            Gfsh.println();
                            boolean executeSuccess = this.executeScriptLine(cmdLet);
                            if (!executeSuccess) {
                                this.setLastExecutionStatus(-1);
                            }
                            scriptInfo.addCommandAndStatus(cmdLet, this.getLastExecutionStatus() == -1 || this.getLastExecutionStatus() == -2 ? "FAILED" : "PASSED");
                            if (this.getLastExecutionStatus() != -1 && this.getLastExecutionStatus() != -2 || continueOnError) continue;
                            break block5;
                        }
                        linesBuffer = null;
                        linesBufferString = null;
                        continue;
                    }
                    linesBuffer.deleteCharAt(linesBuffer.length() - 1);
                }
            } else {
                throw new CommandProcessingException(scriptFile.getPath() + " doesn't exist.", 5, scriptFile);
            }
            reader.close();
            result = scriptInfo.getResult();
            scriptInfo.logScriptExecutionInfo(this.gfshFileLogger, result);
            if (quiet) {
                result = ResultModel.createInfo("");
            }
        }
        catch (IOException e) {
            throw new CommandProcessingException("Error while reading file " + scriptFile, 11, e);
        }
        finally {
            this.setEnvProperty(ENV_APP_QUIET_EXECUTION, initialIsQuiet);
            this.isScriptRunning = false;
        }
        return result;
    }

    public String setEnvProperty(String propertyName, String propertyValue) {
        if (propertyName == null || propertyValue == null) {
            throw new IllegalArgumentException("Environment Property name and/or value can not be set to null.");
        }
        if (propertyName.startsWith("SYS") || this.readonlyAppEnv.contains(propertyName)) {
            throw new IllegalArgumentException("The Property " + propertyName + " can not be modified.");
        }
        return this.env.put(propertyName, propertyValue);
    }

    public String getEnvProperty(String propertyName) {
        return this.env.get(propertyName);
    }

    public String getEnvAppContextPath() {
        String path = this.getEnvProperty(ENV_APP_CONTEXT_PATH);
        if (path == null) {
            return "";
        }
        return path;
    }

    public Map<String, String> getEnv() {
        return new TreeMap<String, String>(this.env);
    }

    public boolean isQuietMode() {
        return Boolean.parseBoolean(this.env.get(ENV_APP_QUIET_EXECUTION));
    }

    public void promptLoop() {
        String line = null;
        String prompt = this.getPromptText();
        try {
            this.gfshHistory.setAutoFlush(false);
            while (this.exitShellRequest == null && (line = Gfsh.readLine(this.reader, prompt)) != null) {
                if (!line.endsWith("\\")) {
                    List<String> commandList = MultiCommandHelper.getMultipleCommands(line);
                    for (String cmdLet : commandList) {
                        String trimmedCommand = cmdLet.trim();
                        if (trimmedCommand.isEmpty()) continue;
                        this.executeCommand(cmdLet);
                    }
                    prompt = this.getPromptText();
                    continue;
                }
                prompt = this.getDefaultSecondaryPrompt();
                this.reader.getCursorBuffer().cursor = 0;
                this.reader.getCursorBuffer().write((CharSequence)(Gfsh.removeBackslash(line) + LINE_SEPARATOR));
            }
            if (line == null) {
                this.exitShellRequest = ExitShellRequest.NORMAL_EXIT;
                this.gfshFileLogger.info("Exiting gfsh, it seems Ctrl-D was pressed.");
            }
        }
        catch (IOException e) {
            this.logSevere(e.getMessage(), e);
        }
        Gfsh.println((line == null ? LINE_SEPARATOR : "") + "Exiting... ");
        this.setShellStatus(ShellStatus.Status.SHUTTING_DOWN);
    }

    String getDefaultSecondaryPrompt() {
        return this.ansiHandler.decorateString(DEFAULT_SECONDARY_PROMPT, ANSIHandler.ANSIStyle.YELLOW);
    }

    public boolean isConnectedAndReady() {
        return this.operationInvoker != null && this.operationInvoker.isConnected() && this.operationInvoker.isReady();
    }

    public static boolean isCurrentInstanceConnectedAndReady() {
        return Gfsh.getCurrentInstance() != null && Gfsh.getCurrentInstance().isConnectedAndReady();
    }

    public OperationInvoker getOperationInvoker() {
        return this.operationInvoker;
    }

    public void setOperationInvoker(OperationInvoker operationInvoker) {
        this.operationInvoker = operationInvoker;
    }

    public GfshConfig getGfshConfig() {
        return this.gfshConfig;
    }

    protected String getHistoryFileName() {
        return this.gfshConfig.getHistoryFileName();
    }

    public void clearHistory() {
        this.gfshHistory.clear();
        if (!this.gfshConfig.deleteHistoryFile()) {
            this.printAsWarning("Gfsh history file is not deleted");
        }
    }

    public String getLogFilePath() {
        return this.gfshConfig.getLogFilePath();
    }

    public boolean isLoggingEnabled() {
        return this.gfshConfig.isLoggingEnabled();
    }

    protected String getPromptText() {
        int clusterId;
        String defaultPrompt = this.gfshConfig.getDefaultPrompt();
        String contextPath = "";
        String clusterString = "";
        if (this.getOperationInvoker() != null && this.isConnectedAndReady() && (clusterId = this.getOperationInvoker().getClusterId()) != -1) {
            clusterString = "Cluster-" + clusterId + " ";
        }
        defaultPrompt = MessageFormat.format(defaultPrompt, clusterString, contextPath);
        return this.ansiHandler.decorateString(defaultPrompt, ANSIHandler.ANSIStyle.YELLOW);
    }

    public void notifyDisconnect(String endPoints) {
        String message = CliStrings.format((String)"No longer connected to {0}.", (Object[])new Object[]{endPoints});
        this.printAsSevere(LINE_SEPARATOR + message);
        if (this.gfshFileLogger.severeEnabled()) {
            this.gfshFileLogger.severe(message);
        }
        this.setPromptPath(this.getEnvAppContextPath());
    }

    public boolean getDebug() {
        return this.debugON;
    }

    public void setDebug(boolean flag) {
        this.debugON = flag;
    }

    public boolean isHeadlessMode() {
        return this.isHeadlessMode;
    }

    public GfshHistory getGfshHistory() {
        return this.gfshHistory;
    }

    protected String expandProperties(String input) {
        String foundInLine;
        String output = input;
        Scanner s = new Scanner(output);
        while ((foundInLine = s.findInLine("(\\$[\\{]\\w+[\\}])")) != null) {
            String envProperty = this.getEnvProperty(Gfsh.extractKey(foundInLine));
            envProperty = envProperty != null ? envProperty : "";
            output = output.replace(foundInLine, envProperty);
        }
        return output;
    }

    static {
        resultTypeTL = new ThreadLocal();
        OS = System.getProperty("os.name").toLowerCase();
    }
}

