/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.pubsub;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.redis.internal.executor.GlobPattern;
import org.apache.geode.redis.internal.netty.Client;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;
import org.apache.geode.redis.internal.pubsub.ChannelSubscription;
import org.apache.geode.redis.internal.pubsub.PatternSubscription;
import org.apache.geode.redis.internal.pubsub.SubscribeResult;
import org.apache.geode.redis.internal.pubsub.Subscription;

public class Subscriptions {
    private final List<Subscription> subscriptions = new CopyOnWriteArrayList<Subscription>();

    @VisibleForTesting
    boolean exists(Object channelOrPattern, Client client) {
        return this.subscriptions.stream().anyMatch(subscription -> subscription.isEqualTo(channelOrPattern, client));
    }

    public List<Subscription> findSubscriptions(Client client) {
        return this.subscriptions.stream().filter(subscription -> subscription.matchesClient(client)).collect(Collectors.toList());
    }

    public List<Subscription> findSubscriptions(byte[] channelOrPattern) {
        return this.subscriptions.stream().filter(subscription -> subscription.matches(channelOrPattern)).collect(Collectors.toList());
    }

    @VisibleForTesting
    void add(Subscription subscription) {
        this.subscriptions.add(subscription);
    }

    public void remove(Client client) {
        this.subscriptions.removeIf(subscription -> subscription.matchesClient(client));
    }

    @VisibleForTesting
    boolean remove(Object channel, Client client) {
        return this.subscriptions.removeIf(subscription -> subscription.isEqualTo(channel, client));
    }

    @VisibleForTesting
    int size() {
        return this.subscriptions.size();
    }

    public synchronized SubscribeResult subscribe(byte[] channel, ExecutionHandlerContext context, Client client) {
        ChannelSubscription createdSubscription = null;
        if (!this.exists(channel, client)) {
            createdSubscription = new ChannelSubscription(client, channel, context, this);
            this.add(createdSubscription);
        }
        long channelCount = this.findSubscriptions(client).size();
        return new SubscribeResult(createdSubscription, channelCount, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscribeResult psubscribe(byte[] patternBytes, ExecutionHandlerContext context, Client client) {
        GlobPattern pattern = new GlobPattern(new String(patternBytes));
        PatternSubscription createdSubscription = null;
        Subscriptions subscriptions = this;
        synchronized (subscriptions) {
            if (!this.exists(pattern, client)) {
                createdSubscription = new PatternSubscription(client, pattern, context, this);
                this.add(createdSubscription);
            }
            long channelCount = this.findSubscriptions(client).size();
            return new SubscribeResult(createdSubscription, channelCount, patternBytes);
        }
    }

    public synchronized long unsubscribe(Object channelOrPattern, Client client) {
        this.remove(channelOrPattern, client);
        return this.findSubscriptions(client).size();
    }
}

