/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.netty;

import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import org.apache.geode.annotations.internal.MakeImmutable;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.netty.CoderException;

public class Coder {
    public static final byte BULK_STRING_ID = 36;
    public static final byte ARRAY_ID = 42;
    public static final byte ERROR_ID = 45;
    public static final byte INTEGER_ID = 58;
    public static final byte NUMBER_1_BYTE = 49;
    public static final byte SIMPLE_STRING_ID = 43;
    public static final String CRLF = "\r\n";
    @MakeImmutable
    public static final byte[] CRLFar = Coder.stringToBytes("\r\n");
    @MakeImmutable
    public static final byte[] bNIL = Coder.stringToBytes("$-1\r\n");
    @MakeImmutable
    public static final byte[] bEMPTY_ARRAY = Coder.stringToBytes("*0\r\n");
    @MakeImmutable
    public static final byte[] bEMPTY_STRING = Coder.stringToBytes("$0\r\n\r\n");
    @MakeImmutable
    public static final byte[] err = Coder.stringToBytes("ERR ");
    @MakeImmutable
    public static final byte[] oom = Coder.stringToBytes("OOM ");
    @MakeImmutable
    public static final byte[] wrongType = Coder.stringToBytes("WRONGTYPE ");
    public static final String CHARSET = "UTF-8";
    @MakeImmutable
    protected static final DecimalFormat decimalFormatter = new DecimalFormat("#");
    public static final String P_INF = "+inf";
    public static final String N_INF = "-inf";

    public static ByteBuf getBulkStringResponse(ByteBuf buffer, Object v) throws CoderException {
        if (v == null) {
            buffer.writeBytes(bNIL);
        } else if (v instanceof byte[]) {
            byte[] toWrite = (byte[])v;
            Coder.writeStringResponse(buffer, toWrite);
        } else if (v instanceof ByteArrayWrapper) {
            byte[] toWrite = ((ByteArrayWrapper)v).toBytes();
            Coder.writeStringResponse(buffer, toWrite);
        } else if (v instanceof Double) {
            byte[] toWrite = Coder.doubleToBytes((Double)v);
            Coder.writeStringResponse(buffer, toWrite);
        } else if (v instanceof String) {
            String value = (String)v;
            byte[] toWrite = Coder.stringToBytes(value);
            Coder.writeStringResponse(buffer, toWrite);
        } else if (v instanceof Integer) {
            buffer.writeByte(58);
            buffer.writeBytes(Coder.intToBytes((Integer)v));
            buffer.writeBytes(CRLFar);
        } else if (v instanceof Long) {
            buffer.writeByte(58);
            buffer.writeBytes(Coder.intToBytes(((Long)v).intValue()));
            buffer.writeBytes(CRLFar);
        } else {
            throw new CoderException();
        }
        return buffer;
    }

    private static void writeStringResponse(ByteBuf buffer, byte[] toWrite) {
        buffer.writeByte(36);
        buffer.writeBytes(Coder.intToBytes(toWrite.length));
        buffer.writeBytes(CRLFar);
        buffer.writeBytes(toWrite);
        buffer.writeBytes(CRLFar);
    }

    public static ByteBuf getFlattenedArrayResponse(ByteBuf buffer, Collection<Collection<?>> items) throws CoderException {
        for (Collection<?> next : items) {
            Coder.writeCollectionOrString(buffer, next);
        }
        return buffer;
    }

    public static ByteBuf getArrayResponse(ByteBuf buffer, Collection<?> items) throws CoderException {
        buffer.writeByte(42);
        buffer.writeBytes(Coder.intToBytes(items.size()));
        buffer.writeBytes(CRLFar);
        for (Object next : items) {
            Coder.writeCollectionOrString(buffer, next);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCollectionOrString(ByteBuf buffer, Object next) throws CoderException {
        Object tmp = null;
        try {
            if (next instanceof Collection) {
                Collection nextItems = (Collection)next;
                Coder.getArrayResponse(buffer, nextItems);
            } else {
                Coder.getBulkStringResponse(buffer, next);
            }
        }
        finally {
            if (tmp != null) {
                tmp.release();
            }
        }
    }

    public static ByteBuf getScanResponse(ByteBuf buffer, BigInteger cursor, List<Object> scanResult) {
        buffer.writeByte(42);
        buffer.writeBytes(Coder.intToBytes(2));
        buffer.writeBytes(CRLFar);
        buffer.writeByte(36);
        byte[] cursorBytes = Coder.stringToBytes(cursor.toString());
        buffer.writeBytes(Coder.intToBytes(cursorBytes.length));
        buffer.writeBytes(CRLFar);
        buffer.writeBytes(cursorBytes);
        buffer.writeBytes(CRLFar);
        buffer.writeByte(42);
        buffer.writeBytes(Coder.intToBytes(scanResult.size()));
        buffer.writeBytes(CRLFar);
        for (Object nextObject : scanResult) {
            Object next;
            if (nextObject instanceof String) {
                next = (String)nextObject;
                buffer.writeByte(36);
                buffer.writeBytes(Coder.intToBytes(((String)next).length()));
                buffer.writeBytes(CRLFar);
                buffer.writeBytes(Coder.stringToBytes((String)next));
                buffer.writeBytes(CRLFar);
                continue;
            }
            if (!(nextObject instanceof ByteArrayWrapper)) continue;
            next = ((ByteArrayWrapper)nextObject).toBytes();
            buffer.writeByte(36);
            buffer.writeBytes(Coder.intToBytes(((Object)next).length));
            buffer.writeBytes(CRLFar);
            buffer.writeBytes((byte[])next);
            buffer.writeBytes(CRLFar);
        }
        return buffer;
    }

    public static ByteBuf getEmptyArrayResponse(ByteBuf buffer) {
        buffer.writeBytes(bEMPTY_ARRAY);
        return buffer;
    }

    public static ByteBuf getEmptyStringResponse(ByteBuf buffer) {
        buffer.writeBytes(bEMPTY_STRING);
        return buffer;
    }

    public static ByteBuf getSimpleStringResponse(ByteBuf buffer, String string) {
        byte[] simpAr = Coder.stringToBytes(string);
        return Coder.getSimpleStringResponse(buffer, simpAr);
    }

    public static ByteBuf getSimpleStringResponse(ByteBuf buffer, byte[] byteArray) {
        buffer.writeByte(43);
        buffer.writeBytes(byteArray);
        buffer.writeBytes(CRLFar);
        return buffer;
    }

    public static ByteBuf getErrorResponse(ByteBuf buffer, String error) {
        byte[] errorAr = Coder.stringToBytes(error);
        buffer.writeByte(45);
        buffer.writeBytes(err);
        buffer.writeBytes(errorAr);
        buffer.writeBytes(CRLFar);
        return buffer;
    }

    public static ByteBuf getOOMResponse(ByteBuf buffer, String error) {
        byte[] errorAr = Coder.stringToBytes(error);
        buffer.writeByte(45);
        buffer.writeBytes(oom);
        buffer.writeBytes(errorAr);
        buffer.writeBytes(CRLFar);
        return buffer;
    }

    public static ByteBuf getCustomErrorResponse(ByteBuf buffer, String error) {
        byte[] errorAr = Coder.stringToBytes(error);
        buffer.writeByte(45);
        buffer.writeBytes(errorAr);
        buffer.writeBytes(CRLFar);
        return buffer;
    }

    public static ByteBuf getWrongTypeResponse(ByteBuf buffer, String error) {
        byte[] errorAr = Coder.stringToBytes(error);
        buffer.writeByte(45);
        buffer.writeBytes(wrongType);
        buffer.writeBytes(errorAr);
        buffer.writeBytes(CRLFar);
        return buffer;
    }

    public static ByteBuf getIntegerResponse(ByteBuf buffer, int integer) {
        buffer.writeByte(58);
        buffer.writeBytes(Coder.intToBytes(integer));
        buffer.writeBytes(CRLFar);
        return buffer;
    }

    public static ByteBuf getIntegerResponse(ByteBuf buffer, long l) {
        buffer.writeByte(58);
        buffer.writeBytes(Coder.longToBytes(l));
        buffer.writeBytes(CRLFar);
        return buffer;
    }

    public static ByteBuf getBigDecimalResponse(ByteBuf buffer, BigDecimal b) {
        Coder.writeStringResponse(buffer, Coder.bigDecimalToBytes(b));
        return buffer;
    }

    public static ByteBuf getNilResponse(ByteBuf buffer) {
        buffer.writeBytes(bNIL);
        return buffer;
    }

    public static String bytesToString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    public static String doubleToString(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        String stringValue = String.valueOf(d);
        if (stringValue.endsWith(".0")) {
            return stringValue.substring(0, stringValue.length() - 2);
        }
        return stringValue;
    }

    public static byte[] stringToBytes(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes();
    }

    public static byte[] intToBytes(int i) {
        return Coder.stringToBytes(String.valueOf(i));
    }

    public static byte[] longToBytes(long l) {
        return Coder.stringToBytes(String.valueOf(l));
    }

    public static byte[] doubleToBytes(double d) {
        return Coder.stringToBytes(Coder.doubleToString(d));
    }

    public static byte[] bigDecimalToBytes(BigDecimal b) {
        return Coder.stringToBytes(b.toPlainString());
    }

    public static BigDecimal bytesToBigDecimal(byte[] bytes) {
        return new BigDecimal(Coder.bytesToString(bytes));
    }

    public static int bytesToInt(byte[] bytes) {
        return Integer.parseInt(Coder.bytesToString(bytes));
    }

    public static long bytesToLong(byte[] bytes) {
        return Long.parseLong(Coder.bytesToString(bytes));
    }

    public static double bytesToDouble(byte[] bytes) {
        return Coder.stringToDouble(Coder.bytesToString(bytes));
    }

    public static double stringToDouble(String d) {
        if (d.equalsIgnoreCase(P_INF)) {
            return Double.POSITIVE_INFINITY;
        }
        if (d.equalsIgnoreCase(N_INF)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(d);
    }

    static {
        decimalFormatter.setMaximumFractionDigits(10);
    }
}

