/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.executor.GlobPattern;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;
import org.apache.geode.redis.internal.pubsub.Subscription;
import org.apache.logging.log4j.Logger;

public class PunsubscribeExecutor
extends AbstractExecutor {
    private static final Logger logger = LogService.getLogger();

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        context.eventLoopReady();
        List<byte[]> patternNames = this.extractPatternNames(command);
        if (patternNames.isEmpty()) {
            patternNames = context.getPubSub().findSubscriptionNames(context.getClient(), Subscription.Type.PATTERN);
        }
        Collection<Collection<?>> response = this.punsubscribe(context, patternNames);
        return RedisResponse.flattenedArray(response);
    }

    private List<byte[]> extractPatternNames(Command command) {
        return command.getProcessedCommandWrappers().stream().skip(1L).map(ByteArrayWrapper::toBytes).collect(Collectors.toList());
    }

    private Collection<Collection<?>> punsubscribe(ExecutionHandlerContext context, List<byte[]> patternNames) {
        ArrayList response = new ArrayList();
        if (patternNames.isEmpty()) {
            response.add(this.createItem(null, 0L));
        } else {
            for (byte[] pattern : patternNames) {
                long subscriptionCount = context.getPubSub().punsubscribe(new GlobPattern(new String(pattern)), context.getClient());
                response.add(this.createItem(pattern, subscriptionCount));
            }
        }
        return response;
    }

    private ArrayList<Object> createItem(byte[] pattern, long subscriptionCount) {
        ArrayList<Object> oneItem = new ArrayList<Object>();
        oneItem.add("punsubscribe");
        oneItem.add(pattern);
        oneItem.add(subscriptionCount);
        return oneItem;
    }
}

