/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.key;

import java.util.ArrayList;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.RedisCommandType;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisCommandsFunctionInvoker;
import org.apache.geode.redis.internal.executor.key.RedisKeyCommands;

public class RedisKeyCommandsFunctionInvoker
extends RedisCommandsFunctionInvoker
implements RedisKeyCommands {
    public RedisKeyCommandsFunctionInvoker(Region<RedisKey, RedisData> region) {
        super(region);
    }

    @Override
    public boolean del(RedisKey key) {
        return (Boolean)this.invokeCommandFunction(key, new Object[]{RedisCommandType.DEL});
    }

    @Override
    public boolean exists(RedisKey key) {
        return (Boolean)this.invokeCommandFunction(key, new Object[]{RedisCommandType.EXISTS});
    }

    @Override
    public long pttl(RedisKey key) {
        return (Long)this.invokeCommandFunction(key, new Object[]{RedisCommandType.PTTL});
    }

    @Override
    public long internalPttl(RedisKey key) {
        return (Long)this.invokeCommandFunction(key, new Object[]{RedisCommandType.INTERNALPTTL});
    }

    @Override
    public int pexpireat(RedisKey key, long timestamp) {
        return (Integer)this.invokeCommandFunction(key, new Object[]{RedisCommandType.PEXPIREAT, timestamp});
    }

    @Override
    public int persist(RedisKey key) {
        return (Integer)this.invokeCommandFunction(key, new Object[]{RedisCommandType.PERSIST});
    }

    @Override
    public String type(RedisKey key) {
        return (String)this.invokeCommandFunction(key, new Object[]{RedisCommandType.TYPE});
    }

    @Override
    public String internalType(RedisKey key) {
        return (String)this.invokeCommandFunction(key, new Object[]{RedisCommandType.INTERNALTYPE});
    }

    @Override
    public boolean rename(RedisKey oldKey, RedisKey newKey) {
        if (!this.region.containsKey((Object)oldKey)) {
            return false;
        }
        ArrayList<RedisKey> keysToOperateOn = new ArrayList<RedisKey>();
        keysToOperateOn.add(oldKey);
        keysToOperateOn.add(newKey);
        return (Boolean)this.invoke("REDIS_RENAME_FUNCTION", oldKey, oldKey, newKey, keysToOperateOn, new ArrayList(), new ArrayList());
    }
}

