/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.key;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.executor.GlobPattern;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;
import org.apache.logging.log4j.Logger;

public class KeysExecutor
extends AbstractExecutor {
    private static final Logger logger = LogService.getLogger();

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        Pattern pattern;
        List<byte[]> commandElems = command.getProcessedCommand();
        String glob = Coder.bytesToString(commandElems.get(1));
        Set allKeys = this.getDataRegion(context).keySet();
        ArrayList<ByteArrayWrapper> matchingKeys = new ArrayList<ByteArrayWrapper>();
        try {
            pattern = GlobPattern.compile(glob);
        }
        catch (PatternSyntaxException e) {
            logger.warn("Could not compile the pattern: '{}' due to the following exception: '{}'. KEYS will return an empty list.", (Object)glob, (Object)e.getMessage());
            return RedisResponse.emptyArray();
        }
        for (ByteArrayWrapper bytesKey : allKeys) {
            String key = bytesKey.toString();
            if (!pattern.matcher(key).matches()) continue;
            matchingKeys.add(bytesKey);
        }
        if (matchingKeys.isEmpty()) {
            return RedisResponse.emptyArray();
        }
        return this.respondBulkStrings(matchingKeys);
    }
}

