/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.redis.internal.netty.Coder;

public class ByteArrayWrapper
implements DataSerializableFixedID,
Comparable<ByteArrayWrapper> {
    protected byte[] value;

    public ByteArrayWrapper() {
    }

    public ByteArrayWrapper(byte[] value) {
        this.value = value;
    }

    public String toString() {
        return Coder.bytesToString(this.value);
    }

    public byte[] toBytes() {
        return this.value;
    }

    public void setBytes(byte[] bytes) {
        this.value = bytes;
    }

    public int length() {
        return this.value.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof ByteArrayWrapper) {
            return Arrays.equals(this.value, ((ByteArrayWrapper)other).value);
        }
        if (other instanceof String) {
            return Arrays.equals(this.value, Coder.stringToBytes((String)other));
        }
        return false;
    }

    @Override
    public int compareTo(ByteArrayWrapper other) {
        return this.arrayCmp(this.value, other.value);
    }

    private int arrayCmp(byte[] A, byte[] B) {
        if (A == B) {
            return 0;
        }
        if (A == null) {
            return -1;
        }
        if (B == null) {
            return 1;
        }
        int len = Math.min(A.length, B.length);
        for (int i = 0; i < len; ++i) {
            byte a = A[i];
            byte b = B[i];
            int diff = a - b;
            if (diff > 0) {
                return 1;
            }
            if (diff >= 0) continue;
            return -1;
        }
        if (A.length > B.length) {
            return 1;
        }
        if (B.length > A.length) {
            return -1;
        }
        return 0;
    }

    private static byte[] concatArrays(byte[] o, byte[] n) {
        int oLen = o.length;
        int nLen = n.length;
        byte[] combined = new byte[oLen + nLen];
        System.arraycopy(o, 0, combined, 0, oLen);
        System.arraycopy(n, 0, combined, oLen, nLen);
        return combined;
    }

    public void append(byte[] appendBytes) {
        this.setBytes(ByteArrayWrapper.concatArrays(this.value, appendBytes));
    }

    public int getDSFID() {
        return 70;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeByteArray((byte[])this.value, (DataOutput)out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.value = DataSerializer.readByteArray((DataInput)in);
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

