/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.store.memory.iterator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.geaflow.common.iterator.CloseableIterator;
import org.apache.geaflow.model.graph.edge.IEdge;
import org.apache.geaflow.state.graph.encoder.EdgeAtom;
import org.apache.geaflow.state.pushdown.IStatePushDown;
import org.apache.geaflow.state.pushdown.filter.inner.GraphFilter;
import org.apache.geaflow.state.pushdown.filter.inner.IGraphFilter;
import org.apache.geaflow.state.pushdown.limit.IEdgeLimit;

public class MemoryEdgeScanPushDownIterator<K, VV, EV>
implements CloseableIterator<List<IEdge<K, EV>>> {
    private final Iterator<List<IEdge<K, EV>>> iterator;
    private final Comparator<IEdge> edgeComparator;
    private final IEdgeLimit edgeLimit;
    private final IGraphFilter filter;
    private List<IEdge<K, EV>> nextValue;

    public MemoryEdgeScanPushDownIterator(Iterator<List<IEdge<K, EV>>> iterator, IStatePushDown pushdown) {
        this.filter = (IGraphFilter)pushdown.getFilter();
        this.edgeLimit = pushdown.getEdgeLimit();
        List orderFields = pushdown.getOrderFields();
        this.edgeComparator = EdgeAtom.getComparator((List)orderFields);
        this.iterator = iterator;
    }

    public boolean hasNext() {
        if (this.iterator.hasNext()) {
            ArrayList list = Lists.newArrayList((Iterable)this.iterator.next());
            if (this.edgeComparator != null) {
                list.sort(this.edgeComparator);
            }
            ArrayList<IEdge<K, EV>> res = new ArrayList<IEdge<K, EV>>(list.size());
            Iterator it = list.iterator();
            IGraphFilter filter = GraphFilter.of((IGraphFilter)this.filter, (IEdgeLimit)this.edgeLimit);
            while (it.hasNext() && !filter.dropAllRemaining()) {
                IEdge edge = (IEdge)it.next();
                if (!filter.filterEdge(edge)) continue;
                res.add(edge);
            }
            this.nextValue = res;
            return true;
        }
        return false;
    }

    public List<IEdge<K, EV>> next() {
        return this.nextValue;
    }

    public void close() {
    }
}

