/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.store.memory.csr.vertex.type;

import java.util.BitSet;
import org.apache.geaflow.common.tuple.Tuple;
import org.apache.geaflow.model.graph.vertex.IVertex;
import org.apache.geaflow.model.graph.vertex.impl.IDVertex;
import org.apache.geaflow.store.memory.csr.vertex.IVertexArray;

public class IDVertexArray<K>
implements IVertexArray<K, Object> {
    private int[] vId2EPos;
    protected BitSet nullVertexBitSet;

    @Override
    public void init(int capacity) {
        this.vId2EPos = new int[capacity + 1];
        this.nullVertexBitSet = new BitSet();
    }

    @Override
    public Tuple<Integer, Integer> getEdgePosRange(int pos) {
        if (pos < this.vId2EPos.length - 1) {
            return Tuple.of((Object)this.vId2EPos[pos], (Object)this.vId2EPos[pos + 1]);
        }
        return Tuple.of((Object)0, (Object)0);
    }

    @Override
    public IVertex<K, Object> getVertex(K key, int pos) {
        return this.containsVertex(pos) ? new IDVertex(key) : null;
    }

    protected boolean containsVertex(int pos) {
        return !this.nullVertexBitSet.get(pos);
    }

    @Override
    public void drop() {
        this.vId2EPos = null;
    }

    @Override
    public void set(int pos, IVertex<K, Object> vertex) {
        if (vertex == null) {
            this.nullVertexBitSet.set(pos);
        }
        this.vId2EPos[pos + 1] = this.vId2EPos[pos];
    }

    @Override
    public int getNextPos(int pos) {
        return this.vId2EPos[pos + 1];
    }

    @Override
    public void updateVId2EPos(int pos) {
        this.vId2EPos[pos + 1] = this.vId2EPos[pos + 1] + 1;
    }
}

