/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.store.memory.csr.edge.type;

import org.apache.geaflow.model.graph.IGraphElementWithLabelField;
import org.apache.geaflow.model.graph.IGraphElementWithTimeField;
import org.apache.geaflow.model.graph.edge.IEdge;
import org.apache.geaflow.model.graph.edge.impl.ValueLabelTimeEdge;
import org.apache.geaflow.store.memory.csr.edge.type.ValueEdgeArray;

public class ValueLabelTimeEdgeArray<K>
extends ValueEdgeArray<K> {
    private String[] labels;
    private long[] times;

    @Override
    public void init(Class<K> keyType, int capacity) {
        super.init(keyType, capacity);
        this.labels = new String[capacity];
        this.times = new long[capacity];
    }

    @Override
    protected IEdge<K, Object> getEdge(K sid, int pos) {
        return new ValueLabelTimeEdge(sid, this.getDstId(pos), this.getValue(pos), this.getDirection(pos), this.labels[pos], this.times[pos]);
    }

    @Override
    public void drop() {
        super.drop();
        this.labels = null;
        this.times = null;
    }

    @Override
    public void set(int pos, IEdge<K, Object> edge) {
        super.set(pos, edge);
        this.labels[pos] = ((IGraphElementWithLabelField)edge).getLabel().intern();
        this.times[pos] = ((IGraphElementWithTimeField)edge).getTime();
    }
}

