/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.store.memory.csr.edge.type;

import java.util.ArrayList;
import java.util.List;
import org.apache.geaflow.collection.array.PrimitiveArray;
import org.apache.geaflow.collection.array.PrimitiveArrayFactory;
import org.apache.geaflow.model.graph.edge.EdgeDirection;
import org.apache.geaflow.model.graph.edge.IEdge;
import org.apache.geaflow.model.graph.edge.impl.IDEdge;
import org.apache.geaflow.store.memory.csr.edge.IEdgeArray;

public class IDEdgeArray<K>
implements IEdgeArray<K, Object> {
    private PrimitiveArray<K> dstIds;
    private PrimitiveArray<Byte> directions;

    @Override
    public void init(Class<K> keyType, int capacity) {
        this.dstIds = PrimitiveArrayFactory.getCustomArray(keyType, (int)capacity);
        this.directions = PrimitiveArrayFactory.getCustomArray(Byte.class, (int)capacity);
    }

    @Override
    public List<IEdge<K, Object>> getRangeEdges(K sid, int start, int end) {
        ArrayList<IEdge<K, Object>> edges = new ArrayList<IEdge<K, Object>>(end - start);
        for (int i = start; i < end; ++i) {
            edges.add(this.getEdge(sid, i));
        }
        return edges;
    }

    protected IEdge<K, Object> getEdge(K sid, int pos) {
        return new IDEdge(sid, this.getDstId(pos), this.getDirection(pos));
    }

    protected K getDstId(int pos) {
        return (K)this.dstIds.get(pos);
    }

    protected EdgeDirection getDirection(int pos) {
        return EdgeDirection.values()[(Byte)this.directions.get(pos)];
    }

    @Override
    public void drop() {
        this.dstIds = null;
        this.directions = null;
    }

    @Override
    public void set(int pos, IEdge<K, Object> edge) {
        this.dstIds.set(pos, edge.getTargetId());
        this.directions.set(pos, (Object)((byte)edge.getDirect().ordinal()));
    }
}

