/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.store.memory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geaflow.common.iterator.CloseableIterator;
import org.apache.geaflow.common.tuple.Tuple;
import org.apache.geaflow.model.graph.edge.IEdge;
import org.apache.geaflow.model.graph.vertex.IVertex;
import org.apache.geaflow.state.iterator.IteratorWithClose;
import org.apache.geaflow.state.iterator.IteratorWithFnThenFilter;
import org.apache.geaflow.store.context.StoreContext;
import org.apache.geaflow.store.memory.BaseStaticGraphMemoryStore;

public class StaticGraphMemoryStore<K, VV, EV>
extends BaseStaticGraphMemoryStore<K, VV, EV> {
    protected Map<K, Tuple<IVertex<K, VV>, List<IEdge<K, EV>>>> map;

    @Override
    public void init(StoreContext context) {
        super.init(context);
        this.map = new ConcurrentHashMap<K, Tuple<IVertex<K, VV>, List<IEdge<K, EV>>>>();
    }

    public void addEdge(IEdge<K, EV> edge) {
        Object srcId = edge.getSrcId();
        Tuple v = this.map.computeIfAbsent(srcId, k -> Tuple.of(null, new ArrayList()));
        ((List)v.f1).add(edge);
    }

    public void addVertex(IVertex<K, VV> vertex) {
        Object srcId = vertex.getId();
        Tuple v = this.map.computeIfAbsent(srcId, k -> Tuple.of(null, new ArrayList()));
        v.f0 = vertex;
    }

    @Override
    protected IVertex<K, VV> getVertex(K sid) {
        Tuple<IVertex<K, VV>, List<IEdge<K, EV>>> v = this.map.get(sid);
        return v == null ? null : (IVertex)v.f0;
    }

    @Override
    protected List<IEdge<K, EV>> getEdges(K sid) {
        Tuple<IVertex<K, VV>, List<IEdge<K, EV>>> v = this.map.get(sid);
        return v == null ? Collections.EMPTY_LIST : (List)v.f1;
    }

    @Override
    protected CloseableIterator<List<IEdge<K, EV>>> getEdgesIterator() {
        return IteratorWithClose.wrap(this.map.values().stream().map(c -> (List)c.f1).iterator());
    }

    @Override
    protected CloseableIterator<IVertex<K, VV>> getVertexIterator() {
        return new IteratorWithFnThenFilter(this.map.values().iterator(), c -> (IVertex)c.f0, Objects::nonNull);
    }

    @Override
    protected CloseableIterator<K> getKeyIterator() {
        return IteratorWithClose.wrap(this.map.keySet().iterator());
    }

    public void close() {
    }

    public void archive(long checkpointId) {
    }

    public void recovery(long checkpointId) {
    }

    public long recoveryLatest() {
        return 0L;
    }

    public void compact() {
    }

    public void flush() {
    }

    public void drop() {
    }
}

