/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.store.memory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.geaflow.collection.array.PrimitiveArray;
import org.apache.geaflow.collection.array.PrimitiveArrayFactory;
import org.apache.geaflow.collection.map.MapFactory;
import org.apache.geaflow.common.iterator.CloseableIterator;
import org.apache.geaflow.common.tuple.Tuple;
import org.apache.geaflow.model.graph.edge.IEdge;
import org.apache.geaflow.model.graph.vertex.IVertex;
import org.apache.geaflow.state.data.OneDegreeGraph;
import org.apache.geaflow.state.iterator.IteratorWithClose;
import org.apache.geaflow.state.iterator.IteratorWithFn;
import org.apache.geaflow.state.iterator.IteratorWithFnThenFilter;
import org.apache.geaflow.state.pushdown.IStatePushDown;
import org.apache.geaflow.state.pushdown.filter.IFilter;
import org.apache.geaflow.state.pushdown.filter.inner.GraphFilter;
import org.apache.geaflow.state.pushdown.filter.inner.IGraphFilter;
import org.apache.geaflow.state.pushdown.limit.IEdgeLimit;
import org.apache.geaflow.state.schema.GraphDataSchema;
import org.apache.geaflow.store.context.StoreContext;
import org.apache.geaflow.store.memory.BaseStaticGraphMemoryStore;
import org.apache.geaflow.store.memory.csr.edge.EdgeArrayFactory;
import org.apache.geaflow.store.memory.csr.edge.IEdgeArray;
import org.apache.geaflow.store.memory.csr.vertex.IVertexArray;
import org.apache.geaflow.store.memory.csr.vertex.VertexArrayFactory;

public class StaticGraphMemoryCSRStore<K, VV, EV>
extends BaseStaticGraphMemoryStore<K, VV, EV> {
    private CSRStore<K, VV, EV> csrStore;
    private boolean isBuilt;
    private List<IVertex<K, VV>> vertexList;
    private List<IEdge<K, EV>> edgesList;

    @Override
    public void init(StoreContext context) {
        super.init(context);
        this.isBuilt = false;
        this.vertexList = new ArrayList<IVertex<K, VV>>();
        this.edgesList = new ArrayList<IEdge<K, EV>>();
        this.csrStore = new CSRStore(context);
    }

    public void addEdge(IEdge<K, EV> edge) {
        Preconditions.checkArgument((!this.isBuilt ? 1 : 0) != 0, (Object)"cannot add vertex/edge after flush.");
        this.edgesList.add(edge);
    }

    public void addVertex(IVertex<K, VV> vertex) {
        Preconditions.checkArgument((!this.isBuilt ? 1 : 0) != 0, (Object)"cannot add vertex/edge after flush.");
        this.vertexList.add(vertex);
    }

    @Override
    protected IVertex<K, VV> getVertex(K sid) {
        Preconditions.checkArgument((boolean)this.isBuilt, (Object)"flush first.");
        return this.csrStore.getVertex(sid);
    }

    @Override
    protected List<IEdge<K, EV>> getEdges(K sid) {
        Preconditions.checkArgument((boolean)this.isBuilt, (Object)"flush first.");
        return this.csrStore.getEdges(sid);
    }

    @Override
    public OneDegreeGraph<K, VV, EV> getOneDegreeGraph(K sid, IStatePushDown pushdown) {
        int pos = this.csrStore.getDictId(sid);
        return this.getOneDegreeGraph(sid, pos, pushdown);
    }

    public OneDegreeGraph<K, VV, EV> getOneDegreeGraph(K sid, int pos, IStatePushDown pushdown) {
        List<IEdge<K, EV>> stream;
        OneDegreeGraph oneDegreeGraph;
        IGraphFilter filter = GraphFilter.of((IFilter)pushdown.getFilter(), (IEdgeLimit)pushdown.getEdgeLimit());
        if (pos == -1) {
            return new OneDegreeGraph(sid, null, (CloseableIterator)IteratorWithClose.wrap(Collections.emptyIterator()));
        }
        IVertex vertex = ((CSRStore)this.csrStore).getVertex(sid, pos);
        if (vertex == null || !filter.filterVertex(vertex)) {
            vertex = null;
        }
        return filter.filterOneDegreeGraph(oneDegreeGraph = new OneDegreeGraph(sid, vertex, (CloseableIterator)IteratorWithClose.wrap((stream = this.pushdownEdges(this.csrStore.getEdges(sid, pos), pushdown)).iterator()))) ? oneDegreeGraph : null;
    }

    public void archive(long checkpointId) {
    }

    public void recovery(long checkpointId) {
    }

    public long recoveryLatest() {
        return 0L;
    }

    public void compact() {
    }

    public void flush() {
        this.csrStore.build(this.vertexList, this.edgesList);
        this.vertexList = null;
        this.edgesList = null;
        this.isBuilt = true;
    }

    public void close() {
    }

    @Override
    protected CloseableIterator<List<IEdge<K, EV>>> getEdgesIterator() {
        Preconditions.checkArgument((boolean)this.isBuilt, (Object)"flush first.");
        return new IteratorWithFn((Iterator)IntStream.range(0, this.csrStore.getDict().size()).iterator(), p -> this.csrStore.getEdges(((CSRStore)this.csrStore).reverse.get(p.intValue()), (int)p));
    }

    @Override
    protected CloseableIterator<IVertex<K, VV>> getVertexIterator() {
        Preconditions.checkArgument((boolean)this.isBuilt, (Object)"flush first.");
        return new IteratorWithFnThenFilter((Iterator)IntStream.range(0, this.csrStore.getDict().size()).iterator(), p -> ((CSRStore)this.csrStore).getVertex(((CSRStore)this.csrStore).reverse.get(p.intValue()), p), Objects::nonNull);
    }

    @Override
    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(IStatePushDown pushdown) {
        Preconditions.checkArgument((boolean)this.isBuilt, (Object)"flush first.");
        return new IteratorWithFnThenFilter((Iterator)IntStream.range(0, this.csrStore.getDict().size()).iterator(), p -> {
            Object k = ((CSRStore)this.csrStore).reverse.get(p.intValue());
            return this.getOneDegreeGraph((K)k, (int)p, pushdown);
        }, Objects::nonNull);
    }

    @Override
    protected CloseableIterator<K> getKeyIterator() {
        return IteratorWithClose.wrap(this.csrStore.getDict().keySet().iterator());
    }

    public void drop() {
        this.csrStore.drop();
    }

    public static class CSRStore<K, VV, EV> {
        public static final int NON_EXIST = -1;
        private final Class<K> keyClazz;
        private Map<K, Integer> kDict;
        private IVertexArray<K, VV> vertexArray;
        private IEdgeArray<K, EV> edgeArray;
        private PrimitiveArray<K> reverse;

        public CSRStore(StoreContext context) {
            GraphDataSchema graphDataSchema = context.getGraphSchema();
            this.keyClazz = graphDataSchema.getKeyType().getTypeClass();
            this.kDict = MapFactory.buildMap(this.keyClazz, Integer.TYPE);
            this.vertexArray = VertexArrayFactory.getVertexArray(graphDataSchema);
            this.edgeArray = EdgeArrayFactory.getEdgeArray(graphDataSchema);
        }

        public int getDictIdOrRegister(K id) {
            int res = this.kDict.computeIfAbsent(id, k -> this.kDict.size());
            return res;
        }

        public int getDictId(K id) {
            return this.kDict.getOrDefault(id, -1);
        }

        public Map<K, Integer> getDict() {
            return this.kDict;
        }

        public List<IEdge<K, EV>> getEdges(K sid) {
            int pos = this.getDictId(sid);
            return pos == -1 ? Collections.EMPTY_LIST : this.getEdges(sid, pos);
        }

        public List<IEdge<K, EV>> getEdges(K sid, int pos) {
            Tuple<Integer, Integer> edgePosRange = this.vertexArray.getEdgePosRange(pos);
            return this.edgeArray.getRangeEdges(sid, (Integer)edgePosRange.f0, (Integer)edgePosRange.f1);
        }

        public IVertex<K, VV> getVertex(K id) {
            int pos = this.getDictId(id);
            return pos == -1 ? null : this.getVertex(id, pos);
        }

        private IVertex<K, VV> getVertex(K id, int pos) {
            return this.vertexArray.getVertex(id, pos);
        }

        /*
         * WARNING - void declaration
         */
        public void build(List<IVertex<K, VV>> vertexList, List<IEdge<K, EV>> edgesList) {
            void var5_10;
            ArrayList edgesListTmp = new ArrayList();
            for (IVertex<K, VV> iVertex : vertexList) {
                int dictId = this.getDictIdOrRegister(iVertex.getId());
                edgesListTmp.add(dictId, new LinkedList());
            }
            edgesList.forEach(edge -> {
                int oldSize = this.kDict.size();
                int dictId = this.getDictIdOrRegister(edge.getSrcId());
                if (dictId > oldSize - 1) {
                    vertexList.add(dictId, null);
                    edgesListTmp.add(dictId, new LinkedList());
                }
                ((List)edgesListTmp.get(dictId)).add(edge);
            });
            this.reverse = PrimitiveArrayFactory.getCustomArray(this.keyClazz, (int)this.kDict.size());
            for (Map.Entry entry : this.kDict.entrySet()) {
                this.reverse.set(((Integer)entry.getValue()).intValue(), entry.getKey());
            }
            this.vertexArray.init(vertexList.size());
            int edgesNum = edgesListTmp.stream().mapToInt(value -> value != null ? value.size() : 0).sum();
            this.edgeArray.init(this.keyClazz, edgesNum);
            boolean bl = false;
            while (var5_10 < vertexList.size()) {
                this.vertexArray.set((int)var5_10, vertexList.get((int)var5_10));
                if (edgesListTmp.get((int)var5_10) != null && !((List)edgesListTmp.get((int)var5_10)).isEmpty()) {
                    for (IEdge edge2 : (List)edgesListTmp.get((int)var5_10)) {
                        int nextPos = this.vertexArray.getNextPos((int)var5_10);
                        this.edgeArray.set(nextPos, edge2);
                        this.vertexArray.updateVId2EPos((int)var5_10);
                    }
                }
                ++var5_10;
            }
        }

        public void drop() {
            this.kDict = null;
            this.vertexArray = null;
            this.edgeArray = null;
        }
    }
}

