/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.store.memory;

import java.util.Arrays;
import java.util.List;
import org.apache.geaflow.common.config.Configuration;
import org.apache.geaflow.common.errorcode.RuntimeErrors;
import org.apache.geaflow.common.exception.GeaflowRuntimeException;
import org.apache.geaflow.state.DataModel;
import org.apache.geaflow.state.StoreType;
import org.apache.geaflow.store.IBaseStore;
import org.apache.geaflow.store.IStoreBuilder;
import org.apache.geaflow.store.StoreDesc;
import org.apache.geaflow.store.memory.DynamicGraphMemoryStore;
import org.apache.geaflow.store.memory.KListMemoryStore;
import org.apache.geaflow.store.memory.KMapMemoryStore;
import org.apache.geaflow.store.memory.KVMemoryStore;
import org.apache.geaflow.store.memory.MemoryConfigKeys;
import org.apache.geaflow.store.memory.StaticGraphMemoryCSRStore;
import org.apache.geaflow.store.memory.StaticGraphMemoryStore;

public class MemoryStoreBuilder
implements IStoreBuilder {
    private static final StoreDesc STORE_DESC = new MemoryStoreDesc();

    public IBaseStore getStore(DataModel type, Configuration config) {
        switch (type) {
            case DYNAMIC_GRAPH: {
                return new DynamicGraphMemoryStore();
            }
            case STATIC_GRAPH: {
                boolean csrEnable = config.getBoolean(MemoryConfigKeys.CSR_MEMORY_ENABLE);
                return csrEnable ? new StaticGraphMemoryCSRStore() : new StaticGraphMemoryStore();
            }
            case KV: {
                return new KVMemoryStore();
            }
            case KList: {
                return new KListMemoryStore();
            }
            case KMap: {
                return new KMapMemoryStore();
            }
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError("not support " + type));
    }

    public StoreDesc getStoreDesc() {
        return STORE_DESC;
    }

    public List<DataModel> supportedDataModel() {
        return Arrays.asList(DataModel.values());
    }

    public static class MemoryStoreDesc
    implements StoreDesc {
        public boolean isLocalStore() {
            return false;
        }

        public String name() {
            return StoreType.MEMORY.name();
        }
    }
}

