/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.store.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geaflow.store.IStatefulStore;
import org.apache.geaflow.store.api.key.IKMapStore;
import org.apache.geaflow.store.context.StoreContext;

public class KMapMemoryStore<K, UK, UV>
implements IStatefulStore,
IKMapStore<K, UK, UV> {
    private Map<K, Map<UK, UV>> memoryStore = new HashMap<K, Map<UK, UV>>();

    public Map<UK, UV> get(K key) {
        return this.memoryStore.getOrDefault(key, new HashMap());
    }

    public List<UV> get(K key, UK ... subKeys) {
        Map map = this.get(key);
        ArrayList list = new ArrayList(subKeys.length);
        Arrays.stream(subKeys).forEach(c -> list.add(map.get(c)));
        return list;
    }

    public void add(K key, UK subKey, UV value) {
        Map map = this.memoryStore.computeIfAbsent(key, k -> new HashMap());
        map.put(subKey, value);
    }

    public void add(K key, Map<UK, UV> map) {
        Map tmp = this.memoryStore.computeIfAbsent(key, k -> new HashMap());
        tmp.putAll(map);
    }

    public void remove(K key) {
        this.memoryStore.remove(key);
    }

    public void remove(K key, UK ... subKeys) {
        if (this.memoryStore.containsKey(key)) {
            Map<UK, UV> map = this.get(key);
            Arrays.stream(subKeys).forEach(map::remove);
        }
    }

    public void init(StoreContext storeContext) {
    }

    public void flush() {
    }

    public void close() {
        this.memoryStore.clear();
    }

    public void archive(long checkpointId) {
    }

    public void recovery(long checkpointId) {
    }

    public long recoveryLatest() {
        return 0L;
    }

    public void compact() {
    }

    public void drop() {
    }
}

