/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geaflow.store.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geaflow.store.IStatefulStore;
import org.apache.geaflow.store.api.key.IKListStore;
import org.apache.geaflow.store.context.StoreContext;

public class KListMemoryStore<K, V>
implements IStatefulStore,
IKListStore<K, V> {
    private Map<K, List<V>> memoryStore = new HashMap<K, List<V>>();

    public void add(K key, V ... value) {
        List list = this.memoryStore.computeIfAbsent(key, k -> new ArrayList());
        list.addAll(Arrays.asList(value));
        this.memoryStore.put(key, list);
    }

    public void remove(K key) {
        this.memoryStore.remove(key);
    }

    public List<V> get(K key) {
        return this.memoryStore.getOrDefault(key, new ArrayList());
    }

    public void init(StoreContext storeContext) {
    }

    public void flush() {
    }

    public void close() {
        this.memoryStore.clear();
    }

    public void archive(long checkpointId) {
    }

    public void recovery(long checkpointId) {
    }

    public long recoveryLatest() {
        return 0L;
    }

    public void compact() {
    }

    public void drop() {
    }
}

